/*
 * Decompiled with CFR 0.152.
 */
package com.openatlas.util;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import com.openatlas.hack.AssertionArrayException;
import com.openatlas.hack.OpenAtlasHacks;
import com.openatlas.log.Logger;
import com.openatlas.log.LoggerFactory;
import com.openatlas.runtime.PackageLite;
import com.openatlas.util.PackageValidate;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.security.cert.Certificate;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class ApkUtils {
    static final int SYSTEM_ROOT_STATE_DISABLE = 0;
    static final int SYSTEM_ROOT_STATE_ENABLE = 1;
    static final int SYSTEM_ROOT_STATE_UNKNOW = -1;
    static final Logger log = LoggerFactory.getInstance("ApkUtils");
    private static int systemRootState = -1;

    private static boolean assertAtlasHacks() {
        try {
            return OpenAtlasHacks.defineAndVerify();
        }
        catch (AssertionArrayException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static final PackageInfo parsePackageInfo(Context context, String str) {
        if (!ApkUtils.assertAtlasHacks()) {
            return null;
        }
        try {
            PackageLite parse = PackageLite.parse(new File(str));
            PackageInfo packageInfo = new PackageInfo();
            packageInfo.packageName = parse.packageName;
            packageInfo.versionCode = parse.versionCode;
            packageInfo.versionName = parse.versionName;
            packageInfo.applicationInfo = new ApplicationInfo();
            packageInfo.applicationInfo.metaData = parse.metaData;
            return packageInfo;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String[] getApkPublicKey(String apkPath) {
        JarFile jarFile = null;
        try {
            Certificate[] loadCertificates;
            jarFile = new JarFile(apkPath);
            JarEntry jarEntry = jarFile.getJarEntry("classes.dex");
            if (jarEntry != null && (loadCertificates = PackageValidate.loadCertificates(jarFile, jarEntry, new byte[4096])) != null) {
                String[] strArr = new String[loadCertificates.length];
                for (int i = 0; i < loadCertificates.length; ++i) {
                    strArr[i] = ApkUtils.bytesToHexString(loadCertificates[i].getPublicKey().getEncoded());
                }
            }
        }
        catch (IOException e) {
            jarFile = null;
            log.warn("Exception reading public key from apk file " + apkPath, (Throwable)e);
            String[] stringArray = null;
            return stringArray;
        }
        catch (Throwable e) {
            e.printStackTrace();
            jarFile = null;
        }
        finally {
            if (jarFile != null) {
                try {
                    jarFile.close();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
        }
        return null;
    }

    private static final String bytesToHexString(byte[] bArr) {
        StringBuilder stringBuilder = new StringBuilder();
        if (bArr == null || bArr.length <= 0) {
            return null;
        }
        for (int i = 0; i < bArr.length; ++i) {
            String toHexString = Integer.toHexString(bArr[i] & 0xFF);
            if (toHexString.length() < 2) {
                stringBuilder.append(0);
            }
            stringBuilder.append(toHexString);
        }
        return stringBuilder.toString();
    }

    public static final void chmod(File file) {
        if (file != null && !file.exists()) {
            file.mkdirs();
            try {
                Runtime.getRuntime().exec("chmod 555 " + file.getAbsolutePath());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static boolean isRootSystem() {
        if (systemRootState == -1) {
            String[] strArr = new String[]{"/system/bin/", "/system/xbin/", "/system/sbin/", "/sbin/", "/vendor/bin/"};
            int length = strArr.length;
            for (int i = 0; i < length; ++i) {
                if (!new File(strArr[i], "su").exists()) continue;
                systemRootState = 1;
                return true;
            }
            return false;
        }
        return systemRootState == 1;
    }

    public static void copyInputStreamToFile(InputStream inputStream, File file) throws IOException {
        block25: {
            FileOutputStream fileOutputStream = null;
            FileChannel fileChannel = null;
            try {
                fileOutputStream = new FileOutputStream(file);
                try {
                    int read;
                    fileChannel = fileOutputStream.getChannel();
                    byte[] bArr = new byte[4096];
                    while ((read = inputStream.read(bArr)) > 0) {
                        fileChannel.write(ByteBuffer.wrap(bArr, 0, read));
                    }
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    if (fileChannel != null) {
                        try {
                            fileChannel.close();
                        }
                        catch (Exception e2) {
                            e2.printStackTrace();
                        }
                    }
                    if (fileOutputStream != null) {
                        try {
                            fileOutputStream.close();
                        }
                        catch (Exception e22) {
                            e22.printStackTrace();
                        }
                    }
                }
                catch (Throwable th2) {
                    Throwable th = th2;
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Exception e3) {
                            e3.printStackTrace();
                        }
                    }
                    if (fileChannel != null) {
                        try {
                            fileChannel.close();
                        }
                        catch (Exception e4) {
                            e4.printStackTrace();
                        }
                    }
                    if (fileOutputStream != null) {
                        try {
                            fileOutputStream.close();
                        }
                        catch (Exception e42) {
                            e42.printStackTrace();
                        }
                    }
                    throw th;
                }
            }
            catch (Throwable th3) {
                Throwable th = th3;
                FileChannel obj = fileChannel;
                if (inputStream != null) {
                    inputStream.close();
                }
                if (fileChannel != null) {
                    fileChannel.close();
                }
                if (fileOutputStream == null) break block25;
                fileOutputStream.close();
            }
        }
    }
}

