/*
 * Decompiled with CFR 0.152.
 */
package com.openatlas.runtime;

import android.content.Context;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Handler;
import android.os.Message;
import android.os.Process;
import android.util.Log;
import android.widget.Toast;
import com.openatlas.framework.Atlas;
import com.openatlas.framework.Framework;
import com.openatlas.runtime.RuntimeVariables;
import com.openatlas.util.ApkUtils;
import com.openatlas.util.StringUtils;
import java.util.List;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;

public class SecurityFrameListener
implements FrameworkListener {
    static final String TAG = "SecurityFrameListener";
    ShutdownProcessHandler shutdownProcessHandler = new ShutdownProcessHandler();

    @Override
    public void frameworkEvent(FrameworkEvent frameworkEvent) {
        switch (frameworkEvent.getType()) {
            case 1: {
                if (Build.VERSION.SDK_INT >= 11) {
                    new SecurityTask().executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new String[0]);
                    break;
                }
                new SecurityTask().execute(new String[0]);
            }
        }
    }

    public class ShutdownProcessHandler
    extends Handler {
        public void handleMessage(Message message) {
            Process.killProcess((int)Process.myPid());
        }
    }

    private class SecurityTask
    extends AsyncTask<String, Void, Boolean> {
        final String PUBLIC_KEY = Framework.getProperty("om.openAtlas.publickey");

        private SecurityTask() {
        }

        protected Boolean doInBackground(String ... strArr) {
            if (this.PUBLIC_KEY == null || this.PUBLIC_KEY.isEmpty()) {
                return true;
            }
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            List<Bundle> bundles = Atlas.getInstance().getBundles();
            if (bundles != null) {
                for (Bundle bundle : bundles) {
                    if (StringUtils.contains(ApkUtils.getApkPublicKey(Atlas.getInstance().getBundleFile(bundle.getLocation()).getAbsolutePath()), this.PUBLIC_KEY)) {
                        try {
                            Thread.sleep(500L);
                        }
                        catch (InterruptedException interruptedException) {}
                        continue;
                    }
                    Log.e((String)SecurityFrameListener.TAG, (String)("Security check failed. " + bundle.getLocation()));
                    return false;
                }
            }
            return true;
        }

        protected void onPostExecute(Boolean bool) {
            if (bool != null && !bool.booleanValue()) {
                Toast.makeText((Context)RuntimeVariables.androidApplication, (CharSequence)"\u68c0\u6d4b\u5230\u5b89\u88c5\u6587\u4ef6\u88ab\u635f\u574f\uff0c\u8bf7\u5378\u8f7d\u540e\u91cd\u65b0\u5b89\u88c5\uff01", (int)1).show();
                SecurityFrameListener.this.shutdownProcessHandler.sendEmptyMessageDelayed(0, 5000L);
            }
        }
    }
}

