/*
 * Decompiled with CFR 0.152.
 */
package com.openatlas.runtime;

import android.app.Application;
import android.content.res.AssetManager;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import com.openatlas.framework.BundleImpl;
import com.openatlas.framework.Framework;
import com.openatlas.hack.AndroidHack;
import com.openatlas.hack.OpenAtlasHacks;
import com.openatlas.log.Logger;
import com.openatlas.log.LoggerFactory;
import com.openatlas.runtime.RuntimeVariables;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.osgi.framework.Bundle;

public class DelegateResources
extends Resources {
    private static final String WebViewGoogleAssetPath = "/system/app/WebViewGoogle/WebViewGoogle.apk";
    private static Set<String> assetPathsHistory;
    private static Object lock;
    static final Logger log;
    private static List<String> mOriginAssetsPath;
    private Map<String, Integer> resIdentifierMap = new ConcurrentHashMap<String, Integer>();

    public DelegateResources(AssetManager assetManager, Resources resources) {
        super(assetManager, resources.getDisplayMetrics(), resources.getConfiguration());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void newDelegateResources(Application application, Resources resources, String newPath) throws Exception {
        if (Thread.currentThread().getId() == Looper.getMainLooper().getThread().getId()) {
            DelegateResources.newDelegateResourcesInternal(application, resources, newPath);
            return;
        }
        Object object = lock;
        synchronized (object) {
            new Handler(Looper.getMainLooper()).post((Runnable)new DelegateResourcesGetter(application, resources, newPath));
            lock.wait();
        }
    }

    private static void newDelegateResourcesInternal(Application application, Resources resources, String newPath) throws Exception {
        Set<String> generateNewAssetPaths = DelegateResources.generateNewAssetPaths(application, newPath);
        if (generateNewAssetPaths != null) {
            DelegateResources delegateResources;
            AssetManager assetManager = (AssetManager)AssetManager.class.newInstance();
            for (String assetPath : generateNewAssetPaths) {
                OpenAtlasHacks.AssetManager_addAssetPath.invoke(assetManager, assetPath);
            }
            if (resources == null || !resources.getClass().getName().equals("android.content.res.MiuiResources")) {
                delegateResources = new DelegateResources(assetManager, resources);
            } else {
                Constructor<?> declaredConstructor = Class.forName("android.content.res.MiuiResources").getDeclaredConstructor(AssetManager.class, DisplayMetrics.class, Configuration.class);
                declaredConstructor.setAccessible(true);
                delegateResources = (Resources)declaredConstructor.newInstance(assetManager, resources.getDisplayMetrics(), resources.getConfiguration());
            }
            RuntimeVariables.setDelegateResources(delegateResources);
            AndroidHack.injectResources(application, delegateResources);
            assetPathsHistory = generateNewAssetPaths;
            if (log.isDebugEnabled()) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("newDelegateResources [");
                for (String append : generateNewAssetPaths) {
                    stringBuffer.append(append).append(",");
                }
                stringBuffer.append("]");
                if (newPath != null) {
                    stringBuffer.append("Add new path:" + newPath);
                }
                log.debug(stringBuffer.toString());
            }
        }
    }

    public static List<String> getOriginAssetsPath(AssetManager assetManager) {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            Method declaredMethod = assetManager.getClass().getDeclaredMethod("getStringBlockCount", new Class[0]);
            declaredMethod.setAccessible(true);
            int intValue = (Integer)declaredMethod.invoke((Object)assetManager, new Object[0]);
            for (int i = 0; i < intValue; ++i) {
                String cookieName = (String)assetManager.getClass().getMethod("getCookieName", Integer.TYPE).invoke((Object)assetManager, i + 1);
                if (TextUtils.isEmpty((CharSequence)cookieName)) continue;
                arrayList.add(cookieName);
            }
            return arrayList;
        }
        catch (Exception th) {
            th.printStackTrace();
            arrayList.clear();
            return arrayList;
        }
    }

    public static String getAssetHistoryPaths() {
        if (assetPathsHistory == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("newDelegateResources [");
        for (String append : assetPathsHistory) {
            stringBuffer.append(append).append(",");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    private static Set<String> generateNewAssetPaths(Application application, String newPath) {
        if (newPath != null && assetPathsHistory != null && assetPathsHistory.contains(newPath)) {
            return null;
        }
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        linkedHashSet.add(application.getApplicationInfo().sourceDir);
        if (Build.VERSION.SDK_INT > 20) {
            try {
                if (mOriginAssetsPath == null || mOriginAssetsPath.indexOf(WebViewGoogleAssetPath) == -1) {
                    mOriginAssetsPath = DelegateResources.getOriginAssetsPath(application.getResources().getAssets());
                }
                if (mOriginAssetsPath != null && mOriginAssetsPath.indexOf(WebViewGoogleAssetPath) != -1) {
                    linkedHashSet.add(WebViewGoogleAssetPath);
                }
                if (assetPathsHistory != null) {
                    linkedHashSet.addAll(assetPathsHistory);
                }
                if (newPath == null) {
                    return linkedHashSet;
                }
                linkedHashSet.add(newPath);
                return linkedHashSet;
            }
            catch (Throwable th) {
                if (assetPathsHistory != null) {
                    linkedHashSet.addAll(assetPathsHistory);
                }
                if (newPath != null) {
                    return linkedHashSet;
                }
                linkedHashSet.add(newPath);
                return linkedHashSet;
            }
        }
        if (assetPathsHistory != null) {
            linkedHashSet.addAll(assetPathsHistory);
        }
        if (newPath == null) {
            return linkedHashSet;
        }
        linkedHashSet.add(newPath);
        return linkedHashSet;
    }

    public int getIdentifier(String str, String str2, String str3) {
        int identifier = super.getIdentifier(str, str2, str3);
        if (identifier != 0) {
            return identifier;
        }
        if (Build.VERSION.SDK_INT <= 19) {
            return 0;
        }
        if (str2 == null && str3 == null) {
            String substring = str.substring(str.indexOf("/") + 1);
            str2 = str.substring(str.indexOf(":") + 1, str.indexOf("/"));
            str = substring;
        }
        if (TextUtils.isEmpty((CharSequence)str) || TextUtils.isEmpty((CharSequence)str2)) {
            return 0;
        }
        List<Bundle> bundles = Framework.getBundles();
        if (bundles != null && !bundles.isEmpty()) {
            for (Bundle bundle : Framework.getBundles()) {
                ClassLoader classLoader;
                int intValue;
                String location = bundle.getLocation();
                String str4 = location + ":" + str;
                if (!this.resIdentifierMap.isEmpty() && this.resIdentifierMap.containsKey(str4) && (intValue = this.resIdentifierMap.get(str4).intValue()) != 0) {
                    return intValue;
                }
                BundleImpl bundleImpl = (BundleImpl)bundle;
                if (!bundleImpl.getArchive().isDexOpted() || (classLoader = bundleImpl.getClassLoader()) == null) continue;
                try {
                    StringBuilder stringBuilder = new StringBuilder(location);
                    stringBuilder.append(".R$");
                    stringBuilder.append(str2);
                    identifier = DelegateResources.getFieldValueOfR(classLoader.loadClass(stringBuilder.toString()), str);
                    if (identifier == 0) continue;
                    this.resIdentifierMap.put(str4, identifier);
                    return identifier;
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
            }
        }
        return 0;
    }

    public String getString(int i) throws Resources.NotFoundException {
        if (Build.VERSION.SDK_INT < 21 || i != 0x2040002 && i != 262146 && i != 50593794) {
            return super.getString(i);
        }
        return "Web View";
    }

    private static int getFieldValueOfR(Class<?> cls, String str) {
        if (cls != null) {
            try {
                Field declaredField = cls.getDeclaredField(str);
                if (declaredField != null) {
                    if (!declaredField.isAccessible()) {
                        declaredField.setAccessible(true);
                    }
                    return (Integer)declaredField.get(null);
                }
            }
            catch (NoSuchFieldException noSuchFieldException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return 0;
    }

    static {
        log = LoggerFactory.getInstance("DelegateResources");
        lock = new Object();
        mOriginAssetsPath = null;
    }

    static class DelegateResourcesGetter
    implements Runnable {
        Application application;
        String newPath;
        Resources res;

        public DelegateResourcesGetter(Application application, Resources res, String newPath) {
            this.application = application;
            this.res = res;
            this.newPath = newPath;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                DelegateResources.newDelegateResourcesInternal(this.application, this.res, this.newPath);
                Object object = lock;
                synchronized (object) {
                    lock.notify();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                Object object = lock;
                synchronized (object) {
                    lock.notify();
                }
            }
        }
    }
}

