/*
 * Decompiled with CFR 0.152.
 */
package com.openatlas.runtime;

import com.openatlas.framework.Framework;
import com.openatlas.runtime.ClassLoadFromBundle;
import java.util.List;
import org.osgi.framework.Bundle;

public class DelegateClassLoader
extends ClassLoader {
    public DelegateClassLoader(ClassLoader classLoader) {
        super(classLoader);
    }

    @Override
    public Class<?> loadClass(String className) throws ClassNotFoundException {
        return super.loadClass(className);
    }

    @Override
    protected Class<?> findClass(String className) throws ClassNotFoundException {
        ClassLoadFromBundle.checkInstallBundleIfNeed(className);
        Class<?> loadFromInstalledBundles = ClassLoadFromBundle.loadFromInstalledBundles(className);
        if (loadFromInstalledBundles != null) {
            return loadFromInstalledBundles;
        }
        throw new ClassNotFoundException("Can't find class " + className + this.printExceptionInfo() + " " + ClassLoadFromBundle.getClassNotFoundReason(className));
    }

    private String printExceptionInfo() {
        StringBuilder stringBuilder = new StringBuilder("installed bundles: ");
        List<Bundle> bundles = Framework.getBundles();
        if (bundles != null && !bundles.isEmpty()) {
            for (Bundle bundle : Framework.getBundles()) {
                stringBuilder.append(bundle.getLocation());
                stringBuilder.append(":");
            }
        }
        return stringBuilder.toString();
    }
}

