/*
 * Decompiled with CFR 0.152.
 */
package com.openatlas.runtime;

import android.content.ComponentName;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.res.AssetManager;
import android.content.res.Resources;
import android.text.TextUtils;
import com.openatlas.framework.BundleImpl;
import com.openatlas.framework.Framework;
import com.openatlas.log.Logger;
import com.openatlas.log.LoggerFactory;
import com.openatlas.runtime.ClassLoadFromBundle;
import com.openatlas.runtime.DelegateComponent;
import com.openatlas.runtime.RuntimeVariables;
import com.openatlas.util.StringUtils;
import org.osgi.framework.BundleException;

public class ContextImplHook
extends ContextWrapper {
    static final Logger log = LoggerFactory.getInstance("ContextImplHook");
    private ClassLoader classLoader = null;

    public ContextImplHook(Context context, ClassLoader classLoader) {
        super(context);
        this.classLoader = classLoader;
    }

    public Resources getResources() {
        return RuntimeVariables.getDelegateResources();
    }

    public AssetManager getAssets() {
        return RuntimeVariables.getDelegateResources().getAssets();
    }

    public PackageManager getPackageManager() {
        return this.getApplicationContext().getPackageManager();
    }

    public ClassLoader getClassLoader() {
        if (this.classLoader != null) {
            return this.classLoader;
        }
        return super.getClassLoader();
    }

    public void startActivity(Intent intent) {
        block12: {
            String packageName;
            String obj = null;
            if (intent.getComponent() != null) {
                packageName = intent.getComponent().getPackageName();
                obj = intent.getComponent().getClassName();
            } else {
                ResolveInfo resolveActivity = this.getBaseContext().getPackageManager().resolveActivity(intent, 0);
                if (resolveActivity == null || resolveActivity.activityInfo == null) {
                    packageName = null;
                } else {
                    packageName = resolveActivity.activityInfo.packageName;
                    obj = resolveActivity.activityInfo.name;
                }
            }
            ClassLoadFromBundle.checkInstallBundleIfNeed(obj);
            if (!StringUtils.equals(this.getBaseContext().getPackageName(), packageName)) {
                super.startActivity(intent);
            } else if (DelegateComponent.locateComponent(obj) != null) {
                super.startActivity(intent);
            } else {
                try {
                    if (Framework.getSystemClassLoader().loadClass(obj) != null) {
                        super.startActivity(intent);
                    }
                }
                catch (ClassNotFoundException e) {
                    log.error("Can't find class " + obj);
                    if (Framework.getClassNotFoundCallback() == null) break block12;
                    if (intent.getComponent() == null && !TextUtils.isEmpty((CharSequence)obj)) {
                        intent.setClassName((Context)this, obj);
                    }
                    if (intent.getComponent() == null) break block12;
                    Framework.getClassNotFoundCallback().returnIntent(intent);
                }
            }
        }
    }

    public boolean bindService(Intent service, ServiceConnection conn, int flags) {
        String packageName;
        String str = null;
        if (service.getComponent() != null) {
            packageName = service.getComponent().getPackageName();
            str = service.getComponent().getClassName();
        } else {
            ResolveInfo resolveService = this.getBaseContext().getPackageManager().resolveService(service, 0);
            if (resolveService == null || resolveService.serviceInfo == null) {
                packageName = null;
            } else {
                packageName = resolveService.serviceInfo.packageName;
                str = resolveService.serviceInfo.name;
            }
        }
        if (!StringUtils.equals(this.getBaseContext().getPackageName(), packageName)) {
            return super.bindService(service, conn, flags);
        }
        ClassLoadFromBundle.checkInstallBundleIfNeed(str);
        packageName = DelegateComponent.locateComponent(str);
        if (packageName != null) {
            BundleImpl bundleImpl = (BundleImpl)Framework.getBundle(packageName);
            if (bundleImpl != null) {
                try {
                    bundleImpl.startBundle();
                }
                catch (BundleException e) {
                    log.error(e.getMessage() + " Caused by: ", e.getNestedException());
                }
            }
            return super.bindService(service, conn, flags);
        }
        try {
            if (Framework.getSystemClassLoader().loadClass(str) != null) {
                return super.bindService(service, conn, flags);
            }
        }
        catch (ClassNotFoundException e2) {
            log.error("Can't find class " + str);
        }
        return false;
    }

    public ComponentName startService(Intent service) {
        String className;
        String packageName;
        if (service.getComponent() != null) {
            packageName = service.getComponent().getPackageName();
            className = service.getComponent().getClassName();
        } else {
            ResolveInfo resolveService = this.getBaseContext().getPackageManager().resolveService(service, 0);
            if (resolveService == null || resolveService.serviceInfo == null) {
                className = null;
                packageName = null;
            } else {
                packageName = resolveService.serviceInfo.packageName;
                className = resolveService.serviceInfo.name;
            }
        }
        if (!StringUtils.equals(this.getBaseContext().getPackageName(), packageName)) {
            return super.startService(service);
        }
        ClassLoadFromBundle.checkInstallBundleIfNeed(className);
        packageName = DelegateComponent.locateComponent(className);
        if (packageName != null) {
            BundleImpl bundleImpl = (BundleImpl)Framework.getBundle(packageName);
            if (bundleImpl != null) {
                try {
                    bundleImpl.startBundle();
                }
                catch (BundleException e) {
                    log.error(e.getMessage() + " Caused by: ", e.getNestedException());
                }
            }
            return super.startService(service);
        }
        try {
            if (Framework.getSystemClassLoader().loadClass(className) != null) {
                return super.startService(service);
            }
            return null;
        }
        catch (ClassNotFoundException e2) {
            log.error("Can't find class " + className);
            return null;
        }
    }
}

