/*
 * Decompiled with CFR 0.152.
 */
package com.openatlas.runtime;

import android.content.pm.PackageInfo;
import android.text.TextUtils;
import android.util.Log;
import com.openatlas.boot.Globals;
import com.openatlas.bundleInfo.BundleInfoList;
import com.openatlas.framework.Atlas;
import com.openatlas.framework.AtlasConfig;
import com.openatlas.framework.BundleImpl;
import com.openatlas.framework.Framework;
import com.openatlas.runtime.DelegateComponent;
import com.openatlas.runtime.PackageLite;
import com.openatlas.runtime.RuntimeVariables;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;

public class ClassLoadFromBundle {
    private static final String TAG = "ClassLoadFromBundle";
    private static Hashtable<Integer, String> classNotFoundReason = new Hashtable();
    private static int reasonCnt = 0;
    public static List<String> sInternalBundles;

    public static String getClassNotFoundReason(String className) {
        for (int i = 0; i < classNotFoundReason.size(); ++i) {
            if (!(classNotFoundReason.get(i) + "").contains(className + "")) continue;
            return classNotFoundReason.get(i) + "";
        }
        return "";
    }

    private static void insertToReasonList(String className, String reason) {
        int i;
        classNotFoundReason.put(reasonCnt, " Not found class " + className + " because " + reason);
        reasonCnt = i = reasonCnt + 1;
        reasonCnt = i % 10;
    }

    public static String getPackageNameFromEntryName(String pkgName) {
        String archive = "lib/" + AtlasConfig.PRELOAD_DIR + "/lib";
        return pkgName.substring(pkgName.indexOf(archive) + archive.length(), pkgName.indexOf(".so")).replace("_", ".");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void resolveInternalBundles() {
        Class<ClassLoadFromBundle> clazz = ClassLoadFromBundle.class;
        synchronized (ClassLoadFromBundle.class) {
            if (sInternalBundles == null || sInternalBundles.size() == 0) {
                String str = "lib/" + AtlasConfig.PRELOAD_DIR + "/libcom_";
                String str2 = ".so";
                ArrayList<String> arrayList = new ArrayList<String>();
                try {
                    ZipFile apkFile = new ZipFile(RuntimeVariables.androidApplication.getApplicationInfo().sourceDir);
                    Enumeration<? extends ZipEntry> entries = apkFile.entries();
                    while (entries.hasMoreElements()) {
                        String name = entries.nextElement().getName();
                        if (!name.startsWith(str) || !name.endsWith(str2)) continue;
                        arrayList.add(ClassLoadFromBundle.getPackageNameFromEntryName(name));
                    }
                    apkFile.close();
                    sInternalBundles = arrayList;
                }
                catch (Exception e) {
                    Log.e((String)TAG, (String)"Exception while get bundles in assets or lib", (Throwable)e);
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    static Class<?> loadFromInstalledBundles(String componet) throws ClassNotFoundException {
        BundleImpl bundleImpl;
        int i = 0;
        Class<?> cls = null;
        List<Bundle> bundles = Framework.getBundles();
        if (bundles != null && !bundles.isEmpty()) {
            for (Bundle bundle : bundles) {
                bundleImpl = (BundleImpl)bundle;
                PackageLite packageLite = DelegateComponent.getPackage(bundleImpl.getLocation());
                if (packageLite == null || !packageLite.components.contains(componet)) continue;
                bundleImpl.getArchive().optDexFile();
                ClassLoader classLoader = bundleImpl.getClassLoader();
                if (classLoader != null) {
                    try {
                        cls = classLoader.loadClass(componet);
                        if (cls != null) {
                            return cls;
                        }
                    }
                    catch (ClassNotFoundException e) {
                        throw new ClassNotFoundException("Can't find class " + componet + " in BundleClassLoader: " + bundleImpl.getLocation() + " [" + (bundles == null ? 0 : bundles.size()) + "]" + "classloader is: " + (classLoader == null ? "null" : "not null") + " packageversion " + ClassLoadFromBundle.getPackageVersion() + " exception:" + e.getMessage());
                    }
                }
                StringBuilder append = new StringBuilder().append("Can't find class ").append(componet).append(" in BundleClassLoader: ").append(bundleImpl.getLocation()).append(" [");
                if (bundles != null) {
                    i = bundles.size();
                }
                throw new ClassNotFoundException(append.append(i).append("]").append(classLoader == null ? "classloader is null" : "classloader not null").append(" packageversion ").append(ClassLoadFromBundle.getPackageVersion()).toString());
            }
        }
        if (bundles != null && !bundles.isEmpty()) {
            Class<?> cls2 = null;
            for (Bundle bundle2 : Framework.getBundles()) {
                bundleImpl = (BundleImpl)bundle2;
                if (!bundleImpl.getArchive().isDexOpted()) continue;
                Class<?> loadClass = null;
                ClassLoader classLoader2 = bundleImpl.getClassLoader();
                if (classLoader2 != null) {
                    try {
                        loadClass = classLoader2.loadClass(componet);
                        if (loadClass != null) {
                            return loadClass;
                        }
                    }
                    catch (ClassNotFoundException classNotFoundException) {}
                } else {
                    loadClass = cls2;
                }
                cls2 = loadClass;
            }
            cls = cls2;
        }
        return cls;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkInstallBundleAndDependency(String location) {
        List<String> dependencyForBundle = BundleInfoList.getInstance().getDependencyForBundle(location);
        if (dependencyForBundle != null && dependencyForBundle.size() > 0) {
            for (int i = 0; i < dependencyForBundle.size(); ++i) {
                ClassLoadFromBundle.checkInstallBundleAndDependency(dependencyForBundle.get(i));
            }
        }
        if (Atlas.getInstance().getBundle(location) == null) {
            File file = new File(new File(Framework.getProperty("com.openAtlas.AppDirectory"), "lib"), "lib".concat(location.replace(".", "_")).concat(".so"));
            if (file.exists()) {
                try {
                    Atlas.getInstance().installBundle(location, file);
                }
                catch (Throwable e) {
                    throw new RuntimeException("failed to install bundle " + location, e);
                }
            }
            Log.e((String)TAG, (String)("file  not found " + file.getAbsolutePath() + " try install from Host"));
            ZipFile zipFile = null;
            try {
                String archiveName = "lib/" + AtlasConfig.PRELOAD_DIR + "/lib" + location.replaceAll("\\.", "_") + ".so";
                zipFile = new ZipFile(Globals.getApplication().getApplicationInfo().sourceDir);
                Atlas.getInstance().installBundle(location, zipFile.getInputStream(zipFile.getEntry(archiveName)));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (BundleException e) {
                e.printStackTrace();
            }
            finally {
                if (zipFile != null) {
                    try {
                        zipFile.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkInstallBundleIfNeed(String bundleName) {
        String string = bundleName;
        synchronized (string) {
            String bundleForComponet;
            if (sInternalBundles == null) {
                ClassLoadFromBundle.resolveInternalBundles();
            }
            if (TextUtils.isEmpty((CharSequence)(bundleForComponet = BundleInfoList.getInstance().getBundleNameForComponet(bundleName)))) {
                Log.e((String)TAG, (String)("Failed to find the bundle in BundleInfoList for component " + bundleForComponet));
                ClassLoadFromBundle.insertToReasonList(bundleName, "not found in BundleInfoList!");
            }
            if (sInternalBundles == null || sInternalBundles.contains(bundleForComponet)) {
                ClassLoadFromBundle.checkInstallBundleAndDependency(bundleForComponet);
                return;
            }
        }
    }

    private static int getPackageVersion() {
        PackageInfo packageInfo;
        try {
            packageInfo = RuntimeVariables.androidApplication.getPackageManager().getPackageInfo(RuntimeVariables.androidApplication.getPackageName(), 0);
        }
        catch (Throwable e) {
            Log.e((String)TAG, (String)"Error to get PackageInfo >>>", (Throwable)e);
            packageInfo = new PackageInfo();
        }
        return packageInfo.versionCode;
    }
}

