/*
 * Decompiled with CFR 0.152.
 */
package com.openatlas.log;

import android.util.Log;
import com.openatlas.log.Logger;
import com.openatlas.log.LoggerFactory;

public class AndroidLogger
implements Logger {
    private final String category;

    public AndroidLogger(String str) {
        this.category = str;
    }

    public AndroidLogger(Class<?> cls) {
        this(cls.getSimpleName());
    }

    @Override
    public void verbose(String str) {
        Log.v((String)this.category, (String)str);
    }

    @Override
    public void debug(String str) {
        Log.d((String)this.category, (String)str);
    }

    @Override
    public void info(String str) {
        Log.i((String)this.category, (String)str);
    }

    @Override
    public void warn(String str) {
        Log.w((String)this.category, (String)str);
    }

    @Override
    public void warn(String str, Throwable th) {
        Log.w((String)str, (Throwable)th);
    }

    @Override
    public void warn(StringBuffer stringBuffer, Throwable th) {
        this.warn(stringBuffer.toString(), th);
    }

    @Override
    public void error(String str) {
        Log.e((String)this.category, (String)str);
    }

    @Override
    public void error(String str, Throwable th) {
        Log.e((String)this.category, (String)str, (Throwable)th);
    }

    @Override
    public void error(StringBuffer stringBuffer, Throwable th) {
        this.error(stringBuffer.toString(), th);
    }

    @Override
    public void fatal(String str) {
        this.error(str);
    }

    @Override
    public void fatal(String str, Throwable th) {
        this.error(str, th);
    }

    @Override
    public boolean isVerboseEnabled() {
        return LoggerFactory.logLevel <= 2;
    }

    @Override
    public boolean isDebugEnabled() {
        return LoggerFactory.logLevel <= 3;
    }

    @Override
    public boolean isInfoEnabled() {
        return LoggerFactory.logLevel <= 4;
    }

    @Override
    public boolean isWarnEnabled() {
        return LoggerFactory.logLevel <= 5;
    }

    @Override
    public boolean isErrorEnabled() {
        return LoggerFactory.logLevel <= 6;
    }

    @Override
    public boolean isFatalEnabled() {
        return LoggerFactory.logLevel <= 6;
    }
}

