/*
 * Decompiled with CFR 0.152.
 */
package com.openatlas.framework.bundlestorage;

import com.openatlas.framework.Framework;
import com.openatlas.framework.bundlestorage.Archive;
import com.openatlas.framework.bundlestorage.BundleArchiveRevision;
import com.openatlas.util.StringUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.jar.Manifest;

public class BundleArchive
implements Archive {
    public static final String REVISION_DIRECTORY = "version";
    private File bundleDir;
    private final BundleArchiveRevision currentRevision;
    private final SortedMap<Long, BundleArchiveRevision> revisions = new TreeMap<Long, BundleArchiveRevision>();

    public BundleArchive(String location, File bundleDir) throws IOException {
        String[] list = bundleDir.list();
        if (list != null) {
            for (String str2 : list) {
                long parseLong;
                if (!str2.startsWith(REVISION_DIRECTORY) || (parseLong = Long.parseLong(StringUtils.substringAfter(str2, "."))) <= 0L) continue;
                this.revisions.put(parseLong, null);
            }
        }
        if (this.revisions.isEmpty()) {
            throw new IOException("No valid revisions in bundle archive directory: " + bundleDir);
        }
        this.bundleDir = bundleDir;
        long longValue = this.revisions.lastKey();
        BundleArchiveRevision bundleArchiveRevision = new BundleArchiveRevision(location, longValue, new File(bundleDir, "version." + String.valueOf(longValue)));
        this.revisions.put(longValue, bundleArchiveRevision);
        this.currentRevision = bundleArchiveRevision;
    }

    public BundleArchive(String location, File bundleDir, InputStream inputStream) throws IOException {
        this.bundleDir = bundleDir;
        BundleArchiveRevision bundleArchiveRevision = new BundleArchiveRevision(location, 1L, new File(bundleDir, "version." + String.valueOf(1)), inputStream);
        this.revisions.put(1L, bundleArchiveRevision);
        this.currentRevision = bundleArchiveRevision;
    }

    public BundleArchive(String location, File bundleDir, File archiveFile) throws IOException {
        this.bundleDir = bundleDir;
        BundleArchiveRevision bundleArchiveRevision = new BundleArchiveRevision(location, 1L, new File(bundleDir, "version." + String.valueOf(1)), archiveFile);
        this.revisions.put(1L, bundleArchiveRevision);
        this.currentRevision = bundleArchiveRevision;
    }

    @Override
    public BundleArchiveRevision newRevision(String location, File bundleDir, InputStream inputStream) throws IOException {
        long longValue = 1L + this.revisions.lastKey();
        BundleArchiveRevision bundleArchiveRevision = new BundleArchiveRevision(location, longValue, new File(bundleDir, "version." + String.valueOf(longValue)), inputStream);
        this.revisions.put(longValue, bundleArchiveRevision);
        return bundleArchiveRevision;
    }

    @Override
    public BundleArchiveRevision newRevision(String packageName, File bundleDir, File archiveFile) throws IOException {
        long revision = 1L + this.revisions.lastKey();
        BundleArchiveRevision bundleArchiveRevision = new BundleArchiveRevision(packageName, revision, new File(bundleDir, "version." + String.valueOf(revision)), archiveFile);
        this.revisions.put(revision, bundleArchiveRevision);
        return bundleArchiveRevision;
    }

    @Override
    public BundleArchiveRevision getCurrentRevision() {
        return this.currentRevision;
    }

    @Override
    public File getArchiveFile() {
        return this.currentRevision.getRevisionFile();
    }

    public File getBundleDir() {
        return this.bundleDir;
    }

    @Override
    public boolean isDexOpted() {
        return this.currentRevision.isDexOpted();
    }

    @Override
    public void optDexFile() {
        this.currentRevision.optDexFile();
    }

    @Override
    public InputStream openAssetInputStream(String name) throws IOException {
        return this.currentRevision.openAssetInputStream(name);
    }

    @Override
    public InputStream openNonAssetInputStream(String name) throws IOException {
        return this.currentRevision.openNonAssetInputStream(name);
    }

    @Override
    public Manifest getManifest() throws IOException {
        return this.currentRevision.getManifest();
    }

    @Override
    public Class<?> findClass(String clazz, ClassLoader classLoader) throws ClassNotFoundException {
        return this.currentRevision.findClass(clazz, classLoader);
    }

    @Override
    public File findLibrary(String name) {
        return this.currentRevision.findSoLibrary(name);
    }

    @Override
    public List<URL> getResources(String name) throws IOException {
        return this.currentRevision.getResources(name);
    }

    @Override
    public void purge() throws Exception {
        if (this.revisions.size() > 1) {
            long revisionNum = this.currentRevision.getRevisionNum();
            for (Long longValue : this.revisions.keySet()) {
                File file;
                long longValue2 = longValue;
                if (longValue2 == revisionNum || !(file = new File(this.bundleDir, "version." + String.valueOf(longValue2))).exists()) continue;
                Framework.deleteDirectory(file);
            }
            this.revisions.clear();
            this.revisions.put(revisionNum, this.currentRevision);
        }
    }

    @Override
    public void close() {
    }
}

