/*
 * Decompiled with CFR 0.152.
 */
package com.openatlas.framework;

import com.openatlas.framework.Framework;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;

final class ServiceReferenceImpl
implements ServiceReference {
    private static final HashSet<String> forbidden;
    private static long nextServiceID;
    Bundle bundle;
    private HashMap<Bundle, Object> cachedServices = null;
    private final boolean isServiceFactory;
    final Dictionary<String, Object> properties;
    ServiceRegistration registration;
    private Object service;
    final Map<Bundle, Integer> useCounters = new HashMap<Bundle, Integer>(0);

    ServiceReferenceImpl(Bundle bundle, Object service, Dictionary<String, ?> properties, String[] clazzes) {
        long j;
        if (service instanceof ServiceFactory) {
            this.isServiceFactory = true;
        } else {
            this.isServiceFactory = false;
            this.checkService(service, clazzes);
        }
        this.bundle = bundle;
        this.service = service;
        Dictionary dictionary = this.properties = properties == null ? new Hashtable<String, Object>() : new Hashtable(properties.size());
        if (properties != null) {
            Enumeration<String> keys = properties.keys();
            while (keys.hasMoreElements()) {
                String str = keys.nextElement();
                this.properties.put(str, properties.get(str));
            }
        }
        this.properties.put("objectClass", clazzes);
        Dictionary<String, Object> dictionary2 = this.properties;
        String str2 = "service.id";
        nextServiceID = j = nextServiceID + 1L;
        dictionary2.put(str2, j);
        Integer num = properties == null ? null : (Integer)properties.get("service.ranking");
        this.properties.put("service.ranking", num == null ? 0 : num);
        this.registration = new ServiceRegistrationImpl();
    }

    private void checkService(Object service, String[] clazzes) {
        for (int i = 0; i < clazzes.length; ++i) {
            try {
                if (Class.forName(clazzes[i], false, service.getClass().getClassLoader()).isInstance(service)) {
                    continue;
                }
                throw new IllegalArgumentException("Service " + service.getClass().getName() + " does not implement the interface " + clazzes[i]);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("Interface " + clazzes[i] + " implemented by service " + service.getClass().getName() + " cannot be located: " + e.getMessage());
            }
        }
    }

    void invalidate() {
        String[] propertyKeys;
        this.service = null;
        this.useCounters.clear();
        this.bundle = null;
        this.registration = null;
        if (this.cachedServices != null) {
            this.cachedServices = null;
        }
        for (String remove : propertyKeys = this.getPropertyKeys()) {
            this.properties.remove(remove);
        }
    }

    @Override
    public Bundle getBundle() {
        return this.bundle;
    }

    @Override
    public Object getProperty(String key) {
        Object obj2;
        Object obj = this.properties.get(key);
        if (obj != null) {
            return obj;
        }
        obj = this.properties.get(key.toLowerCase(Locale.US));
        if (obj != null) {
            return obj;
        }
        Enumeration<String> keys = this.properties.keys();
        while (keys.hasMoreElements()) {
            String str2 = keys.nextElement();
            if (!str2.equalsIgnoreCase(key)) continue;
            obj2 = this.properties.get(str2);
            break;
        }
        obj2 = obj;
        return obj2;
    }

    @Override
    public String[] getPropertyKeys() {
        ArrayList<String> arrayList = new ArrayList<String>(this.properties.size());
        Enumeration<String> keys = this.properties.keys();
        while (keys.hasMoreElements()) {
            arrayList.add(keys.nextElement());
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Bundle[] getUsingBundles() {
        Bundle[] bundleArr;
        Map<Bundle, Integer> map = this.useCounters;
        synchronized (map) {
            bundleArr = this.useCounters.isEmpty() ? null : this.useCounters.keySet().toArray(new Bundle[this.useCounters.size()]);
        }
        return bundleArr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object getService(Bundle bundle) {
        if (this.service == null) {
            return null;
        }
        Map<Bundle, Integer> map = this.useCounters;
        synchronized (map) {
            Integer num = this.useCounters.get(bundle);
            Object valueOf = num == null ? Integer.valueOf(1) : Integer.valueOf(num + 1);
            this.useCounters.put(bundle, (Integer)valueOf);
            if (this.isServiceFactory) {
                if (this.cachedServices == null) {
                    this.cachedServices = new HashMap();
                }
                if ((valueOf = this.cachedServices.get(bundle)) != null) {
                    return valueOf;
                }
                try {
                    Object service = ((ServiceFactory)this.service).getService(bundle, this.registration);
                    this.checkService(service, (String[])this.properties.get("objectClass"));
                    this.cachedServices.put(bundle, service);
                    return service;
                }
                catch (Throwable e) {
                    Framework.notifyFrameworkListeners(2, null, e);
                    return null;
                }
            }
            valueOf = this.service;
            return valueOf;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean ungetService(Bundle bundle) {
        Map<Bundle, Integer> map = this.useCounters;
        synchronized (map) {
            if (this.service == null) {
                return false;
            }
            Integer num = this.useCounters.get(bundle);
            if (num == null) {
                return false;
            }
            if (num == 1) {
                this.useCounters.remove(bundle);
                if (this.isServiceFactory) {
                    ((ServiceFactory)this.service).ungetService(bundle, this.registration, this.cachedServices.get(bundle));
                    this.cachedServices.remove(bundle);
                }
                return false;
            }
            this.useCounters.put(bundle, num - 1);
            return true;
        }
    }

    public String toString() {
        return "ServiceReference{" + this.service + "}";
    }

    static {
        nextServiceID = 0L;
        forbidden = new HashSet();
        forbidden.add("service.id".toLowerCase(Locale.US));
        forbidden.add("objectClass".toLowerCase(Locale.US));
    }

    private final class ServiceRegistrationImpl
    implements ServiceRegistration {
        private ServiceRegistrationImpl() {
        }

        @Override
        public ServiceReference getReference() {
            if (ServiceReferenceImpl.this.service != null) {
                return ServiceReferenceImpl.this;
            }
            throw new IllegalStateException("Service has already been uninstalled");
        }

        @Override
        public void setProperties(Dictionary<String, ?> dictionary) {
            String str;
            if (ServiceReferenceImpl.this.service == null) {
                throw new IllegalStateException("Service has already been uninstalled");
            }
            HashMap<String, String> hashMap = new HashMap<String, String>(ServiceReferenceImpl.this.properties.size());
            Enumeration<String> keys = ServiceReferenceImpl.this.properties.keys();
            while (keys.hasMoreElements()) {
                str = keys.nextElement();
                String toLowerCase = str.toLowerCase(Locale.US);
                if (hashMap.containsKey(toLowerCase)) {
                    throw new IllegalArgumentException("Properties contain the same key in different case variants");
                }
                hashMap.put(toLowerCase, str);
            }
            keys = dictionary.keys();
            while (keys.hasMoreElements()) {
                str = keys.nextElement();
                Object obj = dictionary.get(str);
                String toLowerCase2 = str.toLowerCase(Locale.US);
                if (forbidden.contains(toLowerCase2)) continue;
                Object obj2 = hashMap.get(toLowerCase2);
                if (obj2 != null) {
                    if (obj2.equals(str)) {
                        ServiceReferenceImpl.this.properties.remove(obj2);
                    } else {
                        throw new IllegalArgumentException("Properties already exists in Component different case variant");
                    }
                }
                ServiceReferenceImpl.this.properties.put(str, obj);
            }
            Framework.notifyServiceListeners(2, ServiceReferenceImpl.this);
        }

        @Override
        public void unregister() {
            if (ServiceReferenceImpl.this.service == null) {
                throw new IllegalStateException("Service has already been uninstalled");
            }
            Framework.unregisterService(ServiceReferenceImpl.this);
            ServiceReferenceImpl.this.service = null;
        }
    }
}

