/*
 * Decompiled with CFR 0.152.
 */
package com.openatlas.framework;

import com.openatlas.framework.BundleClassLoader;
import java.util.List;
import java.util.StringTokenizer;
import org.osgi.framework.Bundle;
import org.osgi.service.packageadmin.ExportedPackage;

final class Package
implements ExportedPackage {
    final BundleClassLoader classloader;
    List<Bundle> importingBundles = null;
    final String pkg;
    boolean removalPending = false;
    boolean resolved = false;
    private final short[] version;

    Package(String packageString, BundleClassLoader bundleClassLoader, boolean resolved) {
        String[] parsePackageString = Package.parsePackageString(packageString);
        this.pkg = parsePackageString[0];
        this.version = Package.getVersionNumber(parsePackageString[1]);
        this.classloader = bundleClassLoader;
        this.resolved = resolved;
    }

    @Override
    public Bundle getExportingBundle() {
        return this.classloader.bundle;
    }

    @Override
    public Bundle[] getImportingBundles() {
        if (this.importingBundles == null) {
            return new Bundle[]{this.classloader.bundle};
        }
        Bundle[] bundleArr = new Bundle[this.importingBundles.size() + 1];
        this.importingBundles.toArray(bundleArr);
        bundleArr[this.importingBundles.size()] = this.classloader.bundle;
        return bundleArr;
    }

    @Override
    public String getName() {
        return this.pkg;
    }

    @Override
    public String getSpecificationVersion() {
        return this.version == null ? null : this.version[0] + "." + this.version[1] + "." + this.version[2];
    }

    @Override
    public boolean isRemovalPending() {
        return this.removalPending;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Package)) {
            return false;
        }
        Package packageR = (Package)obj;
        if (this.classloader == null) {
            return Package.matches(this.pkg, this.version, packageR.pkg, packageR.version);
        }
        return obj.hashCode() == this.hashCode();
    }

    public String toString() {
        if (this.version == null) {
            return this.pkg;
        }
        return this.pkg + "; specification-version=" + this.getSpecificationVersion() + (this.resolved ? "" : " (UNRESOLVED)");
    }

    public int hashCode() {
        return this.pkg.hashCode();
    }

    static String[] parsePackageString(String name) {
        if (name.indexOf(";") > -1) {
            return new String[]{name.substring(0, name.indexOf(";")).trim(), name.substring(name.indexOf(";") + 1).trim()};
        }
        return new String[]{name.trim(), ""};
    }

    boolean matches(String name) {
        String[] parsePackageString = Package.parsePackageString(name);
        return Package.matches(this.pkg, this.version, parsePackageString[0], Package.getVersionNumber(parsePackageString[1]));
    }

    private static boolean matches(String pkg1Name, short[] pkg1version, String pkg2Name, short[] pkg2Version) {
        int indexOf = pkg2Name.indexOf(42);
        if (indexOf > -1) {
            if (indexOf == 0) {
                return true;
            }
            String substring = pkg2Name.substring(0, indexOf);
            if (!substring.endsWith(".")) {
                return false;
            }
            if (!pkg1Name.startsWith(substring.substring(0, substring.length() - 1))) {
                return false;
            }
        } else if (!pkg1Name.equals(pkg2Name)) {
            return false;
        }
        if (pkg1version == null || pkg2Version == null) {
            return true;
        }
        for (indexOf = 0; indexOf < 3; ++indexOf) {
            if (pkg1version[indexOf] <= pkg2Version[indexOf]) continue;
            return false;
        }
        return true;
    }

    boolean updates(Package packageR) {
        if (this.version == null || packageR.version == null) {
            return true;
        }
        for (int i = 0; i < 3; ++i) {
            if (this.version[i] >= packageR.version[i]) continue;
            return false;
        }
        return true;
    }

    private static short[] getVersionNumber(String specificationVersion) {
        if (!specificationVersion.startsWith("specification-version=")) {
            return null;
        }
        String trim = specificationVersion.substring(22).trim();
        if (trim.startsWith("\"")) {
            trim = trim.substring(1);
        }
        if (trim.endsWith("\"")) {
            trim = trim.substring(0, trim.length() - 1);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(trim, ".");
        short[] sArr = new short[]{0, 0, 0};
        for (int i = 0; stringTokenizer.hasMoreTokens() && i <= 2; ++i) {
            sArr[i] = Short.parseShort(stringTokenizer.nextToken());
        }
        return sArr;
    }
}

