/*
 * Decompiled with CFR 0.152.
 */
package com.openatlas.framework;

import android.annotation.SuppressLint;
import android.os.Build;
import com.openatlas.framework.BundleClassLoader;
import com.openatlas.framework.BundleContextImpl;
import com.openatlas.framework.BundleImpl;
import com.openatlas.framework.Package;
import com.openatlas.framework.RFC1960Filter;
import com.openatlas.framework.ServiceReferenceImpl;
import com.openatlas.log.Logger;
import com.openatlas.log.LoggerFactory;
import com.openatlas.runtime.ClassNotFoundInterceptorCallback;
import com.openatlas.runtime.RuntimeVariables;
import com.openatlas.util.BundleLock;
import com.openatlas.util.OpenAtlasFileLock;
import com.openatlas.util.StringUtils;
import com.openatlas.util.Utils;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import org.osgi.framework.AdminPermission;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleException;
import org.osgi.framework.BundleListener;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.service.packageadmin.ExportedPackage;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.service.startlevel.StartLevel;

public final class Framework {
    private static final AdminPermission ADMIN_PERMISSION;
    private static String BASEDIR;
    private static String BUNDLE_LOCATION;
    static int CLASSLOADER_BUFFER_SIZE;
    static boolean DEBUG_BUNDLES;
    static boolean DEBUG_CLASSLOADING;
    static boolean DEBUG_PACKAGES;
    static boolean DEBUG_SERVICES;
    static final String FRAMEWORK_VERSION = "0.9.0";
    static int LOG_LEVEL;
    static String STORAGE_LOCATION;
    private static boolean STRICT_STARTUP;
    static List<BundleListener> bundleListeners;
    static Map<String, Bundle> bundles;
    private static ClassNotFoundInterceptorCallback classNotFoundCallback;
    static Map<String, List<ServiceReference>> classes_services;
    static Map<Package, Package> exportedPackages;
    static List<FrameworkListener> frameworkListeners;
    static boolean frameworkStartupShutdown;
    static int initStartlevel;
    static final Logger log;
    static boolean mIsEnableBundleInstallWhenFindClass;
    static Map<String, String> mMapForComAndBundles;
    static Properties properties;
    static boolean restart;
    static List<ServiceListenerEntry> serviceListeners;
    static List<ServiceReference> services;
    static int startlevel;
    static List<BundleListener> syncBundleListeners;
    static SystemBundle systemBundle;
    static ClassLoader systemClassLoader;
    static List<String> writeAheads;

    static BundleImpl installNewBundle(String location, File apkFile) throws BundleException {
        Bundle mBundle;
        try {
            BundleLock.WriteLock(location);
            mBundle = Framework.getBundle(location);
            if (mBundle == null) {
                mBundle = new BundleImpl(new File(STORAGE_LOCATION, location), location, new BundleContextImpl(), null, apkFile, true);
            }
        }
        catch (Throwable v0) {
            v0.printStackTrace();
            BundleLock.WriteUnLock(location);
            throw new BundleException(v0.getMessage());
        }
        return (BundleImpl)mBundle;
    }

    static BundleImpl installNewBundle(String location, InputStream archiveInputStream) throws BundleException {
        Bundle mBundle = null;
        try {
            BundleLock.WriteLock(location);
            mBundle = Framework.getBundle(location);
            if (mBundle == null) {
                mBundle = new BundleImpl(new File(STORAGE_LOCATION, location), location, new BundleContextImpl(), archiveInputStream, null, true);
                Framework.storeMetadata();
                return (BundleImpl)mBundle;
            }
        }
        catch (Throwable v0) {
            BundleLock.WriteUnLock(location);
        }
        return (BundleImpl)mBundle;
    }

    private Framework() {
    }

    static void startup(Properties properties) throws BundleException {
        if (properties == null) {
            properties = new Properties();
        }
        Framework.properties = properties;
        Framework.startup();
    }

    private static void startup() throws BundleException {
        int property;
        int i;
        frameworkStartupShutdown = true;
        System.out.println("---------------------------------------------------------");
        System.out.println("  OpenAtlas OSGi 0.9.0 on " + Build.MODEL + "/" + Build.CPU_ABI + "/" + Build.VERSION.RELEASE + " starting ...");
        System.out.println("---------------------------------------------------------");
        long currentTimeMillis = System.currentTimeMillis();
        Framework.initialize();
        Framework.launch();
        boolean property2 = Framework.getProperty("osgi.init", false);
        if (property2) {
            i = -1;
        } else {
            i = Framework.restoreProfile();
            restart = true;
        }
        if (i == -1) {
            restart = false;
            File file = new File(STORAGE_LOCATION);
            if (property2 && file.exists()) {
                System.out.println("Purging storage ...");
                try {
                    Framework.deleteDirectory(file);
                }
                catch (Throwable e) {
                    throw new RuntimeException("deleteDirectory failed", e);
                }
            }
            try {
                file.mkdirs();
                Integer.getInteger("osgi.maxLevel", (Integer)1).intValue();
                initStartlevel = Framework.getProperty("osgi.startlevel.bundle", 1);
                property = Framework.getProperty("osgi.startlevel.framework", 1);
            }
            catch (Throwable e2) {
                throw new RuntimeException("mkdirs failed", e2);
            }
        }
        property = i;
        Framework.notifyFrameworkListeners(0, systemBundle, null);
        Framework.systemBundle.setLevel(Framework.getBundles().toArray(new Bundle[Framework.bundles.size()]), property, false);
        frameworkStartupShutdown = false;
        if (!restart) {
            try {
                Framework.storeProfile();
            }
            catch (Throwable e22) {
                throw new RuntimeException("storeProfile failed", e22);
            }
        }
        long currentTimeMillis2 = System.currentTimeMillis() - currentTimeMillis;
        System.out.println("---------------------------------------------------------");
        System.out.println("  Framework " + (restart ? "restarted" : "started") + " in " + currentTimeMillis2 + " milliseconds.");
        System.out.println("---------------------------------------------------------");
        System.out.flush();
        Framework.systemBundle.state = 32;
        try {
            Framework.notifyFrameworkListeners(1, systemBundle, null);
        }
        catch (Throwable e222) {
            throw new RuntimeException("notifyFrameworkListeners failed", e222);
        }
    }

    public static ClassLoader getSystemClassLoader() {
        return systemClassLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Bundle> getBundles() {
        ArrayList<Bundle> arrayList = new ArrayList<Bundle>(bundles.size());
        Map<String, Bundle> map = bundles;
        synchronized (map) {
            arrayList.addAll(bundles.values());
        }
        return arrayList;
    }

    public static Bundle getBundle(String location) {
        return bundles.get(location);
    }

    public static Bundle getBundle(long j) {
        return null;
    }

    static void shutdown(boolean restart) {
        System.out.println("---------------------------------------------------------");
        System.out.println("  Atlas OSGi shutting down ...");
        System.out.println("  Bye !");
        System.out.println("---------------------------------------------------------");
        Framework.systemBundle.state = 16;
        Framework.systemBundle.setLevel(Framework.getBundles().toArray(new Bundle[Framework.bundles.size()]), 0, true);
        bundles.clear();
        Framework.systemBundle.state = 1;
        if (restart) {
            try {
                Framework.startup();
            }
            catch (Throwable th) {
                th.printStackTrace();
            }
        }
    }

    public static void initialize() {
        File filesDir = RuntimeVariables.androidApplication.getFilesDir();
        if (filesDir == null || !filesDir.exists()) {
            filesDir = RuntimeVariables.androidApplication.getFilesDir();
        }
        BASEDIR = properties.getProperty("com.openAtlas.basedir", filesDir.getAbsolutePath());
        BUNDLE_LOCATION = properties.getProperty("com.openAtlas.jars", "file:" + BASEDIR);
        CLASSLOADER_BUFFER_SIZE = Framework.getProperty("com.openAtlas.classloader.buffersize", 10240);
        LOG_LEVEL = Framework.getProperty("com.openAtlas.log.level", 6);
        DEBUG_BUNDLES = Framework.getProperty("com.openAtlas.debug.bundles", false);
        DEBUG_PACKAGES = Framework.getProperty("com.openAtlas.debug.packages", false);
        DEBUG_SERVICES = Framework.getProperty("com.openAtlas.debug.services", false);
        DEBUG_CLASSLOADING = Framework.getProperty("com.openAtlas.debug.classloading", false);
        if (Framework.getProperty("com.openAtlas.debug", false)) {
            System.out.println("SETTING ALL DEBUG FLAGS");
            LOG_LEVEL = 3;
            DEBUG_BUNDLES = true;
            DEBUG_PACKAGES = true;
            DEBUG_SERVICES = true;
            DEBUG_CLASSLOADING = true;
        }
        STRICT_STARTUP = Framework.getProperty("com.openAtlas.strictStartup", false);
        String property = properties.getProperty("org.osgi.framework.system.packages");
        if (property != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(property, ",");
            int countTokens = stringTokenizer.countTokens();
            for (int i = 0; i < countTokens; ++i) {
                BundleClassLoader.FRAMEWORK_PACKAGES.add(stringTokenizer.nextToken().trim());
            }
        }
        properties.put("org.osgi.framework.executionenvironment", System.getProperty("java.specification.name") + "/" + System.getProperty("java.specification.version"));
        Properties properties2 = properties;
        String str = "org.osgi.framework.os.name";
        String property2 = System.getProperty("os.name");
        if (property2 == null) {
            property2 = "undefined";
        }
        properties2.put(str, property2);
        properties2 = properties;
        str = "org.osgi.framework.os.version";
        property2 = System.getProperty("os.version");
        if (property2 == null) {
            property2 = "undefined";
        }
        properties2.put(str, property2);
        properties2 = properties;
        str = "org.osgi.framework.processor";
        property2 = System.getProperty("os.arch");
        if (property2 == null) {
            property2 = "undefined";
        }
        properties2.put(str, property2);
        properties.put("org.osgi.framework.version", FRAMEWORK_VERSION);
        properties.put("org.osgi.framework.vendor", "Atlas");
        property2 = Locale.getDefault().getLanguage();
        properties2 = properties;
        str = "org.osgi.framework.language";
        if (property2 == null) {
            property2 = "en";
        }
        properties2.put(str, property2);
    }

    private static void launch() {
        STORAGE_LOCATION = properties.getProperty("com.openAtlas.storage", properties.getProperty("org.osgi.framework.dir", BASEDIR + File.separatorChar + "storage")) + File.separatorChar;
        systemBundle = new SystemBundle();
        Framework.systemBundle.state = 8;
    }

    public static boolean getProperty(String key, boolean defaultValue) {
        if (properties == null) {
            return defaultValue;
        }
        String str2 = (String)properties.get(key);
        return str2 != null ? Boolean.valueOf(str2) : defaultValue;
    }

    public static int getProperty(String key, int defaultValue) {
        if (properties == null) {
            return defaultValue;
        }
        String str2 = (String)properties.get(key);
        return str2 != null ? Integer.parseInt(str2) : defaultValue;
    }

    public static String getProperty(String key) {
        if (properties == null) {
            return null;
        }
        return (String)properties.get(key);
    }

    public static String getProperty(String key, String defaultValue) {
        return properties == null ? defaultValue : (String)properties.get(key);
    }

    protected static void warning(String str) throws RuntimeException {
        if (Framework.getProperty("com.openAtlas.strictStartup", false)) {
            throw new RuntimeException(str);
        }
        System.err.println("WARNING: " + str);
    }

    private static void storeProfile() {
        BundleImpl[] bundleImplArr;
        for (BundleImpl updateMetadata : bundleImplArr = Framework.getBundles().toArray(new BundleImpl[bundles.size()])) {
            updateMetadata.updateMetadata();
        }
        Framework.storeMetadata();
    }

    static void storeMetadata() {
        try {
            File file = new File(STORAGE_LOCATION, "meta");
            try {
                if (!OpenAtlasFileLock.getInstance().LockExclusive(file)) {
                    log.error("Failed to get fileLock for " + file.getAbsolutePath());
                    OpenAtlasFileLock.getInstance().unLock(file);
                } else if (file.length() > 0L) {
                    OpenAtlasFileLock.getInstance().unLock(file);
                } else {
                    DataOutputStream dataOutputStream = new DataOutputStream(new FileOutputStream(file));
                    dataOutputStream.writeInt(startlevel);
                    String join = StringUtils.join(writeAheads.toArray(), ",");
                    if (join == null) {
                        join = "";
                    }
                    dataOutputStream.writeUTF(join);
                    dataOutputStream.flush();
                    dataOutputStream.close();
                    OpenAtlasFileLock.getInstance().unLock(file);
                }
            }
            catch (IOException e2) {
                Throwable e = e2;
                try {
                    log.error("Could not save meta data.", e);
                    OpenAtlasFileLock.getInstance().unLock(file);
                }
                catch (Throwable th) {
                    e = th;
                    OpenAtlasFileLock.getInstance().unLock(file);
                    throw e;
                }
            }
        }
        catch (IOException e3) {
            IOException e = e3;
            File file = null;
            log.error("Could not save meta data.", (Throwable)e);
            OpenAtlasFileLock.getInstance().unLock(file);
        }
        catch (Throwable th2) {
            Throwable e = th2;
            File file = null;
            OpenAtlasFileLock.getInstance().unLock(file);
        }
    }

    private static int restoreProfile() {
        try {
            System.out.println("Restoring profile");
            File file = new File(STORAGE_LOCATION, "meta");
            if (file.exists()) {
                DataInputStream dataInputStream = new DataInputStream(new FileInputStream(file));
                int readInt = dataInputStream.readInt();
                String[] split = StringUtils.split(dataInputStream.readUTF(), ",");
                if (split != null) {
                    writeAheads.addAll(Arrays.asList(split));
                }
                dataInputStream.close();
                if (!Framework.getProperty("com.openAtlas.auto.load", true)) {
                    return readInt;
                }
                File file2 = new File(STORAGE_LOCATION);
                Framework.mergeWalsDir(new File(STORAGE_LOCATION, "wal"), file2);
                Framework.MergeWirteAheads(file2);
                File[] listFiles = file2.listFiles(new FilenameFilter(){

                    @Override
                    public boolean accept(File file, String str) {
                        return !str.matches("^[0-9]*");
                    }
                });
                for (int i = 0; i < listFiles.length; ++i) {
                    if (!listFiles[i].isDirectory() || !new File(listFiles[i], "meta").exists()) continue;
                    try {
                        System.out.println("RESTORED BUNDLE " + new BundleImpl((File)listFiles[i], (BundleContextImpl)new BundleContextImpl()).location);
                        continue;
                    }
                    catch (Exception e) {
                        log.error(e.getMessage(), e.getCause());
                    }
                }
                return readInt;
            }
            System.out.println("Profile not found, performing clean start ...");
            return -1;
        }
        catch (Exception e2) {
            e2.printStackTrace();
            return 0;
        }
    }

    private static void mergeWalsDir(File file, File file2) {
        if (writeAheads != null && writeAheads.size() > 0) {
            for (int i = 0; i < writeAheads.size(); ++i) {
                block9: {
                    if (writeAheads.get(i) == null) continue;
                    File file3 = new File(file, writeAheads.get(i));
                    if (file3 != null) {
                        try {
                            File[] listFiles;
                            if (!file3.exists() || (listFiles = file3.listFiles()) == null) break block9;
                            for (File file4 : listFiles) {
                                if (!file4.isDirectory()) continue;
                                File file5 = new File(file2, file4.getName());
                                if (file5.exists()) {
                                    File[] listFiles2 = file4.listFiles(new FilenameFilter(){

                                        @Override
                                        public boolean accept(File file, String str) {
                                            return str.startsWith("version");
                                        }
                                    });
                                    if (listFiles2 == null) continue;
                                    for (File file6 : listFiles2) {
                                        if (!new File(file6, "meta").exists()) continue;
                                        file6.renameTo(new File(file5, file6.getName()));
                                    }
                                    continue;
                                }
                                file4.renameTo(file5);
                            }
                        }
                        catch (Throwable e) {
                            log.error("Error while merge wal dir", e);
                        }
                    }
                }
                writeAheads.set(i, null);
            }
        }
        if (file.exists()) {
            file.delete();
        }
    }

    public static void deleteDirectory(File mDirectory) {
        File[] listFiles = mDirectory.listFiles();
        for (int i = 0; i < listFiles.length; ++i) {
            if (listFiles[i].isDirectory()) {
                Framework.deleteDirectory(listFiles[i]);
                continue;
            }
            listFiles[i].delete();
        }
        mDirectory.delete();
    }

    static void checkAdminPermission() {
        AccessController.checkPermission(ADMIN_PERMISSION);
    }

    static BundleImpl installNewBundle(String bundleName) throws BundleException {
        try {
            String str2 = bundleName.indexOf(":") > -1 ? bundleName : BUNDLE_LOCATION + File.separatorChar + bundleName;
            return Framework.installNewBundle(str2, new URL(str2).openConnection().getInputStream());
        }
        catch (Throwable e) {
            throw new BundleException("Cannot retrieve bundle from " + bundleName, e);
        }
    }

    static void installOrUpdate(String[] locations, File[] archiveFiles) throws BundleException {
        if (locations == null || archiveFiles == null || locations.length != archiveFiles.length) {
            throw new IllegalArgumentException("locations and files must not be null and must be same length");
        }
        String valueOf = String.valueOf(System.currentTimeMillis());
        File file = new File(new File(STORAGE_LOCATION, "wal"), valueOf);
        file.mkdirs();
        for (int i = 0; i < locations.length; ++i) {
            if (locations[i] == null || archiveFiles[i] == null) continue;
            try {
                BundleLock.WriteLock(locations[i]);
                Bundle bundle = Framework.getBundle(locations[i]);
                if (bundle != null) {
                    bundle.update(archiveFiles[i]);
                } else {
                    BundleImpl bundleImpl = new BundleImpl(new File(file, locations[i]), locations[i], new BundleContextImpl(), null, archiveFiles[i], false);
                }
                BundleLock.WriteUnLock(locations[i]);
                continue;
            }
            catch (Throwable th) {
                BundleLock.WriteUnLock(locations[i]);
            }
        }
        writeAheads.add(valueOf);
        Framework.storeMetadata();
    }

    static void unregisterService(ServiceReference serviceReference) {
        services.remove(serviceReference);
        Framework.removeValue(classes_services, (String[])serviceReference.getProperty("objectClass"), serviceReference);
        BundleImpl bundleImpl = (BundleImpl)serviceReference.getBundle();
        bundleImpl.registeredServices.remove(serviceReference);
        if (bundleImpl.registeredServices.isEmpty()) {
            bundleImpl.registeredServices = null;
        }
        Framework.notifyServiceListeners(4, serviceReference);
        if (DEBUG_SERVICES && log.isInfoEnabled()) {
            log.info("Framework: UNREGISTERED SERVICE " + serviceReference);
        }
    }

    static void notifyBundleListeners(int event, Bundle bundle) {
        if (!syncBundleListeners.isEmpty() || !bundleListeners.isEmpty()) {
            BundleListener[] bundleListenerArr;
            BundleEvent bundleEvent = new BundleEvent(event, bundle);
            for (BundleListener bundleChanged : bundleListenerArr = syncBundleListeners.toArray(new BundleListener[syncBundleListeners.size()])) {
                bundleChanged.bundleChanged(bundleEvent);
            }
            if (!bundleListeners.isEmpty()) {
                for (BundleListener bundleListener : bundleListenerArr = bundleListeners.toArray(new BundleListener[bundleListeners.size()])) {
                    bundleListener.bundleChanged(bundleEvent);
                }
            }
        }
    }

    static void addFrameworkListener(FrameworkListener frameworkListener) {
        frameworkListeners.add(frameworkListener);
    }

    static void removeFrameworkListener(FrameworkListener frameworkListener) {
        frameworkListeners.remove(frameworkListener);
    }

    private static void MergeWirteAheads(File file) {
        try {
            File file2 = new File(STORAGE_LOCATION, "wal");
            String curProcessName = Utils.getProcessName();
            log.debug("restoreProfile in process " + curProcessName);
            String packageName = RuntimeVariables.androidApplication.getPackageName();
            if (curProcessName != null && packageName != null && curProcessName.equals(packageName)) {
                Framework.mergeWalsDir(file2, file);
            }
        }
        catch (Throwable th) {
            if (Build.MODEL == null || !Build.MODEL.equals("HTC 802w")) {
                log.error(th.getMessage(), th.getCause());
                return;
            }
            RuntimeException runtimeException = new RuntimeException(th);
        }
    }

    static void addBundleListener(BundleListener bundleListener) {
        bundleListeners.add(bundleListener);
    }

    static void removeBundleListener(BundleListener bundleListener) {
        bundleListeners.remove(bundleListener);
    }

    static void notifyFrameworkListeners(int event, Bundle bundle, Throwable th) {
        if (!frameworkListeners.isEmpty()) {
            FrameworkListener[] frameworkListenerArr;
            FrameworkEvent frameworkEvent = new FrameworkEvent(event, bundle, th);
            for (FrameworkListener frameworkListener : frameworkListenerArr = frameworkListeners.toArray(new FrameworkListener[frameworkListeners.size()])) {
                frameworkListener.frameworkEvent(frameworkEvent);
            }
        }
    }

    static void notifyServiceListeners(int event, ServiceReference serviceReference) {
        if (!serviceListeners.isEmpty()) {
            ServiceEvent serviceEvent = new ServiceEvent(event, serviceReference);
            ServiceListenerEntry[] serviceListenerEntryArr = serviceListeners.toArray(new ServiceListenerEntry[serviceListeners.size()]);
            for (int i = 0; i < serviceListenerEntryArr.length; ++i) {
                if (serviceListenerEntryArr[i].filter != null && !serviceListenerEntryArr[i].filter.match(((ServiceReferenceImpl)serviceReference).properties)) continue;
                serviceListenerEntryArr[i].listener.serviceChanged(serviceEvent);
            }
        }
    }

    static void clearBundleTrace(BundleImpl bundleImpl) {
        ServiceReference[] servicesInUse;
        ServiceReference[] registeredServices;
        if (bundleImpl.registeredFrameworkListeners != null) {
            frameworkListeners.removeAll(bundleImpl.registeredFrameworkListeners);
            bundleImpl.registeredFrameworkListeners = null;
        }
        if (bundleImpl.registeredServiceListeners != null) {
            serviceListeners.removeAll(bundleImpl.registeredServiceListeners);
            bundleImpl.registeredServiceListeners = null;
        }
        if (bundleImpl.registeredBundleListeners != null) {
            bundleListeners.removeAll(bundleImpl.registeredBundleListeners);
            syncBundleListeners.removeAll(bundleImpl.registeredBundleListeners);
            bundleImpl.registeredBundleListeners = null;
        }
        if ((registeredServices = bundleImpl.getRegisteredServices()) != null) {
            for (ServiceReference serviceReference : registeredServices) {
                Framework.unregisterService(serviceReference);
                ((ServiceReferenceImpl)serviceReference).invalidate();
            }
            bundleImpl.registeredServices = null;
        }
        for (ServiceReference serviceReference : servicesInUse = bundleImpl.getServicesInUse()) {
            ((ServiceReferenceImpl)serviceReference).ungetService(bundleImpl);
        }
    }

    static void addValue(Map map, Object obj, Object obj2) {
        ArrayList<Object> list = (ArrayList<Object>)map.get(obj);
        if (list == null) {
            list = new ArrayList<Object>();
        }
        list.add(obj2);
        map.put(obj, list);
    }

    static void removeValue(Map map, Object[] objArr, Object obj) {
        for (int i = 0; i < objArr.length; ++i) {
            List list = (List)map.get(objArr[i]);
            if (list == null) continue;
            list.remove(obj);
            if (list.isEmpty()) {
                map.remove(objArr[i]);
                continue;
            }
            map.put(objArr[i], list);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void export(BundleClassLoader bundleClassLoader, String[] packageNames, boolean resolved) {
        Map<Package, Package> map = exportedPackages;
        synchronized (map) {
            if (DEBUG_PACKAGES && log.isDebugEnabled()) {
                log.debug("Bundle " + bundleClassLoader.bundle + " registers " + (resolved ? "resolved" : "unresolved") + " packages " + Arrays.asList(packageNames));
            }
            for (String packageName : packageNames) {
                Package packageR = new Package(packageName, bundleClassLoader, resolved);
                Package packageR2 = exportedPackages.get(packageR);
                if (packageR2 == null) {
                    exportedPackages.put(packageR, packageR);
                    if (!DEBUG_PACKAGES || !log.isDebugEnabled()) continue;
                    log.debug("REGISTERED PACKAGE " + packageR);
                    continue;
                }
                if (packageR2.importingBundles != null || !packageR.updates(packageR2)) continue;
                exportedPackages.remove(packageR2);
                exportedPackages.put(packageR, packageR);
                if (!DEBUG_PACKAGES || !log.isDebugEnabled()) continue;
                log.debug("REPLACED PACKAGE " + packageR2 + " WITH " + packageR);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static BundleClassLoader getImport(BundleImpl bundleImpl, String packageName, boolean resolve, HashSet<BundleClassLoader> hashSet) {
        if (DEBUG_PACKAGES && log.isDebugEnabled()) {
            log.debug("Bundle " + bundleImpl + " requests package " + packageName);
        }
        Map<Package, Package> map = exportedPackages;
        synchronized (map) {
            try {
                Package packageR = exportedPackages.get(new Package(packageName, null, false));
                if (packageR == null || !packageR.resolved && !resolve) {
                    return null;
                }
                BundleClassLoader bundleClassLoader = packageR.classloader;
                if (bundleClassLoader == bundleImpl.classloader) {
                    return bundleClassLoader;
                }
                if (resolve && !packageR.resolved && !hashSet.contains(packageR.classloader)) {
                    hashSet.add(bundleImpl.classloader);
                    packageR.classloader.resolveBundle(true, hashSet);
                }
                if (packageR.importingBundles == null) {
                    packageR.importingBundles = new ArrayList<Bundle>();
                }
                if (!packageR.importingBundles.contains(bundleImpl)) {
                    packageR.importingBundles.add(bundleImpl);
                }
                if (DEBUG_PACKAGES && log.isDebugEnabled()) {
                    log.debug("REQUESTED PACKAGE " + packageName + ", RETURNED DELEGATION TO " + bundleClassLoader.bundle);
                }
                return bundleClassLoader;
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
            catch (Throwable throwable) {
            }
        }
        return null;
    }

    public static boolean isFrameworkStartupShutdown() {
        return frameworkStartupShutdown;
    }

    public static ClassNotFoundInterceptorCallback getClassNotFoundCallback() {
        return classNotFoundCallback;
    }

    public static void setClassNotFoundCallback(ClassNotFoundInterceptorCallback classNotFoundInterceptorCallback) {
        classNotFoundCallback = classNotFoundInterceptorCallback;
    }

    static {
        BASEDIR = null;
        BUNDLE_LOCATION = null;
        CLASSLOADER_BUFFER_SIZE = 0;
        DEBUG_BUNDLES = true;
        DEBUG_CLASSLOADING = true;
        DEBUG_PACKAGES = true;
        DEBUG_SERVICES = true;
        log = LoggerFactory.getInstance("Framework");
        bundles = new ConcurrentHashMap<String, Bundle>();
        services = new ArrayList<ServiceReference>();
        classes_services = new HashMap<String, List<ServiceReference>>();
        bundleListeners = new ArrayList<BundleListener>();
        syncBundleListeners = new ArrayList<BundleListener>();
        serviceListeners = new ArrayList<ServiceListenerEntry>();
        frameworkListeners = new ArrayList<FrameworkListener>();
        exportedPackages = new ConcurrentHashMap<Package, Package>();
        startlevel = 0;
        writeAheads = new ArrayList<String>();
        initStartlevel = 1;
        frameworkStartupShutdown = false;
        restart = false;
        mMapForComAndBundles = new HashMap<String, String>();
        mIsEnableBundleInstallWhenFindClass = false;
        ADMIN_PERMISSION = new AdminPermission();
    }

    private static final class SystemBundle
    implements Bundle,
    PackageAdmin,
    StartLevel {
        private final Dictionary<String, String> props = new Hashtable<String, String>();
        private final ServiceReference[] registeredServices;
        int state;

        SystemBundle() {
            this.props.put("Bundle-Name", "System Bundle");
            this.props.put("Bundle-Version", Framework.FRAMEWORK_VERSION);
            this.props.put("Bundle-Vendor", "Atlas");
            ServiceReferenceImpl serviceReferenceImpl = new ServiceReferenceImpl(this, this, null, new String[]{StartLevel.class.getName(), PackageAdmin.class.getName()});
            Framework.addValue(classes_services, StartLevel.class.getName(), serviceReferenceImpl);
            Framework.addValue(classes_services, PackageAdmin.class.getName(), serviceReferenceImpl);
            services.add(serviceReferenceImpl);
            this.registeredServices = new ServiceReference[]{serviceReferenceImpl};
        }

        @Override
        public long getBundleId() {
            return 0L;
        }

        @Override
        public Dictionary<String, String> getHeaders() {
            return this.props;
        }

        @Override
        public String getLocation() {
            return "System Bundle";
        }

        @Override
        public ServiceReference[] getRegisteredServices() {
            return this.registeredServices;
        }

        @Override
        public URL getResource(String name) {
            return this.getClass().getResource(name);
        }

        @Override
        public ServiceReference[] getServicesInUse() {
            return null;
        }

        @Override
        public int getState() {
            return this.state;
        }

        @Override
        public boolean hasPermission(Object permission) {
            return true;
        }

        @Override
        public void start() throws BundleException {
        }

        @Override
        public void stop() throws BundleException {
            this.shutdownThread(false);
        }

        @Override
        public void uninstall() throws BundleException {
            throw new BundleException("Cannot uninstall the System Bundle");
        }

        @Override
        public void update() throws BundleException {
            this.shutdownThread(true);
        }

        private void shutdownThread(boolean z) {
            new ShutdownThread(z).start();
        }

        @Override
        public void update(InputStream inputStream) throws BundleException {
            this.shutdownThread(true);
        }

        @Override
        public void update(File file) throws BundleException {
            this.shutdownThread(true);
        }

        @Override
        public int getBundleStartLevel(Bundle bundle) {
            if (bundle == this) {
                return 0;
            }
            BundleImpl bundleImpl = (BundleImpl)bundle;
            if (bundleImpl.state != 1) {
                return bundleImpl.currentStartlevel;
            }
            throw new IllegalArgumentException("Bundle " + bundle + " has been uninstalled");
        }

        @Override
        public int getInitialBundleStartLevel() {
            return initStartlevel;
        }

        @Override
        public int getStartLevel() {
            return startlevel;
        }

        @Override
        public boolean isBundlePersistentlyStarted(Bundle bundle) {
            if (bundle == this) {
                return true;
            }
            BundleImpl bundleImpl = (BundleImpl)bundle;
            if (bundleImpl.state != 1) {
                return bundleImpl.persistently;
            }
            throw new IllegalArgumentException("Bundle " + bundle + " has been uninstalled");
        }

        @Override
        public void setBundleStartLevel(Bundle bundle, int level) {
            if (bundle == this) {
                throw new IllegalArgumentException("Cannot set the start level for the system bundle.");
            }
            BundleImpl bundleImpl = (BundleImpl)bundle;
            if (bundleImpl.state == 1) {
                throw new IllegalArgumentException("Bundle " + bundle + " has been uninstalled");
            }
            if (level <= 0) {
                throw new IllegalArgumentException("Start level " + level + " is not Component valid level");
            }
            bundleImpl.currentStartlevel = level;
            bundleImpl.updateMetadata();
            if (level <= startlevel && bundle.getState() != 32 && bundleImpl.persistently) {
                try {
                    bundleImpl.startBundle();
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    Framework.notifyFrameworkListeners(2, bundle, e);
                }
            } else if (level > startlevel && (bundle.getState() != 4 || bundle.getState() != 2)) {
                try {
                    bundleImpl.stopBundle();
                }
                catch (Throwable e2) {
                    Framework.notifyFrameworkListeners(2, bundle, e2);
                }
            }
        }

        @Override
        public void setInitialBundleStartLevel(int i) {
            if (i <= 0) {
                throw new IllegalArgumentException("Start level " + i + " is not Component valid level");
            }
            initStartlevel = i;
        }

        @Override
        public void setStartLevel(int i) {
            if (i <= 0) {
                throw new IllegalArgumentException("Start level " + i + " is not Component valid level");
            }
            new UpdateLevelThread(i).start();
        }

        @SuppressLint(value={"UseSparseArrays"})
        private void setLevel(Bundle[] bundleArr, int i, boolean z) {
            if (startlevel != i) {
                int i4;
                boolean i2 = i > startlevel;
                int i3 = i2 ? i - startlevel : startlevel - i;
                HashMap hashMap = new HashMap(0);
                for (i4 = 0; i4 < bundleArr.length; ++i4) {
                    if (bundleArr[i4] == systemBundle || !z && !((BundleImpl)bundleArr[i4]).persistently) continue;
                    BundleImpl bundleImpl = (BundleImpl)bundleArr[i4];
                    int i5 = i2 ? bundleImpl.currentStartlevel - startlevel - 1 : startlevel - bundleImpl.currentStartlevel;
                    if (i5 < 0 || i5 >= i3) continue;
                    Framework.addValue(hashMap, i5, bundleImpl);
                }
                for (int i6 = 0; i6 < i3; ++i6) {
                    startlevel = i2 ? ++startlevel : --startlevel;
                    List list = (List)hashMap.get(i6);
                    if (list == null) continue;
                    BundleImpl[] bundleImplArr = list.toArray(new BundleImpl[list.size()]);
                    for (i4 = 0; i4 < bundleImplArr.length; ++i4) {
                        if (i2) {
                            try {
                                System.out.println("STARTING " + bundleImplArr[i4].location);
                                bundleImplArr[i4].startBundle();
                            }
                            catch (Throwable e) {
                                e.printStackTrace();
                                e.printStackTrace();
                                Framework.notifyFrameworkListeners(2, systemBundle, e);
                            }
                            continue;
                        }
                        if (bundleImplArr[i4].getState() == 1) continue;
                        System.out.println("STOPPING " + bundleImplArr[i4].location);
                        try {
                            bundleImplArr[bundleImplArr.length - i4 - 1].stopBundle();
                            continue;
                        }
                        catch (BundleException e) {
                            e.printStackTrace();
                        }
                    }
                }
                startlevel = i;
            }
        }

        @Override
        public ExportedPackage[] getExportedPackages(Bundle bundle) {
            return this.getExportedPackages(bundle, false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ExportedPackage[] getExportedPackages(Bundle bundle, boolean z) {
            Map<Package, Package> map = exportedPackages;
            synchronized (map) {
                if (bundle != null && bundle != systemBundle) {
                    BundleImpl bundleImpl = (BundleImpl)bundle;
                    if (bundleImpl.state == 1) {
                        ExportedPackage[] exportedPackageArr = z ? bundleImpl.staleExportedPackages : null;
                        return exportedPackageArr;
                    }
                    String[] strArr = bundleImpl.classloader.exports;
                    if (strArr == null) {
                        return null;
                    }
                    ArrayList<Package> arrayList = new ArrayList<Package>();
                    for (String str : strArr) {
                        Package packageR = exportedPackages.get(new Package(str, null, false));
                        if (packageR == null || packageR.classloader != bundleImpl.classloader) continue;
                        if (packageR.resolved) {
                            arrayList.add(packageR);
                            continue;
                        }
                        try {
                            packageR.classloader.resolveBundle(true, new HashSet<BundleClassLoader>());
                            arrayList.add(packageR);
                        }
                        catch (BundleException bundleException) {
                            // empty catch block
                        }
                    }
                    if (bundleImpl.staleExportedPackages != null) {
                        arrayList.addAll(Arrays.asList(bundleImpl.staleExportedPackages));
                    }
                    System.out.println("\tBundle " + bundleImpl + " has exported packages " + arrayList);
                    return arrayList.isEmpty() ? null : arrayList.toArray(new ExportedPackage[arrayList.size()]);
                }
                return exportedPackages.keySet().toArray(new ExportedPackage[exportedPackages.size()]);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ExportedPackage getExportedPackage(String name) {
            Map<Package, Package> map = exportedPackages;
            synchronized (map) {
                try {
                    Package packageR = exportedPackages.get(new Package(name, null, false));
                    if (packageR == null) {
                        return null;
                    }
                    if (!packageR.resolved) {
                        packageR.classloader.resolveBundle(true, new HashSet<BundleClassLoader>());
                    }
                    return packageR;
                }
                catch (BundleException e) {
                    return null;
                }
                catch (Throwable throwable) {
                }
            }
            return null;
        }

        @Override
        public void refreshPackages(Bundle[] bundleArr) {
            new RefreshBundlesThread(bundleArr).start();
        }

        public String toString() {
            return "SystemBundle";
        }

        class RefreshBundlesThread
        extends Thread {
            final Bundle[] bundleArray;

            RefreshBundlesThread(Bundle[] bundleArr) {
                this.bundleArray = bundleArr;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Map<Package, Package> map = exportedPackages;
                synchronized (map) {
                    try {
                        int i2;
                        BundleImpl bundleImpl;
                        int i;
                        Bundle[] bundleArr;
                        List<Bundle> bundles;
                        if (this.bundleArray == null) {
                            bundles = Framework.getBundles();
                            bundleArr = bundles.toArray(new Bundle[bundles.size()]);
                        } else {
                            bundleArr = this.bundleArray;
                        }
                        ArrayList<Bundle> arrayList = new ArrayList<Bundle>(bundleArr.length);
                        for (i = 0; i < bundleArr.length; ++i) {
                            if (bundleArr[i] == systemBundle) continue;
                            bundleImpl = (BundleImpl)bundleArr[i];
                            if (bundleImpl.classloader != null && bundleImpl.classloader.originalExporter == null) continue;
                            arrayList.add(bundleArr[i]);
                        }
                        if (arrayList.isEmpty()) {
                            return;
                        }
                        if (DEBUG_PACKAGES && log.isDebugEnabled()) {
                            log.debug("REFRESHING PACKAGES FROM BUNDLES " + arrayList);
                        }
                        HashSet<BundleImpl> hashSet = new HashSet<BundleImpl>();
                        while (!arrayList.isEmpty()) {
                            bundleImpl = (BundleImpl)arrayList.remove(0);
                            if (hashSet.contains(bundleImpl)) continue;
                            ExportedPackage[] access$100 = SystemBundle.this.getExportedPackages(bundleImpl, true);
                            if (access$100 != null) {
                                for (ExportedPackage exportedPackage : access$100) {
                                    Package packageR = (Package)exportedPackage;
                                    if (packageR.importingBundles == null) continue;
                                    arrayList.addAll(Arrays.asList(packageR.importingBundles.toArray(new Bundle[packageR.importingBundles.size()])));
                                }
                            }
                            if (bundleImpl.classloader == null) continue;
                            hashSet.add(bundleImpl);
                        }
                        if (DEBUG_PACKAGES && log.isDebugEnabled()) {
                            log.debug("UPDATE GRAPH IS " + hashSet);
                        }
                        Bundle[] bundleArr2 = new Bundle[hashSet.size()];
                        i = -1;
                        bundles = Framework.getBundles();
                        Bundle[] bundleArr3 = bundles.toArray(new Bundle[bundles.size()]);
                        for (i2 = 0; i2 < bundleArr3.length; ++i2) {
                            if (!hashSet.contains(bundleArr3[i2])) continue;
                            bundleArr2[++i] = bundleArr3[i2];
                        }
                        i2 = startlevel;
                        SystemBundle.this.setLevel(bundleArr2, 0, true);
                        for (i = 0; i < bundleArr2.length; ++i) {
                            ((BundleImpl)bundleArr2[i]).classloader.cleanup(false);
                            ((BundleImpl)bundleArr2[i]).staleExportedPackages = null;
                        }
                        for (Bundle bundle : bundleArr2) {
                            BundleClassLoader bundleClassLoader = ((BundleImpl)bundle).classloader;
                            if (bundleClassLoader.exports.length <= 0) continue;
                            Framework.export(bundleClassLoader, bundleClassLoader.exports, false);
                        }
                        for (Bundle bundle2 : bundleArr2) {
                            try {
                                ((BundleImpl)bundle2).classloader.resolveBundle(true, new HashSet<BundleClassLoader>());
                            }
                            catch (BundleException e) {
                                e.printStackTrace();
                            }
                        }
                        SystemBundle.this.setLevel(bundleArr2, i2, true);
                        Framework.notifyFrameworkListeners(4, systemBundle, null);
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
        }

        class UpdateLevelThread
        extends Thread {
            final int targetLevel;

            UpdateLevelThread(int i) {
                this.targetLevel = i;
            }

            @Override
            public void run() {
                List<Bundle> bundles = Framework.getBundles();
                SystemBundle.this.setLevel(bundles.toArray(new Bundle[bundles.size()]), this.targetLevel, false);
                Framework.notifyFrameworkListeners(8, systemBundle, null);
                Framework.storeMetadata();
            }
        }

        class ShutdownThread
        extends Thread {
            final boolean restart;

            ShutdownThread(boolean restart) {
                this.restart = restart;
            }

            @Override
            public void run() {
                Framework.shutdown(this.restart);
            }
        }
    }

    static final class ServiceListenerEntry
    implements EventListener {
        final Filter filter;
        final ServiceListener listener;

        ServiceListenerEntry(ServiceListener serviceListener, String str) throws InvalidSyntaxException {
            this.listener = serviceListener;
            this.filter = str == null ? null : RFC1960Filter.fromString(str);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ServiceListenerEntry)) {
                return false;
            }
            return this.listener.equals(((ServiceListenerEntry)obj).listener);
        }

        public int hashCode() {
            return (this.filter != null ? this.filter.hashCode() >> 8 : 0) + this.listener.hashCode();
        }

        public String toString() {
            return this.listener + " " + this.filter;
        }
    }
}

