/*
 * Decompiled with CFR 0.152.
 */
package com.openatlas.framework;

import com.openatlas.framework.BundleClassLoader;
import com.openatlas.framework.BundleContextImpl;
import com.openatlas.framework.Framework;
import com.openatlas.framework.Package;
import com.openatlas.framework.ServiceReferenceImpl;
import com.openatlas.framework.bundlestorage.Archive;
import com.openatlas.framework.bundlestorage.BundleArchive;
import com.openatlas.log.Logger;
import com.openatlas.log.LoggerFactory;
import com.openatlas.util.OpenAtlasFileLock;
import com.openatlas.util.StringUtils;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleException;
import org.osgi.framework.BundleListener;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;

public final class BundleImpl
implements Bundle {
    static final Logger log = LoggerFactory.getInstance("BundleImpl");
    Archive archive;
    final File bundleDir;
    BundleClassLoader classloader;
    private final BundleContextImpl context;
    int currentStartlevel;
    ProtectionDomain domain = null;
    Hashtable<String, String> headers = new Hashtable();
    final String location;
    boolean persistently = false;
    List<BundleListener> registeredBundleListeners = null;
    List<FrameworkListener> registeredFrameworkListeners = null;
    List<ServiceListener> registeredServiceListeners = null;
    List<ServiceReference> registeredServices = null;
    Package[] staleExportedPackages = null;
    int state = 0;

    BundleImpl(File bundleDir, String location, BundleContextImpl bundleContextImpl, InputStream archiveInputStream, File archiveFile, boolean isInstall) throws BundleException {
        long currentTimeMillis = System.currentTimeMillis();
        this.location = location;
        bundleContextImpl.bundle = this;
        this.context = bundleContextImpl;
        this.currentStartlevel = Framework.initStartlevel;
        this.bundleDir = bundleDir;
        if (archiveInputStream != null) {
            try {
                this.archive = new BundleArchive(location, bundleDir, archiveInputStream);
            }
            catch (Throwable e) {
                Framework.deleteDirectory(bundleDir);
                throw new BundleException("Could not install bundle " + location, e);
            }
        }
        if (archiveFile != null) {
            try {
                this.archive = new BundleArchive(location, bundleDir, archiveFile);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.state = 2;
        Framework.notifyBundleListeners(1, this);
        this.updateMetadata();
        if (isInstall) {
            Framework.bundles.put(location, this);
            this.resolveBundle(false);
        }
        if (Framework.DEBUG_BUNDLES && log.isInfoEnabled()) {
            log.info("Framework: Bundle " + this.toString() + " created. " + (System.currentTimeMillis() - currentTimeMillis) + " ms");
        }
    }

    BundleImpl(File file, BundleContextImpl bundleContextImpl) throws Exception {
        long currentTimeMillis = System.currentTimeMillis();
        File file2 = new File(file, "meta");
        if (OpenAtlasFileLock.getInstance().LockExclusive(file2)) {
            DataInputStream dataInputStream = new DataInputStream(new FileInputStream(file2));
            this.location = dataInputStream.readUTF();
            this.currentStartlevel = dataInputStream.readInt();
            this.state = 2;
            this.persistently = dataInputStream.readBoolean();
            dataInputStream.close();
            OpenAtlasFileLock.getInstance().unLock(file2);
            bundleContextImpl.bundle = this;
            this.context = bundleContextImpl;
            this.bundleDir = file;
            try {
                this.archive = new BundleArchive(this.location, file);
                Framework.bundles.put(this.location, this);
                this.resolveBundle(false);
                if (Framework.DEBUG_BUNDLES && log.isInfoEnabled()) {
                    log.info("Framework: Bundle " + this.toString() + " loaded. " + (System.currentTimeMillis() - currentTimeMillis) + " ms");
                    return;
                }
                return;
            }
            catch (Exception e) {
                throw new BundleException("Could not load bundle " + this.location, e.getCause());
            }
        }
        throw new BundleException("FileLock failed " + file2.getAbsolutePath());
    }

    private synchronized void resolveBundle(boolean recursive) throws BundleException {
        if (this.state != 4) {
            if (this.classloader == null) {
                this.classloader = new BundleClassLoader(this);
            }
            if (recursive) {
                this.classloader.resolveBundle(true, new HashSet<BundleClassLoader>(0));
                this.state = 4;
            } else if (this.classloader.resolveBundle(false, null)) {
                this.state = 4;
            }
            Framework.notifyBundleListeners(0, this);
        }
    }

    @Override
    public long getBundleId() {
        return 0L;
    }

    @Override
    public Dictionary<String, String> getHeaders() {
        return this.headers;
    }

    @Override
    public String getLocation() {
        return this.location;
    }

    public Archive getArchive() {
        return this.archive;
    }

    public ClassLoader getClassLoader() {
        return this.classloader;
    }

    @Override
    public ServiceReference[] getRegisteredServices() {
        if (this.state == 1) {
            throw new IllegalStateException("Bundle " + this.toString() + "has been unregistered.");
        }
        if (this.registeredServices == null) {
            return null;
        }
        return this.registeredServices.toArray(new ServiceReference[this.registeredServices.size()]);
    }

    @Override
    public URL getResource(String name) {
        if (this.state != 1) {
            return this.classloader.getResource(name);
        }
        throw new IllegalStateException("Bundle " + this.toString() + " has been uninstalled");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ServiceReference[] getServicesInUse() {
        if (this.state == 1) {
            throw new IllegalStateException("Bundle " + this.toString() + "has been unregistered.");
        }
        ArrayList<ServiceReferenceImpl> arrayList = new ArrayList<ServiceReferenceImpl>();
        ServiceReferenceImpl[] serviceReferenceImplArr = Framework.services.toArray(new ServiceReferenceImpl[Framework.services.size()]);
        for (int i = 0; i < serviceReferenceImplArr.length; ++i) {
            Map<Bundle, Integer> map = serviceReferenceImplArr[i].useCounters;
            synchronized (map) {
                if (serviceReferenceImplArr[i].useCounters.get(this) != null) {
                    arrayList.add(serviceReferenceImplArr[i]);
                }
                continue;
            }
        }
        return arrayList.toArray(new ServiceReference[arrayList.size()]);
    }

    @Override
    public int getState() {
        return this.state;
    }

    @Override
    public boolean hasPermission(Object permission) {
        if (this.state != 1) {
            return true;
        }
        throw new IllegalStateException("Bundle " + this.toString() + "has been unregistered.");
    }

    @Override
    public synchronized void start() throws BundleException {
        this.persistently = true;
        this.updateMetadata();
        if (this.currentStartlevel <= Framework.startlevel) {
            this.startBundle();
        }
    }

    public synchronized void startBundle() throws BundleException {
        this.state = 0;
        if (this.state == 1) {
            throw new IllegalStateException("Cannot start uninstalled bundle " + this.toString());
        }
        if (this.state != 32) {
            if (this.state == 2) {
                this.resolveBundle(true);
            }
            this.state = 8;
            try {
                this.context.isValid = true;
                if (this.classloader.activatorClassName != null && !StringUtils.isBlank(this.classloader.activatorClassName)) {
                    Class<?> loadClass = this.classloader.loadClass(this.classloader.activatorClassName);
                    if (loadClass == null) {
                        throw new ClassNotFoundException(this.classloader.activatorClassName);
                    }
                    this.classloader.activator = (BundleActivator)loadClass.newInstance();
                    this.classloader.activator.start(this.context);
                }
                this.state = 32;
                Framework.notifyBundleListeners(2, this);
                if (Framework.DEBUG_BUNDLES && log.isInfoEnabled()) {
                    log.info("Framework: Bundle " + this.toString() + " started.");
                }
            }
            catch (Throwable th) {
                Throwable th2 = th;
                Framework.clearBundleTrace(this);
                this.state = 4;
                String str = "Error starting bundle " + this.toString();
                if (th2.getCause() != null) {
                    th2 = th2.getCause();
                }
                BundleException bundleException = new BundleException(str, th2);
            }
        }
    }

    @Override
    public synchronized void stop() throws BundleException {
        this.persistently = false;
        this.updateMetadata();
        this.stopBundle();
    }

    public synchronized void stopBundle() throws BundleException {
        if (this.state == 1) {
            throw new IllegalStateException("Cannot stop uninstalled bundle " + this.toString());
        }
        if (this.state == 32) {
            this.state = 16;
            try {
                if (this.classloader.activator != null) {
                    this.classloader.activator.stop(this.context);
                }
                if (Framework.DEBUG_BUNDLES && log.isInfoEnabled()) {
                    log.info("Framework: Bundle " + this.toString() + " stopped.");
                }
                this.classloader.activator = null;
                Framework.clearBundleTrace(this);
                this.state = 4;
                Framework.notifyBundleListeners(4, this);
                this.context.isValid = false;
            }
            catch (Throwable th) {
                this.classloader.activator = null;
                Framework.clearBundleTrace(this);
                this.state = 4;
                Framework.notifyBundleListeners(4, this);
                this.context.isValid = false;
            }
        }
    }

    @Override
    public synchronized void uninstall() throws BundleException {
        if (this.state == 1) {
            throw new IllegalStateException("Bundle " + this.toString() + " is already uninstalled.");
        }
        if (this.state == 32) {
            try {
                this.stopBundle();
            }
            catch (Throwable th) {
                Framework.notifyFrameworkListeners(2, this, th);
            }
        }
        this.state = 1;
        File file = new File(this.bundleDir, "meta");
        if (OpenAtlasFileLock.getInstance().LockExclusive(file)) {
            file.delete();
            OpenAtlasFileLock.getInstance().unLock(file);
            if (this.classloader.originalExporter != null) {
                this.classloader.originalExporter.cleanup(true);
                this.classloader.originalExporter = null;
            }
        } else {
            throw new BundleException("FileLock failed " + file.getAbsolutePath());
        }
        this.classloader.cleanup(true);
        this.classloader = null;
        Framework.bundles.remove(this);
        Framework.notifyBundleListeners(16, this);
        this.context.isValid = false;
        this.context.bundle = null;
    }

    @Override
    public synchronized void update() throws BundleException {
        String str = this.headers.get("Bundle-UpdateLocation");
        try {
            String str2 = str == null ? this.location : str;
            this.update(new URL(str2).openConnection().getInputStream());
        }
        catch (Throwable e) {
            throw new BundleException("Could not update " + this.toString() + " from " + str, e);
        }
    }

    @Override
    public synchronized void update(InputStream inputStream) throws BundleException {
        if (this.state == 1) {
            throw new IllegalStateException("Cannot update uninstalled bundle " + this.toString());
        }
        try {
            this.archive.newRevision(this.location, this.bundleDir, inputStream);
        }
        catch (Throwable e) {
            throw new BundleException("Could not update bundle " + this.toString(), e);
        }
    }

    @Override
    public synchronized void update(File bundleFile) throws BundleException {
        if (this.state == 1) {
            throw new IllegalStateException("Cannot update uninstalled bundle " + this.toString());
        }
        try {
            this.archive.newRevision(this.location, this.bundleDir, bundleFile);
        }
        catch (Throwable e) {
            throw new BundleException("Could not update bundle " + this.toString(), e);
        }
    }

    public synchronized void refresh() throws BundleException {
        Integer obj;
        if (this.state == 1) {
            throw new IllegalStateException("Cannot refresh uninstalled bundle " + this.toString());
        }
        if (this.state == 32) {
            this.stopBundle();
            obj = 1;
        } else {
            obj = null;
        }
        try {
            this.archive = new BundleArchive(this.location, this.bundleDir);
            BundleClassLoader bundleClassLoader = new BundleClassLoader(this);
            String[] strArr = this.classloader.exports;
            if (strArr.length > 0) {
                Integer obj2 = null;
                for (int i = 0; i < strArr.length; ++i) {
                    Integer obj3;
                    Package packageR = Framework.exportedPackages.get(new Package(strArr[i], null, false));
                    if (packageR.importingBundles == null || packageR.classloader != this.classloader) {
                        obj3 = obj2;
                    } else {
                        packageR.removalPending = true;
                        obj3 = 1;
                    }
                    obj2 = obj3;
                }
                if (obj2 != null) {
                    bundleClassLoader.originalExporter = this.classloader.originalExporter != null ? this.classloader.originalExporter : this.classloader;
                }
            }
            this.classloader.cleanup(true);
            this.classloader = bundleClassLoader;
            this.state = this.classloader.resolveBundle(false, null) ? 4 : 2;
            Framework.notifyBundleListeners(8, this);
            if (obj != null) {
                this.startBundle();
            }
        }
        catch (BundleException e) {
            throw e;
        }
        catch (Throwable e2) {
            throw new BundleException("Could not refresh bundle " + this.toString(), e2);
        }
    }

    public synchronized void optDexFile() {
        this.getArchive().optDexFile();
    }

    public synchronized void purge() throws BundleException {
        try {
            this.getArchive().purge();
        }
        catch (Throwable e) {
            throw new BundleException("Could not purge bundle " + this.toString(), e);
        }
    }

    /*
     * Exception decompiling
     */
    void updateMetadata() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [10[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public String toString() {
        return this.location;
    }
}

