/*
 * Decompiled with CFR 0.152.
 */
package com.openatlas.framework;

import com.openatlas.framework.BundleImpl;
import com.openatlas.framework.Framework;
import com.openatlas.framework.RFC1960Filter;
import com.openatlas.framework.ServiceReferenceImpl;
import com.openatlas.log.Logger;
import com.openatlas.log.LoggerFactory;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.List;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.BundleListener;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.SynchronousBundleListener;

public class BundleContextImpl
implements BundleContext {
    static final Logger log = LoggerFactory.getInstance("BundleContextImpl");
    BundleImpl bundle;
    boolean isValid = true;

    private void checkValid() {
        if (!this.isValid) {
            throw new IllegalStateException("BundleContext of bundle " + this.bundle + " used after bundle has been stopped or uninstalled.");
        }
    }

    @Override
    public void addBundleListener(BundleListener bundleListener) {
        List<BundleListener> list;
        this.checkValid();
        List<BundleListener> list2 = list = bundleListener instanceof SynchronousBundleListener ? Framework.syncBundleListeners : Framework.bundleListeners;
        if (this.bundle.registeredBundleListeners == null) {
            this.bundle.registeredBundleListeners = new ArrayList<BundleListener>();
        }
        if (!this.bundle.registeredBundleListeners.contains(bundleListener)) {
            list.add(bundleListener);
            this.bundle.registeredBundleListeners.add(bundleListener);
        }
    }

    @Override
    public void addFrameworkListener(FrameworkListener frameworkListener) {
        this.checkValid();
        if (this.bundle.registeredFrameworkListeners == null) {
            this.bundle.registeredFrameworkListeners = new ArrayList<FrameworkListener>();
        }
        if (!this.bundle.registeredFrameworkListeners.contains(frameworkListener)) {
            Framework.frameworkListeners.add(frameworkListener);
            this.bundle.registeredFrameworkListeners.add(frameworkListener);
        }
    }

    @Override
    public void addServiceListener(ServiceListener serviceListener, String filter) throws InvalidSyntaxException {
        this.checkValid();
        Framework.ServiceListenerEntry serviceListenerEntry = new Framework.ServiceListenerEntry(serviceListener, filter);
        if (this.bundle.registeredServiceListeners == null) {
            this.bundle.registeredServiceListeners = new ArrayList<ServiceListener>();
        }
        if (this.isServiceListenerRegistered(serviceListener)) {
            Framework.serviceListeners.remove(serviceListenerEntry);
        } else {
            this.bundle.registeredServiceListeners.add(serviceListener);
        }
        Framework.serviceListeners.add(serviceListenerEntry);
    }

    private boolean isServiceListenerRegistered(ServiceListener serviceListener) {
        ServiceListener[] serviceListenerArr;
        for (ServiceListener serviceListener2 : serviceListenerArr = this.bundle.registeredServiceListeners.toArray(new ServiceListener[this.bundle.registeredServiceListeners.size()])) {
            if (serviceListener2 != serviceListener) continue;
            return true;
        }
        return false;
    }

    @Override
    public void addServiceListener(ServiceListener serviceListener) {
        this.checkValid();
        try {
            this.addServiceListener(serviceListener, null);
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            // empty catch block
        }
    }

    @Override
    public Filter createFilter(String filter) throws InvalidSyntaxException {
        if (filter != null) {
            return RFC1960Filter.fromString(filter);
        }
        throw new NullPointerException();
    }

    @Override
    public Bundle getBundle() {
        return this.bundle;
    }

    @Override
    public Bundle getBundle(long bundleID) {
        this.checkValid();
        return null;
    }

    @Override
    public Bundle[] getBundles() {
        this.checkValid();
        List<Bundle> bundles = Framework.getBundles();
        Bundle[] bundleArr = bundles.toArray(new Bundle[bundles.size()]);
        Bundle[] obj = new Bundle[bundleArr.length + 1];
        obj[0] = Framework.systemBundle;
        System.arraycopy(bundleArr, 0, obj, 1, bundleArr.length);
        return obj;
    }

    @Override
    public File getDataFile(String bundleName) {
        this.checkValid();
        try {
            File file = new File(new File(this.bundle.bundleDir, "/data/"), bundleName);
            file.getParentFile().mkdirs();
            return file;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public String getProperty(String key) {
        return (String)Framework.properties.get(key);
    }

    @Override
    public Object getService(ServiceReference serviceReference) {
        this.checkValid();
        if (serviceReference != null) {
            return ((ServiceReferenceImpl)serviceReference).getService(this.bundle);
        }
        throw new NullPointerException("Null service reference.");
    }

    @Override
    public ServiceReference[] getServiceReferences(String clazz, String filter) throws InvalidSyntaxException {
        List<ServiceReference> collection = null;
        this.checkValid();
        Filter fromString = RFC1960Filter.fromString(filter);
        if (clazz == null) {
            collection = Framework.services;
        } else {
            List<ServiceReference> list = Framework.classes_services.get(clazz);
            if (list == null) {
                return null;
            }
        }
        ArrayList<ServiceReferenceImpl> arrayList = new ArrayList<ServiceReferenceImpl>();
        ServiceReferenceImpl[] serviceReferenceImplArr = collection.toArray(new ServiceReferenceImpl[collection.size()]);
        for (int i = 0; i < serviceReferenceImplArr.length; ++i) {
            if (!fromString.match(serviceReferenceImplArr[i])) continue;
            arrayList.add(serviceReferenceImplArr[i]);
        }
        if (Framework.DEBUG_SERVICES && log.isInfoEnabled()) {
            log.info("Framework: REQUESTED SERVICES " + clazz + " " + filter);
            log.info("\tRETURNED " + arrayList);
        }
        return arrayList.size() == 0 ? null : arrayList.toArray(new ServiceReference[arrayList.size()]);
    }

    @Override
    public ServiceReference getServiceReference(String clazz) {
        ServiceReference serviceReference = null;
        this.checkValid();
        int i = -1;
        long j = 5000L;
        List<ServiceReference> list = Framework.classes_services.get(clazz);
        if (list != null) {
            ServiceReference[] serviceReferenceArr = list.toArray(new ServiceReference[list.size()]);
            for (int i2 = 0; i2 < serviceReferenceArr.length; ++i2) {
                int i3;
                ServiceReference serviceReference2;
                Integer num = (Integer)serviceReferenceArr[i2].getProperty("service.ranking");
                int intValue = num != null ? num : 0;
                long longValue = (Long)serviceReferenceArr[i2].getProperty("service.id");
                if (intValue > i || intValue == i && longValue < j) {
                    serviceReference2 = serviceReferenceArr[i2];
                    i3 = intValue;
                } else {
                    longValue = j;
                    i3 = i;
                    serviceReference2 = serviceReference;
                }
                serviceReference = serviceReference2;
                i = i3;
                j = longValue;
            }
            if (Framework.DEBUG_SERVICES && log.isInfoEnabled()) {
                log.info("Framework: REQUESTED SERVICE " + clazz);
                log.info("\tRETURNED " + serviceReference);
            }
        }
        return serviceReference;
    }

    @Override
    public Bundle installBundle(String bundleName) throws BundleException {
        if (bundleName == null) {
            throw new IllegalArgumentException("Location must not be null");
        }
        this.checkValid();
        return Framework.installNewBundle(bundleName);
    }

    @Override
    public Bundle installBundle(String location, InputStream inputStream) throws BundleException {
        if (location == null) {
            throw new IllegalArgumentException("Location must not be null");
        }
        this.checkValid();
        return Framework.installNewBundle(location, inputStream);
    }

    @Override
    public ServiceRegistration registerService(String[] clazzes, Object service, Dictionary<String, ?> properties) {
        this.checkValid();
        if (service == null) {
            throw new IllegalArgumentException("Cannot register Component null service");
        }
        ServiceReferenceImpl serviceReferenceImpl = new ServiceReferenceImpl(this.bundle, service, properties, clazzes);
        Framework.services.add(serviceReferenceImpl);
        if (this.bundle.registeredServices == null) {
            this.bundle.registeredServices = new ArrayList<ServiceReference>();
        }
        this.bundle.registeredServices.add(serviceReferenceImpl);
        for (String addValue : clazzes) {
            Framework.addValue(Framework.classes_services, addValue, serviceReferenceImpl);
        }
        if (Framework.DEBUG_SERVICES && log.isInfoEnabled()) {
            log.info("Framework: REGISTERED SERVICE " + clazzes[0]);
        }
        Framework.notifyServiceListeners(1, serviceReferenceImpl);
        return serviceReferenceImpl.registration;
    }

    @Override
    public ServiceRegistration registerService(String clazz, Object service, Dictionary<String, ?> properties) {
        return this.registerService(new String[]{clazz}, service, properties);
    }

    @Override
    public void removeBundleListener(BundleListener bundleListener) {
        this.checkValid();
        (bundleListener instanceof SynchronousBundleListener ? Framework.syncBundleListeners : Framework.bundleListeners).remove(bundleListener);
        this.bundle.registeredBundleListeners.remove(bundleListener);
        if (this.bundle.registeredBundleListeners.isEmpty()) {
            this.bundle.registeredBundleListeners = null;
        }
    }

    @Override
    public void removeFrameworkListener(FrameworkListener frameworkListener) {
        this.checkValid();
        Framework.frameworkListeners.remove(frameworkListener);
        this.bundle.registeredFrameworkListeners.remove(frameworkListener);
        if (this.bundle.registeredFrameworkListeners.isEmpty()) {
            this.bundle.registeredFrameworkListeners = null;
        }
    }

    @Override
    public void removeServiceListener(ServiceListener serviceListener) {
        this.checkValid();
        try {
            Framework.serviceListeners.remove(new Framework.ServiceListenerEntry(serviceListener, null));
            this.bundle.registeredServiceListeners.remove(serviceListener);
            if (this.bundle.registeredServiceListeners.isEmpty()) {
                this.bundle.registeredServiceListeners = null;
            }
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            // empty catch block
        }
    }

    @Override
    public synchronized boolean ungetService(ServiceReference serviceReference) {
        this.checkValid();
        return ((ServiceReferenceImpl)serviceReference).ungetService(this.bundle);
    }
}

