/*
 * Decompiled with CFR 0.152.
 */
package com.openatlas.framework;

import com.openatlas.framework.BundleImpl;
import com.openatlas.framework.Framework;
import com.openatlas.framework.Package;
import com.openatlas.framework.bundlestorage.Archive;
import com.openatlas.framework.bundlestorage.BundleArchiveRevision;
import com.openatlas.hack.OpenAtlasHacks;
import com.openatlas.log.Logger;
import com.openatlas.log.LoggerFactory;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleException;

public final class BundleClassLoader
extends ClassLoader {
    private static final List<URL> EMPTY_LIST;
    static final HashSet<String> FRAMEWORK_PACKAGES;
    static final Logger log;
    BundleActivator activator = null;
    String activatorClassName = null;
    final Archive archive;
    BundleImpl bundle;
    private String[] dynamicImports = null;
    String[] exports = new String[0];
    Map<String, BundleClassLoader> importDelegations;
    String[] imports = new String[0];
    private File[] nativeLibraryDirectories;
    BundleClassLoader originalExporter = null;
    String[] requires = new String[0];

    BundleClassLoader(BundleImpl bundleImpl) throws BundleException {
        super(Object.class.getClassLoader());
        this.bundle = bundleImpl;
        this.archive = bundleImpl.archive;
        if (this.archive == null) {
            throw new BundleException("Not Component valid bundle: " + bundleImpl.location);
        }
        try {
            this.processManifest(this.archive.getManifest());
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new BundleException("Not Component valid bundle: " + bundleImpl.location);
        }
    }

    public BundleImpl getBundle() {
        return this.bundle;
    }

    private void processManifest(Manifest manifest) throws BundleException {
        Attributes mainAttributes = manifest != null ? manifest.getMainAttributes() : new Attributes();
        this.checkEE(BundleClassLoader.readProperty(mainAttributes, "Bundle-RequiredExecutionEnvironment"), BundleClassLoader.splitString(System.getProperty("org.osgi.framework.executionenvironment")));
        this.exports = BundleClassLoader.readProperty(mainAttributes, "Export-Package");
        this.imports = BundleClassLoader.readProperty(mainAttributes, "Import-Package");
        this.dynamicImports = BundleClassLoader.readProperty(mainAttributes, "DynamicImport-Package");
        this.requires = BundleClassLoader.readProperty(mainAttributes, "Require-Bundle");
        this.activatorClassName = mainAttributes.getValue("Bundle-Activator");
        Hashtable<String, String> hashtable = new Hashtable<String, String>(mainAttributes.size());
        Object[] toArray = mainAttributes.keySet().toArray(new Object[mainAttributes.keySet().size()]);
        for (int i = 0; i < toArray.length; ++i) {
            hashtable.put(toArray[i].toString(), mainAttributes.get(toArray[i]).toString());
        }
        this.bundle.headers = hashtable;
    }

    private void checkEE(String[] strArr, String[] strArr2) throws BundleException {
        if (strArr.length != 0) {
            HashSet<String> hashSet = new HashSet<String>(Arrays.asList(strArr2));
            for (int i = 0; i < strArr.length; ++i) {
                if (!hashSet.contains(strArr[i])) {
                    continue;
                }
                return;
            }
            throw new BundleException("Platform does not provide EEs " + Arrays.asList(strArr));
        }
    }

    boolean resolveBundle(boolean resolve, HashSet<BundleClassLoader> hashSet) throws BundleException {
        HashSet<String> hashSet2;
        if (Framework.DEBUG_CLASSLOADING && log.isInfoEnabled()) {
            log.info("BundleClassLoader: Resolving " + this.bundle + (resolve ? " (critical)" : " (not critical)"));
        }
        if (this.exports.length > 0) {
            HashSet<String> hashSet3 = new HashSet<String>(this.exports.length);
            for (String parsePackageString : this.exports) {
                hashSet3.add(Package.parsePackageString(parsePackageString)[0]);
            }
            hashSet2 = hashSet3;
        } else {
            hashSet2 = null;
        }
        if (this.imports.length > 0) {
            if (this.importDelegations == null) {
                this.importDelegations = new HashMap<String, BundleClassLoader>(this.imports.length);
            }
            for (int i2 = 0; i2 < this.imports.length; ++i2) {
                String obj = Package.parsePackageString(this.imports[i2])[0];
                if (FRAMEWORK_PACKAGES.contains(obj) || this.importDelegations.get(obj) != null || hashSet2 != null && hashSet2.contains(obj)) continue;
                BundleClassLoader bundleClassLoader = Framework.getImport(this.bundle, this.imports[i2], resolve, hashSet);
                if (bundleClassLoader != null) {
                    if (bundleClassLoader == this) continue;
                    this.importDelegations.put(obj, bundleClassLoader);
                    continue;
                }
                if (resolve) {
                    throw new BundleException("Unsatisfied import " + this.imports[i2] + " for bundle " + this.bundle.toString(), new ClassNotFoundException("Unsatisfied import " + this.imports[i2]));
                }
                if (this.exports.length > 0) {
                    Framework.export(this, this.exports, false);
                }
                if (!Framework.DEBUG_CLASSLOADING || !log.isInfoEnabled()) {
                    return false;
                }
                log.info("BundleClassLoader: Missing import " + this.imports[i2] + ". Resolving attempt terminated unsuccessfully.");
                return false;
            }
        }
        if (this.exports.length > 0) {
            if (this.importDelegations == null) {
                this.importDelegations = new HashMap<String, BundleClassLoader>(this.imports.length);
            }
            for (int i = 0; i < this.exports.length; ++i) {
                BundleClassLoader bundleClassLoader2 = Framework.getImport(this.bundle, Package.parsePackageString(this.exports[i])[0], false, null);
                if (bundleClassLoader2 == null || bundleClassLoader2 == this) continue;
                this.importDelegations.put(Package.parsePackageString(this.exports[i])[0], bundleClassLoader2);
            }
        }
        if (this.exports.length > 0) {
            Framework.export(this, this.exports, true);
        }
        return true;
    }

    void cleanup(boolean z) {
        ArrayList<Package> arrayList = new ArrayList<Package>();
        for (String str : this.exports) {
            Package packageR = Framework.exportedPackages.get(new Package(str, null, false));
            if (packageR == null) continue;
            if (packageR.importingBundles == null) {
                Framework.exportedPackages.remove(packageR);
                packageR.importingBundles = null;
                continue;
            }
            packageR.removalPending = true;
            arrayList.add(packageR);
        }
        if (this.bundle != null) {
            this.bundle.staleExportedPackages = z ? arrayList.toArray(new Package[arrayList.size()]) : null;
        }
        if (this.importDelegations != null) {
            String[] strArr;
            for (String str2 : strArr = this.importDelegations.keySet().toArray(new String[this.importDelegations.size()])) {
                Package packageR2 = Framework.exportedPackages.get(new Package(str2, null, false));
                if (packageR2 == null || packageR2.importingBundles == null) continue;
                packageR2.importingBundles.remove(this.bundle);
                if (!packageR2.importingBundles.isEmpty()) continue;
                packageR2.importingBundles = null;
                if (!packageR2.removalPending) continue;
                Framework.exportedPackages.remove(packageR2);
            }
        }
        this.importDelegations = null;
        this.activator = null;
        this.originalExporter = null;
        if (z) {
            if (arrayList.size() == 0) {
                this.bundle = null;
            }
            this.activatorClassName = null;
            this.imports = null;
            this.dynamicImports = null;
        }
    }

    @Override
    protected Class<?> findClass(String str) throws ClassNotFoundException {
        BundleClassLoader bundleClassLoader;
        if (FRAMEWORK_PACKAGES.contains(BundleClassLoader.packageOf(str))) {
            return Framework.systemClassLoader.loadClass(str);
        }
        Class<?> findOwnClass = this.findOwnClass(str);
        if (findOwnClass != null) {
            return findOwnClass;
        }
        if (this.dynamicImports.length > 0) {
            for (int i = 0; i < this.dynamicImports.length; ++i) {
                if (this.dynamicImports[i].indexOf("version") > -1) {
                    Package[] packageArr = Framework.exportedPackages.keySet().toArray(new Package[Framework.exportedPackages.size()]);
                    for (int i2 = 0; i2 < packageArr.length; ++i2) {
                        Class<?> findDelegatedClass;
                        if (!packageArr[i2].matches(this.dynamicImports[i]) || (findDelegatedClass = BundleClassLoader.findDelegatedClass(packageArr[i2].classloader, str)) == null) continue;
                        return findDelegatedClass;
                    }
                    continue;
                }
                Package packageR = Framework.exportedPackages.get(new Package(BundleClassLoader.packageOf(str), null, false));
                if (packageR == null || (findOwnClass = BundleClassLoader.findDelegatedClass(packageR.classloader, str)) == null) continue;
                return findOwnClass;
            }
        }
        if (this.importDelegations != null && (bundleClassLoader = this.importDelegations.get(BundleClassLoader.packageOf(str))) != null && (findOwnClass = BundleClassLoader.findDelegatedClass(bundleClassLoader, str)) != null) {
            return findOwnClass;
        }
        try {
            findOwnClass = Framework.systemClassLoader.loadClass(str);
            if (findOwnClass != null) {
                return findOwnClass;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw new ClassNotFoundException("Can't find class " + str + " in BundleClassLoader: " + this.bundle.getLocation());
    }

    private Class<?> findOwnClass(String str) {
        try {
            return this.archive.findClass(str, this);
        }
        catch (Exception e) {
            if (!(e instanceof BundleArchiveRevision.DexLoadException)) {
                return null;
            }
            throw (BundleArchiveRevision.DexLoadException)e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Class<?> findDelegatedClass(BundleClassLoader bundleClassLoader, String str) {
        Class<?> findLoadedClass;
        BundleClassLoader bundleClassLoader2 = bundleClassLoader;
        synchronized (bundleClassLoader2) {
            findLoadedClass = bundleClassLoader.findLoadedClass(str);
            if (findLoadedClass == null) {
                findLoadedClass = bundleClassLoader.findOwnClass(str);
            }
        }
        return findLoadedClass;
    }

    @Override
    protected URL findResource(String str) {
        String stripTrailing = BundleClassLoader.stripTrailing(str);
        List<URL> findOwnResources = this.findOwnResources(stripTrailing, false);
        if (findOwnResources.size() > 0) {
            return findOwnResources.get(0);
        }
        List<URL> findImportedResources = this.findImportedResources(stripTrailing, false);
        return findImportedResources.size() > 0 ? findImportedResources.get(0) : null;
    }

    @Override
    protected Enumeration<URL> findResources(String str) {
        String stripTrailing = BundleClassLoader.stripTrailing(str);
        List<URL> findOwnResources = this.findOwnResources(stripTrailing, true);
        findOwnResources.addAll(this.findImportedResources(stripTrailing, true));
        return Collections.enumeration(findOwnResources);
    }

    private List<URL> findOwnResources(String str, boolean z) {
        try {
            return this.archive.getResources(str);
        }
        catch (IOException e) {
            e.printStackTrace();
            return EMPTY_LIST;
        }
    }

    private List<URL> findImportedResources(String str, boolean z) {
        if (this.bundle.state == 2 || this.importDelegations == null) {
            return EMPTY_LIST;
        }
        BundleClassLoader bundleClassLoader = this.importDelegations.get(BundleClassLoader.packageOf(BundleClassLoader.pseudoClassname(str)));
        if (bundleClassLoader == null) {
            return EMPTY_LIST;
        }
        return bundleClassLoader.originalExporter == null ? bundleClassLoader.findOwnResources(str, z) : bundleClassLoader.originalExporter.findOwnResources(str, z);
    }

    @Override
    protected String findLibrary(String nickname) {
        File findLibrary;
        String mapLibraryName = System.mapLibraryName(nickname);
        if (this.nativeLibraryDirectories != null) {
            for (File file : this.nativeLibraryDirectories) {
                File file2 = new File(file, mapLibraryName);
                if (!file2.canRead()) continue;
                return file2.getAbsolutePath();
            }
        }
        if ((findLibrary = this.archive.findLibrary(mapLibraryName)) != null) {
            return findLibrary.getAbsolutePath();
        }
        try {
            return (String)OpenAtlasHacks.ClassLoader_findLibrary.invoke(Framework.systemClassLoader, nickname);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String toString() {
        return "BundleClassLoader[Bundle" + this.bundle + "]";
    }

    private static String[] readProperty(Attributes attributes, String name) throws BundleException {
        String value = attributes.getValue(name);
        if (value == null || !value.equals("")) {
            return BundleClassLoader.splitString(value);
        }
        return new String[0];
    }

    private static String[] splitString(String str) {
        if (str == null) {
            return new String[0];
        }
        StringTokenizer stringTokenizer = new StringTokenizer(str, ",");
        if (stringTokenizer.countTokens() == 0) {
            return new String[]{str};
        }
        String[] strArr = new String[stringTokenizer.countTokens()];
        for (int i = 0; i < strArr.length; ++i) {
            strArr[i] = stringTokenizer.nextToken().trim();
        }
        return strArr;
    }

    private static String stripTrailing(String str) {
        return str.startsWith("/") || str.startsWith("\\") ? str.substring(1) : str;
    }

    private static String packageOf(String str) {
        int lastIndexOf = str.lastIndexOf(46);
        return lastIndexOf > -1 ? str.substring(0, lastIndexOf) : "";
    }

    private static String pseudoClassname(String str) {
        return BundleClassLoader.stripTrailing(str).replace('.', '-').replace('/', '.').replace('\\', '.');
    }

    static {
        log = LoggerFactory.getInstance("BundleClassLoader");
        FRAMEWORK_PACKAGES = new HashSet();
        FRAMEWORK_PACKAGES.add("com.openAtlas.framework");
        FRAMEWORK_PACKAGES.add("org.osgi.framework");
        FRAMEWORK_PACKAGES.add("org.osgi.service.packageadmin");
        FRAMEWORK_PACKAGES.add("org.osgi.service.startlevel");
        EMPTY_LIST = new ArrayList<URL>();
    }

    @Deprecated
    private static final class BundleURLHandler
    extends URLStreamHandler {
        private final InputStream input;

        private BundleURLHandler(InputStream inputStream) {
            this.input = new AnonymousClass_1(inputStream);
        }

        @Override
        protected URLConnection openConnection(URL url) throws IOException {
            return new AnonymousClass_2(url);
        }

        @Override
        protected int hashCode(URL url) {
            return this.input.hashCode();
        }

        class AnonymousClass_2
        extends URLConnection {
            AnonymousClass_2(URL url) {
                super(url);
            }

            @Override
            public InputStream getInputStream() throws IOException {
                return BundleURLHandler.this.input;
            }

            @Override
            public void connect() throws IOException {
            }
        }

        class AnonymousClass_1
        extends InputStream {
            final InputStream stream;

            AnonymousClass_1(InputStream inputStream) {
                this.stream = inputStream;
            }

            @Override
            public int read() throws IOException {
                return this.stream.read();
            }

            @Override
            public int read(byte[] bArr) throws IOException {
                return this.stream.read(bArr);
            }
        }
    }
}

