/*
 * Decompiled with CFR 0.152.
 */
package com.openatlas.bundleInfo;

import android.text.TextUtils;
import android.util.Log;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class BundleInfoList {
    private static BundleInfoList singleton;
    private final String TAG = BundleInfoList.class.getSimpleName();
    private List<BundleInfo> mBundleInfoList;

    private BundleInfoList() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized BundleInfoList getInstance() {
        Class<BundleInfoList> clazz = BundleInfoList.class;
        synchronized (BundleInfoList.class) {
            if (singleton == null) {
                singleton = new BundleInfoList();
            }
            BundleInfoList bundleInfoList = singleton;
            // ** MonitorExit[var1] (shouldn't be in output)
            return bundleInfoList;
        }
    }

    public synchronized boolean init(ArrayList<BundleInfo> linkedList) {
        boolean initilized;
        if (this.mBundleInfoList != null || linkedList == null) {
            Log.i((String)this.TAG, (String)"XXXXXBundleInfoList initialization failed.");
            initilized = false;
        } else {
            this.mBundleInfoList = linkedList;
            initilized = true;
        }
        return initilized;
    }

    public List<String> getDependencyForBundle(String mBundleName) {
        if (this.mBundleInfoList == null || this.mBundleInfoList.size() == 0) {
            return null;
        }
        for (BundleInfo bundleInfo : this.mBundleInfoList) {
            if (!bundleInfo.bundleName.equals(mBundleName)) continue;
            ArrayList<String> mDependentBundleNames = new ArrayList<String>();
            if (bundleInfo != null && bundleInfo.DependentBundles != null) {
                for (int i = 0; i < bundleInfo.DependentBundles.size(); ++i) {
                    if (TextUtils.isEmpty((CharSequence)bundleInfo.DependentBundles.get(i))) continue;
                    mDependentBundleNames.add(bundleInfo.DependentBundles.get(i));
                }
            }
            return mDependentBundleNames;
        }
        return null;
    }

    public boolean getHasSO(String mBundleName) {
        if (this.mBundleInfoList == null || this.mBundleInfoList.isEmpty()) {
            return false;
        }
        for (int index = 0; index < this.mBundleInfoList.size(); ++index) {
            BundleInfo bundleInfo = this.mBundleInfoList.get(index);
            if (!bundleInfo.bundleName.equals(mBundleName)) continue;
            return bundleInfo.hasSO;
        }
        return false;
    }

    public String getBundleNameForComponet(String mComponentName) {
        if (this.mBundleInfoList == null || this.mBundleInfoList.size() == 0) {
            return null;
        }
        for (BundleInfo bundleInfo : this.mBundleInfoList) {
            for (String equals : bundleInfo.Components) {
                if (!equals.equals(mComponentName)) continue;
                return bundleInfo.bundleName;
            }
        }
        return null;
    }

    @Deprecated
    public List<String> getAllBundleNames() {
        if (this.mBundleInfoList == null || this.mBundleInfoList.isEmpty()) {
            return null;
        }
        LinkedList<String> linkedList = new LinkedList<String>();
        for (int index = 0; index < this.mBundleInfoList.size(); ++index) {
            BundleInfo bundleInfo = this.mBundleInfoList.get(index);
            linkedList.add(bundleInfo.bundleName);
        }
        return linkedList;
    }

    public BundleInfo getBundleInfo(String mBundleName) {
        if (this.mBundleInfoList == null || this.mBundleInfoList.isEmpty()) {
            return null;
        }
        for (int index = 0; index < this.mBundleInfoList.size(); ++index) {
            BundleInfo bundleInfo = this.mBundleInfoList.get(index);
            if (!bundleInfo.bundleName.equals(mBundleName)) continue;
            return bundleInfo;
        }
        return null;
    }

    public void print() {
        if (this.mBundleInfoList != null && this.mBundleInfoList.isEmpty()) {
            for (int index = 0; index < this.mBundleInfoList.size(); ++index) {
                BundleInfo bundleInfo = this.mBundleInfoList.get(index);
                Log.i((String)this.TAG, (String)("BundleName: " + bundleInfo.bundleName));
                for (String str : bundleInfo.Components) {
                    Log.i((String)this.TAG, (String)("****components: " + str));
                }
                for (String str2 : bundleInfo.DependentBundles) {
                    Log.i((String)this.TAG, (String)("****dependancy: " + str2));
                }
            }
        }
    }

    public static class BundleInfo {
        public List<String> Components;
        public List<String> DependentBundles;
        public String bundleName;
        public boolean hasSO;
    }
}

