/*
 * Decompiled with CFR 0.152.
 */
package com.openatlas.android.task;

import android.annotation.TargetApi;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Debug;
import android.os.Looper;
import android.os.MessageQueue;
import android.util.Log;
import com.openatlas.android.task.SaturativeExecutor;
import java.lang.reflect.Field;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class Coordinator {
    private static final String TAG = "Coord";
    private static final Executor mExecutor;
    static final Queue<TaggedRunnable> mIdleTasks;
    private static final BlockingQueue<Runnable> mPoolWorkQueue;

    @TargetApi(value=11)
    public static void postTask(TaggedRunnable taggedRunnable) {
        PostTask aVar = new PostTask(taggedRunnable);
        if (Build.VERSION.SDK_INT < 11) {
            aVar.execute(new Void[0]);
        } else {
            aVar.executeOnExecutor(mExecutor, new Void[0]);
        }
    }

    public static void postTasks(TaggedRunnable ... taggedRunnableArr) {
        for (TaggedRunnable taggedRunnable : taggedRunnableArr) {
            if (taggedRunnable == null) continue;
            Coordinator.postTask(taggedRunnable);
        }
    }

    public static void postIdleTask(TaggedRunnable taggedRunnable) {
        mIdleTasks.add(taggedRunnable);
    }

    public static void runTask(TaggedRunnable taggedRunnable) {
        Coordinator.runWithTiming(taggedRunnable);
    }

    public static void runTasks(TaggedRunnable ... taggedRunnableArr) {
        for (TaggedRunnable taggedRunnable : taggedRunnableArr) {
            if (taggedRunnable == null) continue;
            Coordinator.runWithTiming(taggedRunnable);
        }
    }

    public static void scheduleIdleTasks() {
        Looper.myQueue().addIdleHandler(new MessageQueue.IdleHandler(){

            public boolean queueIdle() {
                TaggedRunnable taggedRunnable = mIdleTasks.poll();
                if (taggedRunnable == null) {
                    return false;
                }
                Coordinator.postTask(taggedRunnable);
                return !mIdleTasks.isEmpty();
            }
        });
    }

    private static void runWithTiming(TaggedRunnable taggedRunnable) {
        block7: {
            long nanoTime;
            long j = 0L;
            boolean isDebug = true;
            if (isDebug) {
                nanoTime = System.nanoTime();
                j = Debug.threadCpuTimeNanos();
            } else {
                nanoTime = 0L;
            }
            try {
                taggedRunnable.run();
                if (isDebug) {
                    System.out.println("Timing - " + Thread.currentThread().getName() + " " + taggedRunnable.tag + ": " + (Debug.threadCpuTimeNanos() - j) / 1000000L + "ms (cpu) / " + (System.nanoTime() - nanoTime) / 1000000L + "ms (real)");
                }
            }
            catch (RuntimeException e) {
                System.out.println("Exception in " + taggedRunnable.tag);
                if (isDebug) {
                    System.out.println("Timing - " + Thread.currentThread().getName() + " " + taggedRunnable.tag + " (failed): " + (Debug.threadCpuTimeNanos() - j) / 1000000L + "ms (cpu) / " + (System.nanoTime() - nanoTime) / 1000000L + "ms (real)");
                }
            }
            catch (Throwable th) {
                th.printStackTrace();
                boolean i = true;
                if (!isDebug) break block7;
                System.out.println("Timing - " + Thread.currentThread().getName() + " " + taggedRunnable.tag + (i ? " (failed): " : ": ") + (Debug.threadCpuTimeNanos() - j) / 1000000L + "ms (cpu) / " + (System.nanoTime() - nanoTime) / 1000000L + "ms (real)");
            }
        }
    }

    @TargetApi(value=11)
    static Executor getDefaultAsyncTaskExecutor() {
        if (Build.VERSION.SDK_INT >= 11) {
            return AsyncTask.SERIAL_EXECUTOR;
        }
        try {
            Field declaredField = AsyncTask.class.getDeclaredField("sExecutor");
            declaredField.setAccessible(true);
            return (Executor)declaredField.get(null);
        }
        catch (Exception e) {
            return null;
        }
    }

    static Executor getCurrentExecutor() {
        return mExecutor;
    }

    @TargetApi(value=11)
    private static ThreadPoolExecutor getDefaultThreadPoolExecutor() {
        try {
            return (ThreadPoolExecutor)AsyncTask.THREAD_POOL_EXECUTOR;
        }
        catch (Throwable th) {
            Log.e((String)TAG, (String)"Unexpected failure to get default ThreadPoolExecutor of AsyncTask.", (Throwable)th);
            return null;
        }
    }

    static {
        mIdleTasks = new LinkedList<TaggedRunnable>();
        mPoolWorkQueue = new LinkedBlockingQueue<Runnable>(128);
        ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(8, 16, 1L, TimeUnit.SECONDS, mPoolWorkQueue, new ThreadFactory(){
            private final AtomicInteger a = new AtomicInteger(1);

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, "CoordTask #" + this.a.getAndIncrement());
            }
        }, new CoordinatorRejectHandler());
        mExecutor = threadPoolExecutor;
        SaturativeExecutor.installAsDefaultAsyncTaskExecutor(threadPoolExecutor);
    }

    static class PostTask
    extends AsyncTask<Void, Void, Void> {
        private final TaggedRunnable mTaggedRunnable;

        protected Void doInBackground(Void ... params) {
            return this.process(params);
        }

        public PostTask(TaggedRunnable taggedRunnable) {
            this.mTaggedRunnable = taggedRunnable;
        }

        protected Void process(Void ... params) {
            Coordinator.runWithTiming(this.mTaggedRunnable);
            return null;
        }

        public String toString() {
            return ((Object)((Object)this)).getClass().getSimpleName() + "@" + this.mTaggedRunnable;
        }
    }

    public static abstract class TaggedRunnable
    implements Runnable {
        public final String tag;

        public TaggedRunnable(String tag) {
            this.tag = tag;
        }

        public String toString() {
            return this.getClass().getName() + "@" + this.tag;
        }
    }

    public static class CoordinatorRejectHandler
    implements RejectedExecutionHandler {
        @Override
        public void rejectedExecution(Runnable runnable, ThreadPoolExecutor threadPoolExecutor) {
            Object[] toArray = mPoolWorkQueue.toArray();
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append('[');
            for (Object obj : toArray) {
                if (obj.getClass().isAnonymousClass()) {
                    stringBuilder.append(this.getOuterClass(obj));
                    stringBuilder.append(',').append(' ');
                    continue;
                }
                stringBuilder.append(obj.getClass());
                stringBuilder.append(',').append(' ');
            }
            stringBuilder.append(']');
            throw new RejectedExecutionException("Task " + runnable.toString() + " rejected from " + threadPoolExecutor.toString() + " in " + stringBuilder.toString());
        }

        private Object getOuterClass(Object obj) {
            try {
                Field declaredField = obj.getClass().getDeclaredField("this$0");
                declaredField.setAccessible(true);
                obj = declaredField.get(obj);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e2) {
                e2.printStackTrace();
            }
            catch (IllegalArgumentException e3) {
                e3.printStackTrace();
            }
            return obj;
        }
    }
}

