/*
 * Decompiled with CFR 0.152.
 */
package com.openatlas.android.lifecycle;

import android.app.Activity;
import android.app.ActivityManager;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Process;
import android.text.TextUtils;
import android.util.Log;
import com.openatlas.android.compat.AtlasCompat;
import com.openatlas.android.initializer.AtlasInitializer;
import com.openatlas.android.initializer.BundleParser;
import com.openatlas.boot.Globals;
import com.openatlas.runtime.ContextImplHook;
import com.openatlas.util.Utils;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;

public class AtlasApp
extends AtlasCompat {
    private static final Handler mAppHandler = new Handler();
    private final AtomicInteger mCreationCount;
    private final List<CrossActivityLifecycleCallback> mCrossActivityLifecycleCallbacks = new CopyOnWriteArrayList<CrossActivityLifecycleCallback>();
    private final AtomicInteger mStartCount;
    private WeakReference<Activity> mWeakActivity;
    private Context mBaseContext;
    private String processName;
    AtlasInitializer mAtlasInitializer;

    public AtlasApp() {
        this.mCreationCount = new AtomicInteger();
        this.mStartCount = new AtomicInteger();
    }

    public void registerCrossActivityLifecycleCallback(CrossActivityLifecycleCallback crossActivityLifecycleCallback) {
        if (crossActivityLifecycleCallback == null) {
            new RuntimeException("registerCrossActivityLifecycleCallback must not be null").fillInStackTrace();
            return;
        }
        this.mCrossActivityLifecycleCallbacks.add(crossActivityLifecycleCallback);
        if (this.mCreationCount.get() > 0) {
            mAppHandler.post((Runnable)new CallbackRunable(this, crossActivityLifecycleCallback, "onCreated"));
        }
        if (this.mStartCount.get() > 0) {
            mAppHandler.post((Runnable)new CallbackRunable(this, crossActivityLifecycleCallback, "onStarted"));
        }
    }

    public void unregisterCrossActivityLifecycleCallback(CrossActivityLifecycleCallback crossActivityLifecycleCallback) {
        this.mCrossActivityLifecycleCallbacks.remove(crossActivityLifecycleCallback);
    }

    public static void runOnUiThread(Runnable runnable) {
        mAppHandler.post(runnable);
    }

    protected void attachBaseContext(Context base) {
        super.attachBaseContext(base);
        BundleParser.parser(this.getBaseContext());
        try {
            Field declaredField = Globals.class.getDeclaredField("sInstalledVersionName");
            declaredField.setAccessible(true);
            declaredField.set(null, this.mBaseContext.getPackageManager().getPackageInfo((String)base.getPackageName(), (int)0).versionName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        int myPid = Process.myPid();
        for (ActivityManager.RunningAppProcessInfo runningAppProcessInfo : ((ActivityManager)this.getSystemService("activity")).getRunningAppProcesses()) {
            if (runningAppProcessInfo.pid != myPid) continue;
            this.processName = runningAppProcessInfo.processName;
            break;
        }
        this.mAtlasInitializer = new AtlasInitializer(this, this.getPackageName(), this.getApplicationContext());
        this.mAtlasInitializer.init();
    }

    public void onCreate() {
        super.onCreate();
        this.registerActivityLifecycleCallbacks(new ActivityLifecycleCallbacksCompatImpl(this));
        this.mAtlasInitializer.startUp();
    }

    public boolean bindService(Intent intent, ServiceConnection serviceConnection, int i) {
        return new ContextImplHook(this.getBaseContext(), null).bindService(intent, serviceConnection, i);
    }

    public void startActivity(Intent intent) {
        new ContextImplHook(this.getBaseContext(), this.getClassLoader()).startActivity(intent);
    }

    public ComponentName startService(Intent intent) {
        return new ContextImplHook(this.getBaseContext(), null).startService(intent);
    }

    public SQLiteDatabase openOrCreateDatabase(String str, int i, SQLiteDatabase.CursorFactory cursorFactory) {
        String processName = Utils.getProcessName();
        if (!TextUtils.isEmpty((CharSequence)processName)) {
            String[] split;
            Log.i((String)"SQLiteDatabase", (String)processName);
            if (!processName.equals(this.getPackageName()) && (split = processName.split(":")) != null && split.length > 1) {
                processName = split[1] + "_" + str;
                Log.i((String)"SQLiteDatabase", (String)("openOrCreateDatabase:" + processName));
                return this.hookDatabase(processName, i, cursorFactory);
            }
        }
        return this.hookDatabase(str, i, cursorFactory);
    }

    public SQLiteDatabase hookDatabase(String name, int mode, SQLiteDatabase.CursorFactory cursorFactory) {
        if (Build.VERSION.SDK_INT >= 11) {
            return super.openOrCreateDatabase(name, mode, cursorFactory);
        }
        SQLiteDatabase sQLiteDatabase = null;
        try {
            return super.openOrCreateDatabase(name, mode, cursorFactory);
        }
        catch (SQLiteException e) {
            e.printStackTrace();
            if (Globals.getApplication().deleteDatabase(name)) {
                return super.openOrCreateDatabase(name, mode, cursorFactory);
            }
            return sQLiteDatabase;
        }
    }

    class ActivityLifecycleCallbacksCompatImpl
    implements AtlasCompat.ActivityLifecycleCallbacksCompat {
        final AtlasApp mApplication;

        ActivityLifecycleCallbacksCompatImpl(AtlasApp panguApplication) {
            this.mApplication = panguApplication;
        }

        @Override
        public void onActivityCreated(Activity activity, Bundle bundle) {
            this.mApplication.mWeakActivity = new WeakReference<Activity>(activity);
            if (this.mApplication.mCreationCount.getAndIncrement() == 0 && !this.mApplication.mCrossActivityLifecycleCallbacks.isEmpty()) {
                for (CrossActivityLifecycleCallback onCreated : this.mApplication.mCrossActivityLifecycleCallbacks) {
                    onCreated.onCreated(activity);
                }
            }
        }

        @Override
        public void onActivityStarted(Activity activity) {
            if (this.mApplication.mStartCount.getAndIncrement() == 0 && !this.mApplication.mCrossActivityLifecycleCallbacks.isEmpty()) {
                for (CrossActivityLifecycleCallback onStarted : this.mApplication.mCrossActivityLifecycleCallbacks) {
                    onStarted.onStarted(activity);
                }
            }
        }

        @Override
        public void onActivityStopped(Activity activity) {
            if (this.mApplication.mStartCount.decrementAndGet() == 0 && !this.mApplication.mCrossActivityLifecycleCallbacks.isEmpty()) {
                for (CrossActivityLifecycleCallback onStopped : this.mApplication.mCrossActivityLifecycleCallbacks) {
                    onStopped.onStopped(activity);
                }
            }
        }

        @Override
        public void onActivityDestroyed(Activity activity) {
            if (this.mApplication.mCreationCount.decrementAndGet() == 0 && !this.mApplication.mCrossActivityLifecycleCallbacks.isEmpty()) {
                for (CrossActivityLifecycleCallback onDestroyed : this.mApplication.mCrossActivityLifecycleCallbacks) {
                    onDestroyed.onDestroyed(activity);
                }
            }
        }

        @Override
        public void onActivityResumed(Activity activity) {
        }

        @Override
        public void onActivityPaused(Activity activity) {
        }

        @Override
        public void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
        }
    }

    class CallbackRunable
    implements Runnable {
        final AtlasApp mApplication;
        private CrossActivityLifecycleCallback mCrossActivityLifecycleCallback;
        private String name;

        public CallbackRunable(AtlasApp panguApplication, CrossActivityLifecycleCallback crossActivityLifecycleCallback, String str) {
            this.mApplication = panguApplication;
            this.mCrossActivityLifecycleCallback = crossActivityLifecycleCallback;
            this.name = str;
        }

        @Override
        public void run() {
            Activity activity;
            if (this.mApplication.mWeakActivity != null && (activity = (Activity)this.mApplication.mWeakActivity.get()) != null && this.mCrossActivityLifecycleCallback != null) {
                if ("onCreated".equals(this.name)) {
                    this.mCrossActivityLifecycleCallback.onCreated(activity);
                } else if ("onStarted".equals(this.name)) {
                    this.mCrossActivityLifecycleCallback.onStarted(activity);
                }
            }
            this.mCrossActivityLifecycleCallback = null;
            this.name = null;
        }
    }

    public static interface CrossActivityLifecycleCallback {
        public void onCreated(Activity var1);

        public void onDestroyed(Activity var1);

        public void onStarted(Activity var1);

        public void onStopped(Activity var1);
    }
}

