/*
 * Decompiled with CFR 0.152.
 */
package com.openatlas.android.initializer;

import android.app.Application;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.PackageInfo;
import android.util.Log;
import com.openatlas.framework.AtlasConfig;
import java.io.File;
import java.util.concurrent.ConcurrentHashMap;

public class Utils {
    public static String getFileNameFromEntryName(String entryName) {
        String local = "lib/" + AtlasConfig.PRELOAD_DIR + "/";
        return entryName.substring(entryName.indexOf(local) + local.length());
    }

    public static String getPackageNameFromEntryName(String entryName) {
        String local = "lib/" + AtlasConfig.PRELOAD_DIR + "/lib";
        return entryName.substring(entryName.indexOf(local) + local.length(), entryName.indexOf(".so")).replace("_", ".");
    }

    public static String getPackageNameFromSoName(String soName) {
        return soName.substring(soName.indexOf("lib") + "lib".length(), soName.indexOf(".so")).replace("_", ".");
    }

    public static String getBaseFileName(String fileName) {
        int lastIndexOf = fileName.lastIndexOf(".");
        if (lastIndexOf > 0) {
            return fileName.substring(0, lastIndexOf);
        }
        return fileName;
    }

    public static PackageInfo getPackageInfo(Application application) {
        try {
            return application.getPackageManager().getPackageInfo(application.getPackageName(), 0);
        }
        catch (Throwable e) {
            Log.e((String)"Utils", (String)"Error to get PackageInfo >>>", (Throwable)e);
            return new PackageInfo();
        }
    }

    public static void saveAtlasInfoBySharedPreferences(Application application) {
        ConcurrentHashMap<String, String> concurrentHashMap = new ConcurrentHashMap<String, String>();
        concurrentHashMap.put(Utils.getPackageInfo((Application)application).versionName, "dexopt");
        SharedPreferences sharedPreferences = application.getSharedPreferences("atlas_configs", 0);
        if (sharedPreferences == null) {
            sharedPreferences = application.getSharedPreferences("atlas_configs", 0);
        }
        SharedPreferences.Editor edit = sharedPreferences.edit();
        for (String key : concurrentHashMap.keySet()) {
            edit.putString(key, (String)concurrentHashMap.get(key));
        }
        edit.commit();
    }

    public static void UpdatePackageVersion(Application application) {
        PackageInfo packageInfo = Utils.getPackageInfo(application);
        SharedPreferences.Editor edit = application.getSharedPreferences("atlas_configs", 0).edit();
        edit.putInt("last_version_code", packageInfo.versionCode);
        edit.putString("last_version_name", packageInfo.versionName);
        edit.putString(packageInfo.versionName, "dexopt");
        edit.commit();
    }

    public static void notifyBundleInstalled(Application application) {
        System.setProperty("BUNDLES_INSTALLED", "true");
        application.sendBroadcast(new Intent("com.openAtlas.action.BUNDLES_INSTALLED"));
    }

    public static boolean searchFile(String direcotyPath, String keyword) {
        if (direcotyPath == null || keyword == null) {
            Log.e((String)"Utils", (String)"error in search File, direcoty or keyword is null");
            return false;
        }
        File direcotyFile = new File(direcotyPath);
        if (direcotyFile == null || !direcotyFile.exists()) {
            Log.e((String)"Utils", (String)("error in search File, can not open directory " + direcotyPath));
            return false;
        }
        File[] listFiles = new File(direcotyPath).listFiles();
        if (listFiles == null || listFiles.length <= 0) {
            return false;
        }
        for (File file2 : listFiles) {
            if (file2.getName().indexOf(keyword) < 0) continue;
            Log.d((String)"Util", (String)("the file search success " + file2.getName() + " keyword is " + keyword));
            return true;
        }
        Log.e((String)"Util", (String)("the file search failed directory is " + direcotyPath + " keyword is " + keyword));
        return false;
    }
}

