/*
 * Decompiled with CFR 0.152.
 */
package com.openatlas.android.initializer;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.SharedPreferences;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Handler;
import android.os.Message;
import android.os.Process;
import android.text.TextUtils;
import android.util.Log;
import android.widget.Toast;
import com.openatlas.framework.Atlas;
import com.openatlas.runtime.RuntimeVariables;
import com.openatlas.util.ApkUtils;
import com.openatlas.util.PackageValidate;
import com.openatlas.util.StringUtils;
import java.io.File;
import java.util.List;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;

public class SecurityFrameListener
implements FrameworkListener {
    public static final String PUBLIC_KEY = "";
    ProcessHandler mHandler = new ProcessHandler();

    @Override
    @SuppressLint(value={"NewApi"})
    public void frameworkEvent(FrameworkEvent frameworkEvent) {
        switch (frameworkEvent.getType()) {
            case 1: {
                if (Build.VERSION.SDK_INT >= 11) {
                    new SecurityFrameAsyncTask(this).executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new String[0]);
                    break;
                }
                new SecurityFrameAsyncTask(this).execute(new String[0]);
            }
        }
    }

    private void storeBadSIG(String errPublicKey) {
        SharedPreferences.Editor edit = RuntimeVariables.androidApplication.getSharedPreferences("atlas_configs", 0).edit();
        edit.putString("BadSignature", errPublicKey);
        edit.commit();
    }

    private boolean validBundleCert(String archiveSourcePath) {
        PackageValidate packageValidate = new PackageValidate(archiveSourcePath);
        return packageValidate.collectCertificates();
    }

    public static class ProcessHandler
    extends Handler {
        public void handleMessage(Message message) {
            Process.killProcess((int)Process.myPid());
        }
    }

    private class SecurityFrameAsyncTask
    extends AsyncTask<String, Void, Boolean> {
        final SecurityFrameListener mSecurityFrameListener;

        private SecurityFrameAsyncTask(SecurityFrameListener mSecurityFrameListener) {
            this.mSecurityFrameListener = mSecurityFrameListener;
        }

        protected Boolean doInBackground(String ... args) {
            return this.process(args);
        }

        protected void onPostExecute(Boolean obj) {
            this.postResult(obj);
        }

        protected Boolean process(String ... args) {
            if (TextUtils.isEmpty((CharSequence)SecurityFrameListener.PUBLIC_KEY)) {
                return true;
            }
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            List<Bundle> bundles = Atlas.getInstance().getBundles();
            if (bundles != null) {
                for (Bundle bundle : bundles) {
                    File bundleFile = Atlas.getInstance().getBundleFile(bundle.getLocation());
                    if (!this.mSecurityFrameListener.validBundleCert(bundleFile.getAbsolutePath())) {
                        return false;
                    }
                    String[] apkPublicKey = ApkUtils.getApkPublicKey(bundleFile.getAbsolutePath());
                    if (StringUtils.contains(apkPublicKey, SecurityFrameListener.PUBLIC_KEY)) {
                        try {
                            Thread.sleep(500L);
                        }
                        catch (InterruptedException interruptedException) {}
                        continue;
                    }
                    Log.e((String)"SecurityFrameListener", (String)("Security check failed. " + bundle.getLocation()));
                    if (apkPublicKey == null || apkPublicKey.length == 0) {
                        this.mSecurityFrameListener.storeBadSIG(bundle.getLocation() + ": NULL");
                    } else {
                        this.mSecurityFrameListener.storeBadSIG(bundle.getLocation() + ": " + apkPublicKey[0]);
                    }
                    return false;
                }
            }
            return true;
        }

        protected void postResult(Boolean bool) {
            if (bool != null && !bool.booleanValue()) {
                Toast.makeText((Context)RuntimeVariables.androidApplication, (CharSequence)"Public Key error\uff0cPLZ update your  public key", (int)1).show();
                this.mSecurityFrameListener.mHandler.sendEmptyMessageDelayed(0, 5000L);
            }
        }
    }
}

