/*
 * Decompiled with CFR 0.152.
 */
package com.openatlas.android.initializer;

import android.app.Application;
import android.content.Intent;
import android.util.Log;
import com.openatlas.android.initializer.Utils;
import com.openatlas.framework.Atlas;
import com.openatlas.framework.AtlasConfig;
import com.openatlas.framework.BundleImpl;
import com.openatlas.framework.bundlestorage.BundleArchiveRevision;
import org.osgi.framework.Bundle;

public class OptDexProcess {
    private static OptDexProcess mOptDexProcess;
    private Application mApplication;
    private boolean isInitialized;
    private boolean isExecuted;

    private OptDexProcess() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized OptDexProcess getInstance() {
        if (mOptDexProcess != null) {
            return mOptDexProcess;
        }
        Class<OptDexProcess> clazz = OptDexProcess.class;
        synchronized (OptDexProcess.class) {
            if (mOptDexProcess == null) {
                mOptDexProcess = new OptDexProcess();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return mOptDexProcess;
        }
    }

    void init(Application application) {
        this.mApplication = application;
        this.isInitialized = true;
    }

    public synchronized void processPackages(boolean optAuto, boolean notifyResult) {
        if (!this.isInitialized) {
            Log.e((String)"OptDexProcess", (String)"Bundle Installer not initialized yet, process abort!");
        } else if (!this.isExecuted || notifyResult) {
            if (optAuto) {
                long currentTimeMillis = System.currentTimeMillis();
                this.optAUTODex();
                if (!notifyResult) {
                    this.finishInstalled();
                }
                Log.e((String)"debug", (String)("dexopt auto start bundles cost time = " + (System.currentTimeMillis() - currentTimeMillis) + " ms"));
            } else {
                long currentTimeMillis = System.currentTimeMillis();
                this.optStoreDex();
                Log.e((String)"debug", (String)("dexopt bundles not delayed cost time = " + (System.currentTimeMillis() - currentTimeMillis) + " ms"));
                if (!notifyResult) {
                    this.finishInstalled();
                }
                currentTimeMillis = System.currentTimeMillis();
                OptDexProcess.getInstance().optStoreDex2();
                Log.e((String)"debug", (String)("dexopt delayed bundles cost time = " + (System.currentTimeMillis() - currentTimeMillis) + " ms"));
            }
            if (!notifyResult) {
                this.isExecuted = true;
            }
        }
    }

    private void finishInstalled() {
        Utils.saveAtlasInfoBySharedPreferences(this.mApplication);
        System.setProperty("BUNDLES_INSTALLED", "true");
        this.mApplication.sendBroadcast(new Intent("com.openAtlas.action.BUNDLES_INSTALLED"));
    }

    private void optStoreDex() {
        for (Bundle bundle : Atlas.getInstance().getBundles()) {
            if (bundle == null || this.contains(AtlasConfig.STORE, bundle.getLocation())) continue;
            try {
                ((BundleImpl)bundle).optDexFile();
            }
            catch (Throwable e) {
                if (e instanceof BundleArchiveRevision.DexLoadException) {
                    throw (RuntimeException)e;
                }
                Log.e((String)"OptDexProcess", (String)"Error while dexopt >>>", (Throwable)e);
            }
        }
    }

    private void optStoreDex2() {
        for (String bundle : AtlasConfig.STORE) {
            Bundle bundle2 = Atlas.getInstance().getBundle(bundle);
            if (bundle2 == null) continue;
            try {
                ((BundleImpl)bundle2).optDexFile();
            }
            catch (Throwable e) {
                if (e instanceof BundleArchiveRevision.DexLoadException) {
                    throw (RuntimeException)e;
                }
                Log.e((String)"OptDexProcess", (String)"Error while dexopt >>>", (Throwable)e);
            }
        }
    }

    private void optAUTODex() {
        for (String bundleName : AtlasConfig.AUTO) {
            Bundle bundle = Atlas.getInstance().getBundle(bundleName);
            if (bundle == null) continue;
            try {
                ((BundleImpl)bundle).optDexFile();
            }
            catch (Throwable e) {
                if (e instanceof BundleArchiveRevision.DexLoadException) {
                    throw (RuntimeException)e;
                }
                Log.e((String)"OptDexProcess", (String)"Error while dexopt >>>", (Throwable)e);
            }
        }
    }

    private boolean contains(String[] bundleNames, String location) {
        if (bundleNames == null || location == null) {
            return false;
        }
        for (String bundleName : bundleNames) {
            if (bundleName == null || !bundleName.equals(location)) continue;
            return true;
        }
        return false;
    }
}

