/*
 * Decompiled with CFR 0.152.
 */
package com.openatlas.android.initializer;

import android.app.Application;
import android.content.Context;
import android.os.Environment;
import android.os.Handler;
import android.os.Looper;
import android.os.StatFs;
import android.util.Log;
import android.widget.Toast;
import com.openatlas.android.initializer.Utils;
import com.openatlas.framework.Atlas;
import com.openatlas.framework.AtlasConfig;
import com.openatlas.runtime.RuntimeVariables;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.osgi.framework.Bundle;

public class BundlesInstaller {
    private static boolean autoStart;
    private static BundlesInstaller mBundlesInstaller;
    private Application mApplication;
    private boolean isinitialized;
    private boolean isInstalled;

    BundlesInstaller() {
    }

    void init(Application application, boolean isAppPkg) {
        this.mApplication = application;
        autoStart = isAppPkg;
        this.isinitialized = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static synchronized BundlesInstaller getInstance() {
        if (mBundlesInstaller != null) {
            return mBundlesInstaller;
        }
        Class<BundlesInstaller> clazz = BundlesInstaller.class;
        synchronized (BundlesInstaller.class) {
            if (mBundlesInstaller == null) {
                mBundlesInstaller = new BundlesInstaller();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return mBundlesInstaller;
        }
    }

    public synchronized void process(boolean installAuto, boolean updatePackageVersion) {
        if (!this.isinitialized) {
            Log.e((String)"BundlesInstaller", (String)"Bundle Installer not initialized yet, process abort!");
        } else if (!this.isInstalled || updatePackageVersion) {
            block19: {
                ZipFile zipFile = null;
                try {
                    zipFile = new ZipFile(this.mApplication.getApplicationInfo().sourceDir);
                    List<String> bundleList = this.fetchBundleFileList(zipFile, "lib/" + AtlasConfig.PRELOAD_DIR + "/libcom_", ".so");
                    if (bundleList != null && bundleList.size() > 0 && this.getAvailableSize() < (long)(bundleList.size() * 2 * 4096 * 4096)) {
                        new Handler(Looper.getMainLooper()).post(new Runnable(){

                            @Override
                            public void run() {
                                Toast.makeText((Context)RuntimeVariables.androidApplication, (CharSequence)"Ops \u53ef\u7528\u7a7a\u95f4\u4e0d\u8db3\uff01", (int)1).show();
                            }
                        });
                    }
                    if (installAuto) {
                        ArrayList<String> arrayList = new ArrayList<String>();
                        for (String str : bundleList) {
                            for (String replace : AtlasConfig.AUTO) {
                                if (!str.contains(replace.replace(".", "_"))) continue;
                                arrayList.add(str);
                            }
                        }
                        this.processAutoStartBundles(zipFile, arrayList, this.mApplication);
                    } else {
                        this.installDelayBundles(zipFile, bundleList, this.mApplication);
                    }
                    if (!updatePackageVersion) {
                        Utils.UpdatePackageVersion(this.mApplication);
                    }
                    if (zipFile != null) {
                        try {
                            zipFile.close();
                        }
                        catch (IOException e2) {
                            e2.printStackTrace();
                        }
                    }
                }
                catch (IOException e5) {
                    Log.e((String)"BundlesInstaller", (String)"IOException while processLibsBundles >>>", (Throwable)e5);
                    if (updatePackageVersion) {
                        this.isInstalled = true;
                    }
                }
                catch (Throwable th2) {
                    th2.printStackTrace();
                    if (zipFile == null) break block19;
                    try {
                        zipFile.close();
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                }
            }
            if (updatePackageVersion) {
                this.isInstalled = true;
            }
        }
    }

    private List<String> fetchBundleFileList(ZipFile zipFile, String prefix, String suffix) {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                String name = entries.nextElement().getName();
                if (!name.startsWith(prefix) || !name.endsWith(suffix)) continue;
                arrayList.add(name);
            }
        }
        catch (Throwable e) {
            Log.e((String)"BundlesInstaller", (String)"Exception while get bundles in assets or lib", (Throwable)e);
        }
        return arrayList;
    }

    private long getAvailableSize() {
        StatFs statFs = new StatFs(Environment.getDataDirectory().getPath());
        return (long)statFs.getAvailableBlocks() * (long)statFs.getBlockSize();
    }

    public void processAutoStartBundles(ZipFile zipFile, List<String> list, Application application) {
        for (String a : list) {
            this.installBundle(zipFile, a, application);
        }
        if (autoStart) {
            for (String bundle : AtlasConfig.AUTO) {
                Bundle bundle2 = Atlas.getInstance().getBundle(bundle);
                if (bundle2 == null) continue;
                try {
                    bundle2.start();
                }
                catch (Throwable e) {
                    Log.e((String)"BundlesInstaller", (String)("Could not auto start bundle: " + bundle2.getLocation()), (Throwable)e);
                }
            }
        }
    }

    private void installDelayBundles(ZipFile zipFile, List<String> bundleList, Application application) {
        int i = 0;
        for (String replace : AtlasConfig.DELAY) {
            String replace2 = this.contains(bundleList, replace.replace(".", "_"));
            if (replace2 == null || replace2.length() <= 0) continue;
            this.installBundle(zipFile, replace2, application);
            bundleList.remove(replace2);
        }
        for (String a : bundleList) {
            this.installBundle(zipFile, a, application);
        }
        if (autoStart) {
            String[] strArr = AtlasConfig.DELAY;
            int length = strArr.length;
            while (i < length) {
                Bundle bundle = Atlas.getInstance().getBundle(strArr[i]);
                if (bundle != null) {
                    try {
                        bundle.start();
                    }
                    catch (Throwable e) {
                        Log.e((String)"BundlesInstaller", (String)("Could not auto start bundle: " + bundle.getLocation()), (Throwable)e);
                    }
                }
                ++i;
            }
        }
    }

    private String contains(List<String> list, String pkgName) {
        if (list == null || pkgName == null) {
            return null;
        }
        for (String bundleName : list) {
            if (!bundleName.contains(pkgName)) continue;
            return bundleName;
        }
        return null;
    }

    private boolean installBundle(ZipFile zipFile, String packageName, Application application) {
        System.out.println("processLibsBundle entryName " + packageName);
        String fileNameFromEntryName = Utils.getFileNameFromEntryName(packageName);
        String packageNameFromEntryName = Utils.getPackageNameFromEntryName(packageName);
        if (packageNameFromEntryName == null || packageNameFromEntryName.length() <= 0) {
            return false;
        }
        File file = new File(new File(application.getFilesDir().getParentFile(), "lib"), fileNameFromEntryName);
        if (Atlas.getInstance().getBundle(packageNameFromEntryName) != null) {
            return false;
        }
        try {
            if (file.exists()) {
                Atlas.getInstance().installBundle(packageNameFromEntryName, file);
            } else {
                Atlas.getInstance().installBundle(packageNameFromEntryName, zipFile.getInputStream(zipFile.getEntry(packageName)));
            }
            System.out.println("Succeed to install bundle " + packageNameFromEntryName);
            return true;
        }
        catch (Throwable e) {
            Log.e((String)"BundlesInstaller", (String)"Could not install bundle.", (Throwable)e);
            return false;
        }
    }
}

