/*
 * Decompiled with CFR 0.152.
 */
package com.openatlas.android.initializer;

import android.annotation.SuppressLint;
import android.app.Application;
import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.PackageInfo;
import android.os.Build;
import android.os.Process;
import android.text.TextUtils;
import android.util.Log;
import com.openatlas.android.initializer.BundlesInstaller;
import com.openatlas.android.initializer.ClassNotFoundInterceptor;
import com.openatlas.android.initializer.InstallSolutionConfig;
import com.openatlas.android.initializer.OptDexProcess;
import com.openatlas.android.initializer.SecurityFrameListener;
import com.openatlas.android.initializer.Utils;
import com.openatlas.android.task.Coordinator;
import com.openatlas.boot.Globals;
import com.openatlas.bundleInfo.BundleInfoList;
import com.openatlas.bundleInfo.BundleListing;
import com.openatlas.framework.Atlas;
import com.openatlas.util.ApkUtils;
import java.io.File;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Properties;

public class AtlasInitializer {
    private static long time = 0L;
    private static boolean isAppPkg;
    private Application mApp;
    private String pkgName;
    private boolean tryInstall;
    private boolean isMiniPackage;
    private boolean init = true;

    public AtlasInitializer(Application application, String packageName, Context context) {
        this.mApp = application;
        this.pkgName = packageName;
        if (application.getPackageName().equals(packageName)) {
            isAppPkg = true;
        }
    }

    public void injectApplication() {
        try {
            Atlas.getInstance().injectApplication(this.mApp, this.mApp.getPackageName());
        }
        catch (Exception e) {
            throw new RuntimeException("atlas inject mApplication fail" + e.getMessage());
        }
    }

    public void init() {
        time = System.currentTimeMillis();
        try {
            Atlas.getInstance().init(this.mApp);
            System.out.println("Atlas framework inited end " + this.pkgName + " " + (System.currentTimeMillis() - time) + " ms");
        }
        catch (Throwable e) {
            Log.e((String)"AtlasInitializer", (String)"Could not init atlas framework !!!", (Throwable)e);
            throw new RuntimeException("atlas initialization fail" + e.getMessage());
        }
    }

    public void startUp() {
        this.init = this.isMatchVersion();
        if (this.init) {
            this.killMe();
            this.ensureBaselineInfo();
        }
        Properties properties = new Properties();
        properties.put("com.openAtlas.welcome.Welcome", "com.openAtlas.welcome.Welcome");
        properties.put("com.openAtlas.debug.bundles", "true");
        properties.put("com.openAtlas.AppDirectory", this.mApp.getFilesDir().getParent());
        try {
            Field declaredField = Globals.class.getDeclaredField("sApplication");
            declaredField.setAccessible(true);
            declaredField.set(null, this.mApp);
            declaredField = Globals.class.getDeclaredField("sClassLoader");
            declaredField.setAccessible(true);
            declaredField.set(null, Atlas.getInstance().getDelegateClassLoader());
            if (this.mApp.getPackageName().equals(this.pkgName)) {
                if (this.verifyRumtime() || !ApkUtils.isRootSystem()) {
                    properties.put("om.openAtlas.publickey", "");
                    Atlas.getInstance().addFrameworkListener(new SecurityFrameListener());
                }
                if (this.init) {
                    properties.put("osgi.init", "true");
                }
            }
            BundlesInstaller mBundlesInstaller = BundlesInstaller.getInstance();
            OptDexProcess mOptDexProcess = OptDexProcess.getInstance();
            if (this.mApp.getPackageName().equals(this.pkgName) && this.init) {
                mBundlesInstaller.init(this.mApp, isAppPkg);
                mOptDexProcess.init(this.mApp);
            }
            System.out.println("Atlas framework prepare starting in process " + this.pkgName + " " + (System.currentTimeMillis() - time) + " ms");
            Atlas.getInstance().setClassNotFoundInterceptorCallback(new ClassNotFoundInterceptor());
            try {
                Atlas.getInstance().startup(properties);
                this.installBundles(mBundlesInstaller, mOptDexProcess);
                System.out.println("Atlas framework end startUp in process " + this.pkgName + " " + (System.currentTimeMillis() - time) + " ms");
            }
            catch (Throwable e) {
                Log.e((String)"AtlasInitializer", (String)"Could not start up atlas framework !!!", (Throwable)e);
                throw new RuntimeException(e);
            }
        }
        catch (Throwable e2) {
            e2.printStackTrace();
            throw new RuntimeException("Could not set Globals !!!", e2);
        }
    }

    private void ensureBaselineInfo() {
        File file = new File(this.mApp.getFilesDir() + File.separator + "bundleBaseline" + File.separator + "baselineInfo");
        if (file.exists()) {
            file.delete();
        }
    }

    private void killMe() {
        if (!this.mApp.getPackageName().equals(this.pkgName)) {
            Process.killProcess((int)Process.myPid());
        }
    }

    private void installBundles(final BundlesInstaller mBundlesInstaller, final OptDexProcess mOptDexProcess) {
        if (this.mApp.getPackageName().equals(this.pkgName)) {
            if (!Utils.searchFile(this.mApp.getFilesDir().getParentFile() + "/lib", "libcom_")) {
                InstallSolutionConfig.install_when_oncreate = true;
            }
            if (!this.initBundle()) {
                InstallSolutionConfig.install_when_oncreate = true;
                this.tryInstall = true;
            }
            if (this.init) {
                if (InstallSolutionConfig.install_when_oncreate) {
                    Coordinator.postTask(new Coordinator.TaggedRunnable("AtlasStartup"){

                        @Override
                        public void run() {
                            mBundlesInstaller.process(true, false);
                            mOptDexProcess.processPackages(true, false);
                        }
                    });
                } else {
                    Utils.notifyBundleInstalled(this.mApp);
                    Utils.UpdatePackageVersion(this.mApp);
                    Utils.saveAtlasInfoBySharedPreferences(this.mApp);
                }
            } else if (!this.init) {
                if (this.tryInstall) {
                    Coordinator.postTask(new Coordinator.TaggedRunnable("AtlasStartup"){

                        @Override
                        public void run() {
                            mBundlesInstaller.process(false, false);
                            mOptDexProcess.processPackages(false, false);
                        }
                    });
                } else {
                    Utils.notifyBundleInstalled(this.mApp);
                }
            }
        }
    }

    private boolean initBundle() {
        ArrayList<BundleInfoList.BundleInfo> e = this.genBundleListInfo();
        if (e == null) {
            return false;
        }
        BundleInfoList.getInstance().init(e);
        return true;
    }

    private ArrayList<BundleInfoList.BundleInfo> genBundleListInfo() {
        BundleListing bundleListing = BundleListing.getInstance();
        if (bundleListing == null || bundleListing.getBundles() == null) {
            return null;
        }
        ArrayList<BundleInfoList.BundleInfo> arrayList = new ArrayList<BundleInfoList.BundleInfo>();
        for (BundleListing.Component aVar : bundleListing.getBundles()) {
            if (aVar == null) continue;
            BundleInfoList.BundleInfo bundleInfo = new BundleInfoList.BundleInfo();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            if (aVar.getActivities() != null) {
                arrayList2.addAll(aVar.getActivities());
            }
            if (aVar.getServices() != null) {
                arrayList2.addAll(aVar.getServices());
            }
            if (aVar.getReceivers() != null) {
                arrayList2.addAll(aVar.getReceivers());
            }
            if (aVar.getContentProviders() != null) {
                arrayList2.addAll(aVar.getContentProviders());
            }
            bundleInfo.hasSO = aVar.isHasSO();
            bundleInfo.bundleName = aVar.getPkgName();
            bundleInfo.Components = arrayList2;
            bundleInfo.DependentBundles = aVar.getDependency();
            arrayList.add(bundleInfo);
        }
        return arrayList;
    }

    @SuppressLint(value={"DefaultLocale"})
    private boolean verifyRumtime() {
        return Build.BRAND != null && Build.BRAND.toLowerCase().contains("xiaomi") && Build.HARDWARE != null && Build.HARDWARE.toLowerCase().contains("mt65") || Build.VERSION.SDK_INT < 14;
    }

    private boolean isMatchVersion() {
        try {
            PackageInfo packageInfo = this.mApp.getPackageManager().getPackageInfo(this.mApp.getPackageName(), 0);
            SharedPreferences sharedPreferences = this.mApp.getSharedPreferences("atlas_configs", 0);
            int last_version_code = sharedPreferences.getInt("last_version_code", 0);
            String last_version_name = sharedPreferences.getString("last_version_name", "");
            SharedPreferences sharedPreferences2 = this.mApp.getSharedPreferences("atlas_configs", 0);
            String string2 = sharedPreferences2.getString("isMiniPackage", "");
            this.isMiniPackage = false;
            System.out.println("resetForOverrideInstall = " + this.isMiniPackage);
            if (TextUtils.isEmpty((CharSequence)string2) || this.isMiniPackage) {
                SharedPreferences.Editor edit = sharedPreferences2.edit();
                edit.clear();
                edit.putString("isMiniPackage", "false");
                edit.commit();
            }
            return packageInfo.versionCode > last_version_code || packageInfo.versionCode == last_version_code && !TextUtils.equals((CharSequence)Globals.getInstalledVersionName(), (CharSequence)last_version_name) || this.isMiniPackage;
        }
        catch (Throwable e) {
            Log.e((String)"AtlasInitializer", (String)"Error to get PackageInfo >>>", (Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

