/**
 *  OpenAtlasForAndroid Project
The MIT License (MIT) Copyright (OpenAtlasForAndroid) 2015 Bunny Blue,achellies

Permission is hereby granted, free of charge, to any person obtaining a copy of this software
and associated documentation files (the "Software"), to deal in the Software 
without restriction, including without limitation the rights to use, copy, modify, 
merge, publish, distribute, sublicense, and/or sell copies of the Software, and to 
permit persons to whom the Software is furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all copies 
or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, 
INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE 
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
@author BunnyBlue
 * **/
package com.openatlas.hack;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class Reflect {
	public static boolean sIsReflectAvailable;

	static {
		sIsReflectAvailable = true;
	}


	public static Method getMethod(Class<?> cls,String name, Class<?>... parameterTypes) {
		try {
			Method method = cls.getDeclaredMethod(name, parameterTypes);
			method.setAccessible(true);
			return method;
		} catch (NoSuchMethodException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		;
		return null;

	}

	public static Object invokeMethod(Method method, Object obj,Object... args) {
		try {
			method.setAccessible(true);
			return method.invoke(obj, args);
		} catch (IllegalArgumentException e) {
			e.printStackTrace();
			return null;
		} catch (IllegalAccessException e2) {
			e2.printStackTrace();
			return null;
		} catch (InvocationTargetException e3) {
			e3.printStackTrace();
			return null;
		}
	}

	public static Object fieldGet(Class<?> cls, Object obj, String fieldName) {
		try {
			Field declaredField = cls.getDeclaredField(fieldName);
			declaredField.setAccessible(true);
			return declaredField.get(obj);
		} catch (SecurityException e) {
			e.printStackTrace();
			return null;
		} catch (NoSuchFieldException e2) {
			e2.printStackTrace();
			return null;
		} catch (IllegalArgumentException e3) {
			e3.printStackTrace();
			return null;
		} catch (IllegalAccessException e4) {
			e4.printStackTrace();
			return null;
		}
	}

	public static Object fieldGet(Field field, Object obj) {
		try {
			field.setAccessible(true);
			return field.get(obj);
		} catch (SecurityException e) {
			e.printStackTrace();
			return null;
		} catch (IllegalArgumentException e2) {
			e2.printStackTrace();
			return null;
		} catch (IllegalAccessException e3) {
			e3.printStackTrace();
			return null;
		}
	}


	public static boolean fieldSet(Field field,Object mObject, Object mValue) {
		field.setAccessible(true);
		try {
			field.set(mObject, mValue);
			return true;
		} catch (IllegalAccessException e) {
			
			e.printStackTrace();
		} catch (IllegalArgumentException e) {
		
			e.printStackTrace();
		}
		return false;
	}


	public static boolean fieldSet(Class<?> cls, Object object,String fieldName, Object value) {
		try {
			Field field = cls.getDeclaredField(fieldName);
			field.setAccessible(true);
			field.set(object, value);
			return true;
		} catch (NoSuchFieldException e) {
			e.printStackTrace();
		} catch (IllegalAccessException e) {	
			e.printStackTrace();
		} catch (IllegalArgumentException e) {		
			e.printStackTrace();
		}

		return false;
	}


	public static Field getField(Class<?> cls,String fieldName) {
		try {
			Field field = cls.getDeclaredField(fieldName);
			field.setAccessible(true);
			return field;
		} catch (NoSuchFieldException e) {
		
			e.printStackTrace();
		}
		
		return null;
	}
}
