/*
 * Decompiled with CFR 0.152.
 */
package com.openai.core.handlers;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.openai.core.ObjectMappers;
import com.openai.core.handlers.StringHandler;
import com.openai.core.http.Headers;
import com.openai.core.http.HttpResponse;
import com.openai.errors.BadRequestException;
import com.openai.errors.InternalServerException;
import com.openai.errors.NotFoundException;
import com.openai.errors.OpenAIError;
import com.openai.errors.PermissionDeniedException;
import com.openai.errors.RateLimitException;
import com.openai.errors.UnauthorizedException;
import com.openai.errors.UnexpectedStatusCodeException;
import com.openai.errors.UnprocessableEntityException;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import kotlin.Metadata;
import kotlin.io.ByteStreamsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004H\u0000\u001a,\u0010\u0005\u001a\b\u0012\u0004\u0012\u0002H\u00060\u0001\"\u0004\b\u0000\u0010\u0006*\b\u0012\u0004\u0012\u0002H\u00060\u00012\f\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001H\u0000\u001a\f\u0010\u0007\u001a\u00020\b*\u00020\bH\u0002\u00a8\u0006\t"}, d2={"errorHandler", "Lcom/openai/core/http/HttpResponse$Handler;", "Lcom/openai/errors/OpenAIError;", "jsonMapper", "Lcom/fasterxml/jackson/databind/json/JsonMapper;", "withErrorHandler", "T", "buffered", "Lcom/openai/core/http/HttpResponse;", "openai-java-core"})
@JvmName(name="ErrorHandler")
@SourceDebugExtension(value={"SMAP\nErrorHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ErrorHandler.kt\ncom/openai/core/handlers/ErrorHandler\n+ 2 JsonHandler.kt\ncom/openai/core/handlers/JsonHandler\n*L\n1#1,126:1\n13#2,8:127\n*S KotlinDebug\n*F\n+ 1 ErrorHandler.kt\ncom/openai/core/handlers/ErrorHandler\n*L\n23#1:127,8\n*E\n"})
public final class ErrorHandler {
    public static final /* synthetic */ HttpResponse.Handler errorHandler(JsonMapper jsonMapper) {
        Intrinsics.checkNotNullParameter((Object)jsonMapper, (String)"jsonMapper");
        boolean $i$f$jsonHandler = false;
        HttpResponse.Handler handler = new HttpResponse.Handler<OpenAIError>(jsonMapper){
            final /* synthetic */ JsonMapper $jsonMapper;
            {
                this.$jsonMapper = $jsonMapper;
            }

            public OpenAIError handle(HttpResponse response) {
                Object object;
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                try {
                    boolean $i$f$jacksonTypeRef = false;
                    object = this.$jsonMapper.readValue(response.body(), (TypeReference)new TypeReference<OpenAIError>(){});
                }
                catch (Exception e) {
                    throw ObjectMappers.enhanceJacksonException("Error reading response", e);
                }
                return object;
            }
        };
        return new HttpResponse.Handler<OpenAIError>((HttpResponse.Handler<OpenAIError>)handler){
            final /* synthetic */ HttpResponse.Handler<OpenAIError> $handler;
            {
                this.$handler = $handler;
            }

            public OpenAIError handle(HttpResponse response) {
                OpenAIError openAIError;
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                try {
                    openAIError = this.$handler.handle(response);
                }
                catch (Exception e) {
                    openAIError = OpenAIError.Companion.builder().build();
                }
                return openAIError;
            }
        };
    }

    public static final /* synthetic */ HttpResponse.Handler withErrorHandler(HttpResponse.Handler $this$withErrorHandler, HttpResponse.Handler errorHandler2) {
        Intrinsics.checkNotNullParameter((Object)$this$withErrorHandler, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)errorHandler2, (String)"errorHandler");
        return new HttpResponse.Handler<T>($this$withErrorHandler, errorHandler2){
            final /* synthetic */ HttpResponse.Handler<T> $this_withErrorHandler;
            final /* synthetic */ HttpResponse.Handler<OpenAIError> $errorHandler;
            {
                this.$this_withErrorHandler = $receiver;
                this.$errorHandler = $errorHandler;
            }

            public T handle(HttpResponse response) {
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                int statusCode = response.statusCode();
                boolean bl = 200 <= statusCode ? statusCode < 300 : false;
                if (bl) {
                    return this.$this_withErrorHandler.handle(response);
                }
                if (statusCode == 400) {
                    HttpResponse buffered2 = ErrorHandler.access$buffered(response);
                    throw new BadRequestException(buffered2.headers(), (String)StringHandler.stringHandler().handle(buffered2), this.$errorHandler.handle(buffered2));
                }
                if (statusCode == 401) {
                    HttpResponse buffered3 = ErrorHandler.access$buffered(response);
                    throw new UnauthorizedException(buffered3.headers(), (String)StringHandler.stringHandler().handle(buffered3), this.$errorHandler.handle(buffered3));
                }
                if (statusCode == 403) {
                    HttpResponse buffered4 = ErrorHandler.access$buffered(response);
                    throw new PermissionDeniedException(buffered4.headers(), (String)StringHandler.stringHandler().handle(buffered4), this.$errorHandler.handle(buffered4));
                }
                if (statusCode == 404) {
                    HttpResponse buffered5 = ErrorHandler.access$buffered(response);
                    throw new NotFoundException(buffered5.headers(), (String)StringHandler.stringHandler().handle(buffered5), this.$errorHandler.handle(buffered5));
                }
                if (statusCode == 422) {
                    HttpResponse buffered6 = ErrorHandler.access$buffered(response);
                    throw new UnprocessableEntityException(buffered6.headers(), (String)StringHandler.stringHandler().handle(buffered6), this.$errorHandler.handle(buffered6));
                }
                if (statusCode == 429) {
                    HttpResponse buffered7 = ErrorHandler.access$buffered(response);
                    throw new RateLimitException(buffered7.headers(), (String)StringHandler.stringHandler().handle(buffered7), this.$errorHandler.handle(buffered7));
                }
                boolean bl2 = 500 <= statusCode ? statusCode < 600 : false;
                if (bl2) {
                    HttpResponse buffered8 = ErrorHandler.access$buffered(response);
                    throw new InternalServerException(statusCode, buffered8.headers(), (String)StringHandler.stringHandler().handle(buffered8), this.$errorHandler.handle(buffered8));
                }
                HttpResponse buffered9 = ErrorHandler.access$buffered(response);
                throw new UnexpectedStatusCodeException(statusCode, buffered9.headers(), (String)StringHandler.stringHandler().handle(buffered9), this.$errorHandler.handle(buffered9));
            }
        };
    }

    private static final HttpResponse buffered(HttpResponse $this$buffered) {
        byte[] body = ByteStreamsKt.readBytes((InputStream)$this$buffered.body());
        return new HttpResponse($this$buffered, body){
            final /* synthetic */ HttpResponse $this_buffered;
            final /* synthetic */ byte[] $body;
            {
                this.$this_buffered = $receiver;
                this.$body = $body;
            }

            public int statusCode() {
                return this.$this_buffered.statusCode();
            }

            public Headers headers() {
                return this.$this_buffered.headers();
            }

            public InputStream body() {
                return new ByteArrayInputStream(this.$body);
            }

            public void close() {
                this.$this_buffered.close();
            }
        };
    }

    public static final /* synthetic */ HttpResponse access$buffered(HttpResponse $receiver) {
        return ErrorHandler.buffered($receiver);
    }
}

