/*
 * Decompiled with CFR 0.152.
 */
package com.openai.services.blocking;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.openai.core.ClientOptions;
import com.openai.core.JsonValue;
import com.openai.core.PrepareRequest;
import com.openai.core.RequestOptions;
import com.openai.core.handlers.ErrorHandler;
import com.openai.core.handlers.SseHandler;
import com.openai.core.http.HttpMethod;
import com.openai.core.http.HttpRequest;
import com.openai.core.http.HttpRequestBody;
import com.openai.core.http.HttpResponse;
import com.openai.core.http.SseMessage;
import com.openai.core.http.StreamResponse;
import com.openai.core.http.StreamResponseKt;
import com.openai.errors.OpenAIError;
import com.openai.errors.OpenAIException;
import com.openai.models.Completion;
import com.openai.models.CompletionCreateParams;
import com.openai.services.blocking.CompletionService;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import kotlin.Metadata;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0011\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u001e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\n0\u00112\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\u00110\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/openai/services/blocking/CompletionServiceImpl;", "Lcom/openai/services/blocking/CompletionService;", "clientOptions", "Lcom/openai/core/ClientOptions;", "<init>", "(Lcom/openai/core/ClientOptions;)V", "errorHandler", "Lcom/openai/core/http/HttpResponse$Handler;", "Lcom/openai/errors/OpenAIError;", "createHandler", "Lcom/openai/models/Completion;", "create", "params", "Lcom/openai/models/CompletionCreateParams;", "requestOptions", "Lcom/openai/core/RequestOptions;", "createStreamingHandler", "Lcom/openai/core/http/StreamResponse;", "createStreaming", "openai-java-core"})
@SourceDebugExtension(value={"SMAP\nCompletionServiceImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CompletionServiceImpl.kt\ncom/openai/services/blocking/CompletionServiceImpl\n+ 2 JsonHandler.kt\ncom/openai/core/handlers/JsonHandler\n+ 3 SseHandler.kt\ncom/openai/core/handlers/SseHandler\n+ 4 HttpRequestBodies.kt\ncom/openai/core/HttpRequestBodies\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,90:1\n13#2,9:91\n121#3,14:100\n14#4:114\n14#4:116\n1#5:115\n*S KotlinDebug\n*F\n+ 1 CompletionServiceImpl.kt\ncom/openai/services/blocking/CompletionServiceImpl\n*L\n30#1:91,9\n55#1:100,14\n41#1:114\n67#1:116\n*E\n"})
public final class CompletionServiceImpl
implements CompletionService {
    @NotNull
    private final ClientOptions clientOptions;
    @NotNull
    private final HttpResponse.Handler<OpenAIError> errorHandler;
    @NotNull
    private final HttpResponse.Handler<Completion> createHandler;
    @NotNull
    private final HttpResponse.Handler<StreamResponse<Completion>> createStreamingHandler;

    public CompletionServiceImpl(@NotNull ClientOptions clientOptions) {
        Intrinsics.checkNotNullParameter((Object)clientOptions, (String)"clientOptions");
        this.clientOptions = clientOptions;
        this.errorHandler = ErrorHandler.errorHandler(this.clientOptions.jsonMapper());
        JsonMapper jsonMapper$iv = this.clientOptions.jsonMapper();
        boolean $i$f$jsonHandler = false;
        this.createHandler = ErrorHandler.withErrorHandler(new HttpResponse.Handler<Completion>(jsonMapper$iv){
            final /* synthetic */ JsonMapper $jsonMapper;
            {
                this.$jsonMapper = $jsonMapper;
            }

            public Completion handle(HttpResponse response) {
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                try {
                    boolean $i$f$jacksonTypeRef = false;
                    return this.$jsonMapper.readValue(response.body(), (TypeReference)new TypeReference<Completion>(){});
                }
                catch (Exception e) {
                    throw new OpenAIException("Error reading response", e);
                }
            }
        }, this.errorHandler);
        HttpResponse.Handler $this$mapJson_u24default$iv = SseHandler.sseHandler(this.clientOptions.jsonMapper());
        boolean includeEventAndData$iv = false;
        boolean $i$f$mapJson = false;
        this.createStreamingHandler = ErrorHandler.withErrorHandler(new HttpResponse.Handler<StreamResponse<Completion>>($this$mapJson_u24default$iv, includeEventAndData$iv){
            final /* synthetic */ HttpResponse.Handler $this_mapJson;
            final /* synthetic */ boolean $includeEventAndData;
            {
                this.$this_mapJson = $receiver;
                this.$includeEventAndData = $includeEventAndData;
            }

            public StreamResponse<Completion> handle(HttpResponse response) {
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                return StreamResponseKt.map((StreamResponse)this.$this_mapJson.handle(response), (Function1)new Function1<SseMessage, Completion>(this.$includeEventAndData){
                    final /* synthetic */ boolean $includeEventAndData;
                    {
                        this.$includeEventAndData = $includeEventAndData;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final Completion invoke(SseMessage it) {
                        Object object;
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        try {
                            void this_$iv;
                            object = it;
                            boolean includeEventAndData$iv = this.$includeEventAndData;
                            boolean $i$f$json = false;
                            JsonNode jsonNode$iv = SseMessage.access$getJsonNode((SseMessage)this_$iv);
                            if (includeEventAndData$iv) {
                                ObjectNode newJsonNode$iv = this_$iv.getJsonMapper().createObjectNode();
                                String string = this_$iv.getEvent();
                                if (string != null) {
                                    String it$iv = string;
                                    boolean bl = false;
                                    newJsonNode$iv.put("event", this_$iv.getEvent());
                                }
                                newJsonNode$iv.replace("data", jsonNode$iv);
                                jsonNode$iv = (JsonNode)newJsonNode$iv;
                            }
                            boolean $i$f$jacksonTypeRef = false;
                            object = this_$iv.getJsonMapper().readerFor((TypeReference)new TypeReference<Completion>(){}).readValue(jsonNode$iv);
                        }
                        catch (Exception e) {
                            throw new OpenAIException("Error reading response", e);
                        }
                        return object;
                    }
                });
            }
        }, this.errorHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Completion create(@NotNull CompletionCreateParams params, @NotNull RequestOptions requestOptions) {
        Object it;
        void jsonMapper$iv;
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Intrinsics.checkNotNullParameter((Object)requestOptions, (String)"requestOptions");
        String[] stringArray = new String[]{"completions"};
        HttpRequest.Builder builder = HttpRequest.Companion.builder().method(HttpMethod.POST).addPathSegments(stringArray);
        stringArray = this.clientOptions.jsonMapper();
        CompletionCreateParams.Body value$iv = params._body$openai_java_core();
        boolean $i$f$json22 = false;
        HttpRequest request = PrepareRequest.prepare(builder.body(new HttpRequestBody((JsonMapper)jsonMapper$iv, value$iv){
            private byte[] cachedBytes;
            final /* synthetic */ JsonMapper $jsonMapper;
            final /* synthetic */ T $value;
            {
                this.$jsonMapper = $jsonMapper;
                this.$value = $value;
            }

            private final byte[] serialize() {
                if (this.cachedBytes != null) {
                    Intrinsics.checkNotNull((Object)this.cachedBytes);
                    return this.cachedBytes;
                }
                ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                try {
                    this.$jsonMapper.writeValue((OutputStream)buffer, this.$value);
                    this.cachedBytes = buffer.toByteArray();
                    Intrinsics.checkNotNull((Object)this.cachedBytes);
                    return this.cachedBytes;
                }
                catch (Exception e) {
                    throw new OpenAIException("Error writing request", e);
                }
            }

            public void writeTo(OutputStream outputStream) {
                Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
                outputStream.write(this.serialize());
            }

            public String contentType() {
                return "application/json";
            }

            public long contentLength() {
                return this.serialize().length;
            }

            public boolean repeatable() {
                return true;
            }

            public void close() {
            }
        }).build(), this.clientOptions, params, params.model().toString());
        HttpResponse response = this.clientOptions.httpClient().execute(request, requestOptions);
        Object object = response;
        Throwable $i$f$json22 = null;
        try {
            it = (HttpResponse)object;
            boolean bl = false;
            it = this.createHandler.handle((HttpResponse)it);
        }
        catch (Throwable throwable) {
            $i$f$json22 = throwable;
            throw throwable;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)object, (Throwable)$i$f$json22);
        }
        Object it2 = object = it;
        boolean bl = false;
        Boolean bl2 = requestOptions.getResponseValidation();
        if (bl2 != null ? bl2.booleanValue() : this.clientOptions.responseValidation()) {
            ((Completion)it2).validate();
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public StreamResponse<Completion> createStreaming(@NotNull CompletionCreateParams params, @NotNull RequestOptions requestOptions) {
        HttpResponse response;
        void value$iv;
        void jsonMapper$iv;
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Intrinsics.checkNotNullParameter((Object)requestOptions, (String)"requestOptions");
        String[] stringArray = new String[]{"completions"};
        HttpRequest.Builder builder = HttpRequest.Companion.builder().method(HttpMethod.POST).addPathSegments(stringArray);
        stringArray = this.clientOptions.jsonMapper();
        CompletionCreateParams.Body body = params._body$openai_java_core().toBuilder().putAdditionalProperty("stream", JsonValue.Companion.from(true)).build();
        boolean $i$f$json = false;
        HttpRequest request = PrepareRequest.prepare(builder.body(new /* invalid duplicate definition of identical inner class */).build(), this.clientOptions, params, params.model().toString());
        HttpResponse it = response = this.clientOptions.httpClient().execute(request, requestOptions);
        boolean bl = false;
        StreamResponse streamResponse = this.createStreamingHandler.handle(it);
        boolean bl2 = false;
        Boolean bl3 = requestOptions.getResponseValidation();
        return (bl3 != null ? bl3.booleanValue() : this.clientOptions.responseValidation()) ? StreamResponseKt.map(streamResponse, CompletionServiceImpl::createStreaming$lambda$4$lambda$3) : streamResponse;
    }

    private static final Completion createStreaming$lambda$4$lambda$3(Completion it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.validate();
    }
}

