/*
 * Decompiled with CFR 0.152.
 */
package com.app.toast.snackbar;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.TextView;
import androidx.core.content.ContextCompat;
import com.app.toast.R;
import com.app.toast.expand.ClassExpandKt;
import com.app.toast.snackbar.BaseTransientBottomBar;
import com.app.toast.snackbar.Snackbar;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u000b\u0018\u00002\u00020\u0001B\u0011\b\u0016\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\u0006J\u000e\u0010\b\u001a\u00020\u00002\u0006\u0010\u001f\u001a\u00020\tJ\u0006\u0010 \u001a\u00020!J\u000e\u0010\n\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\u0006J\u000e\u0010\u000b\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\u0006J\u0016\u0010\"\u001a\u00020\u00002\u0006\u0010#\u001a\u00020\u00062\u0006\u0010$\u001a\u00020\u0006J\u000e\u0010\u0012\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u0006J\u0016\u0010%\u001a\u00020\u00002\u0006\u0010#\u001a\u00020\u00062\u0006\u0010$\u001a\u00020\u0006J\u000e\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u0006J\u000e\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u0017J\u0010\u0010&\u001a\u00020!2\u0006\u0010'\u001a\u00020\rH\u0002J\u0018\u0010(\u001a\u00020!2\u0006\u0010'\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\u0003H\u0002J\u0006\u0010)\u001a\u00020!J\u000e\u0010*\u001a\u00020\u00002\u0006\u0010*\u001a\u00020\u0011J\u000e\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u001b\u001a\u00020\u0006J\u000e\u0010\u001c\u001a\u00020\u00002\u0006\u0010+\u001a\u00020\u0006J\u000e\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\u0017J\u000e\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\u0006R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0003X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/app/toast/snackbar/SnackBarX;", "", "viewGroup", "Landroid/view/ViewGroup;", "(Landroid/view/ViewGroup;)V", "animationMode", "", "backgroundColor", "customizeView", "Landroid/view/View;", "duration", "height", "mContext", "Landroid/content/Context;", "marginLeft", "marginRight", "messageValue", "", "offset", "paddingLeft", "paddingRight", "position", "radius", "", "snackBar", "Lcom/app/toast/snackbar/Snackbar;", "snackBarLayout", "textColor", "textGravity", "textSize", "width", "view", "dismiss", "", "margin", "left", "right", "padding", "setCustomizeView", "context", "setToastView", "show", "text", "gravity", "toast_release"})
public final class SnackBarX {
    private Snackbar snackBar;
    private ViewGroup snackBarLayout;
    @Nullable
    private ViewGroup viewGroup;
    @NotNull
    private String messageValue = "";
    @Nullable
    private Context mContext;
    private int position;
    private int height = ClassExpandKt.getDp(40);
    private int width = -2;
    private float textSize = 14.0f;
    private int textColor = R.color.color_FFFFFF;
    private int backgroundColor = R.color.colorSurface;
    private float radius = ClassExpandKt.getDp(20.0f);
    private int animationMode;
    private int paddingLeft = ClassExpandKt.getDp(15);
    private int paddingRight = ClassExpandKt.getDp(15);
    private int marginLeft;
    private int marginRight;
    private int duration = 1500;
    private int offset;
    private int textGravity = 17;
    @Nullable
    private View customizeView;

    public SnackBarX(@Nullable ViewGroup viewGroup) {
        ViewGroup viewGroup2 = viewGroup;
        if (viewGroup2 != null) {
            ViewGroup viewGroup3 = viewGroup2;
            boolean bl = false;
            boolean bl2 = false;
            ViewGroup it = viewGroup3;
            boolean bl3 = false;
            this.viewGroup = it;
            this.mContext = it.getContext();
        }
    }

    @NotNull
    public final SnackBarX position(int position) {
        this.position = position;
        return this;
    }

    @NotNull
    public final SnackBarX height(int height) {
        this.height = height;
        return this;
    }

    @NotNull
    public final SnackBarX textSize(float textSize) {
        this.textSize = textSize;
        return this;
    }

    @NotNull
    public final SnackBarX textColor(int textColor) {
        this.textColor = textColor;
        return this;
    }

    @NotNull
    public final SnackBarX backgroundColor(int backgroundColor) {
        this.backgroundColor = backgroundColor;
        return this;
    }

    @NotNull
    public final SnackBarX radius(float radius) {
        this.radius = radius;
        return this;
    }

    @NotNull
    public final SnackBarX animationMode(int animationMode) {
        this.animationMode = animationMode;
        return this;
    }

    @NotNull
    public final SnackBarX text(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.messageValue = text;
        return this;
    }

    @NotNull
    public final SnackBarX padding(int left, int right) {
        this.paddingLeft = left;
        this.paddingRight = right;
        return this;
    }

    @NotNull
    public final SnackBarX margin(int left, int right) {
        this.marginLeft = left;
        this.marginRight = right;
        return this;
    }

    @NotNull
    public final SnackBarX duration(int duration) {
        this.duration = duration;
        return this;
    }

    @NotNull
    public final SnackBarX offset(int offset) {
        this.offset = offset;
        return this;
    }

    @NotNull
    public final SnackBarX width(int width) {
        this.width = width;
        return this;
    }

    @NotNull
    public final SnackBarX textGravity(int gravity) {
        this.textGravity = gravity;
        return this;
    }

    @NotNull
    public final SnackBarX customizeView(@NotNull View view) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        this.customizeView = view;
        return this;
    }

    public final void dismiss() {
        Snackbar snackbar = this.snackBar;
        if (snackbar == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"snackBar");
            throw null;
        }
        Snackbar snackbar2 = snackbar;
        snackbar2.dismiss();
    }

    public final void show() {
        ViewGroup viewGroup = this.viewGroup;
        if (viewGroup != null) {
            ViewGroup viewGroup2 = viewGroup;
            boolean bl = false;
            boolean bl2 = false;
            ViewGroup it = viewGroup2;
            boolean bl3 = false;
            Object object = Snackbar.make((View)it, "", this.duration);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"make(it, \"\", duration)");
            this.snackBar = object;
            object = this.snackBar;
            if (object == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"snackBar");
                throw null;
            }
            ((BaseTransientBottomBar)object).setPosition(this.position);
            object = this.snackBar;
            if (object == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"snackBar");
                throw null;
            }
            ((BaseTransientBottomBar)object).setOffset(this.offset);
            Snackbar snackbar = this.snackBar;
            if (snackbar == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"snackBar");
                throw null;
            }
            object = snackbar.view;
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"snackBar.view");
            this.snackBarLayout = (ViewGroup)object;
            object = this.snackBarLayout;
            if (object == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"snackBarLayout");
                throw null;
            }
            object.removeAllViews();
            if (this.customizeView != null) {
                object = it.getContext();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"it.context");
                this.setCustomizeView((Context)object);
            } else {
                object = it.getContext();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"it.context");
                Object object2 = object;
                object = this.snackBarLayout;
                if (object == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"snackBarLayout");
                    throw null;
                }
                this.setToastView((Context)object2, (ViewGroup)object);
            }
            object = this.snackBar;
            if (object == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"snackBar");
                throw null;
            }
            ((Snackbar)object).show();
        }
    }

    private final void setToastView(Context context, ViewGroup snackBarLayout) {
        int n;
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(this.width, this.height);
        int n2 = this.position;
        switch (n2) {
            case 1: {
                n = 49;
                break;
            }
            case 0: {
                n = 81;
                break;
            }
            default: {
                n = 81;
            }
        }
        layoutParams.gravity = n;
        layoutParams.setMargins(this.marginLeft, 0, this.marginRight, 0);
        snackBarLayout.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        snackBarLayout.setPadding(this.paddingLeft, 0, this.paddingRight, 0);
        GradientDrawable background = new GradientDrawable();
        background.setShape(0);
        background.setColor(ContextCompat.getColor((Context)context, (int)this.backgroundColor));
        background.setCornerRadius(this.radius);
        snackBarLayout.setBackground((Drawable)background);
        Snackbar snackbar = this.snackBar;
        if (snackbar == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"snackBar");
            throw null;
        }
        snackbar.setAnimationMode(this.animationMode);
        TextView message = new TextView(context);
        message.setText((CharSequence)this.messageValue);
        message.setGravity(this.textGravity);
        message.setTextSize(2, this.textSize);
        message.setTextColor(ContextCompat.getColor((Context)context, (int)this.textColor));
        snackBarLayout.addView((View)message);
    }

    private final void setCustomizeView(Context context) {
        int n;
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-1, -2);
        int n2 = this.position;
        switch (n2) {
            case 1: {
                n = 49;
                break;
            }
            case 0: {
                n = 81;
                break;
            }
            default: {
                n = 81;
            }
        }
        layoutParams.gravity = n;
        layoutParams.setMargins(this.marginLeft, 0, this.marginRight, 0);
        Object object = this.snackBarLayout;
        if (object == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"snackBarLayout");
            throw null;
        }
        object.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        object = this.snackBarLayout;
        if (object == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"snackBarLayout");
            throw null;
        }
        object.setBackgroundColor(ContextCompat.getColor((Context)context, (int)R.color.color_00000000));
        object = this.snackBar;
        if (object == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"snackBar");
            throw null;
        }
        ((BaseTransientBottomBar)object).setAnimationMode(this.animationMode);
        object = this.snackBarLayout;
        if (object == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"snackBarLayout");
            throw null;
        }
        object.addView(this.customizeView);
    }
}

