/*
 * Decompiled with CFR 0.152.
 */
package com.app.toast.snackbar;

import android.annotation.SuppressLint;
import android.graphics.Insets;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.DrawableContainer;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.InsetDrawable;
import android.graphics.drawable.LayerDrawable;
import android.graphics.drawable.ScaleDrawable;
import android.os.Build;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.appcompat.graphics.drawable.DrawableWrapper;
import androidx.core.graphics.drawable.DrawableCompat;
import androidx.core.graphics.drawable.WrappedDrawable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

@SuppressLint(value={"RestrictedAPI"})
public class DrawableUtils {
    private static final int[] CHECKED_STATE_SET = new int[]{0x10100A0};
    private static final int[] EMPTY_STATE_SET = new int[0];
    private static final String TAG = "DrawableUtils";
    public static final Rect INSETS_NONE = new Rect();
    private static Class<?> sInsetsClazz;
    private static final String VECTOR_DRAWABLE_CLAZZ_NAME = "android.graphics.drawable.VectorDrawable";

    private DrawableUtils() {
    }

    public static Rect getOpticalBounds(Drawable drawable2) {
        if (Build.VERSION.SDK_INT >= 29) {
            Insets insets = drawable2.getOpticalInsets();
            Rect result = new Rect();
            result.left = insets.left;
            result.right = insets.right;
            result.top = insets.top;
            result.bottom = insets.bottom;
            return result;
        }
        if (sInsetsClazz != null) {
            try {
                drawable2 = DrawableCompat.unwrap((Drawable)drawable2);
                Method getOpticalInsetsMethod = drawable2.getClass().getMethod("getOpticalInsets", new Class[0]);
                Object insets = getOpticalInsetsMethod.invoke((Object)drawable2, new Object[0]);
                if (insets != null) {
                    Rect result = new Rect();
                    block14: for (Field field : sInsetsClazz.getFields()) {
                        switch (field.getName()) {
                            case "left": {
                                result.left = field.getInt(insets);
                                continue block14;
                            }
                            case "top": {
                                result.top = field.getInt(insets);
                                continue block14;
                            }
                            case "right": {
                                result.right = field.getInt(insets);
                                continue block14;
                            }
                            case "bottom": {
                                result.bottom = field.getInt(insets);
                            }
                        }
                    }
                    return result;
                }
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)"Couldn't obtain the optical insets. Ignoring.");
            }
        }
        return INSETS_NONE;
    }

    static void fixDrawable(@NonNull Drawable drawable2) {
        if (Build.VERSION.SDK_INT == 21 && VECTOR_DRAWABLE_CLAZZ_NAME.equals(drawable2.getClass().getName())) {
            DrawableUtils.fixVectorDrawableTinting(drawable2);
        }
    }

    public static boolean canSafelyMutateDrawable(@NonNull Drawable drawable2) {
        if (Build.VERSION.SDK_INT < 15 && drawable2 instanceof InsetDrawable) {
            return false;
        }
        if (Build.VERSION.SDK_INT < 15 && drawable2 instanceof GradientDrawable) {
            return false;
        }
        if (Build.VERSION.SDK_INT < 17 && drawable2 instanceof LayerDrawable) {
            return false;
        }
        if (drawable2 instanceof DrawableContainer) {
            Drawable.ConstantState state = drawable2.getConstantState();
            if (state instanceof DrawableContainer.DrawableContainerState) {
                DrawableContainer.DrawableContainerState containerState = (DrawableContainer.DrawableContainerState)state;
                for (Drawable child : containerState.getChildren()) {
                    if (DrawableUtils.canSafelyMutateDrawable(child)) continue;
                    return false;
                }
            }
        } else {
            if (drawable2 instanceof WrappedDrawable) {
                return DrawableUtils.canSafelyMutateDrawable(((WrappedDrawable)drawable2).getWrappedDrawable());
            }
            if (drawable2 instanceof DrawableWrapper) {
                return DrawableUtils.canSafelyMutateDrawable(((DrawableWrapper)drawable2).getWrappedDrawable());
            }
            if (drawable2 instanceof ScaleDrawable) {
                return DrawableUtils.canSafelyMutateDrawable(((ScaleDrawable)drawable2).getDrawable());
            }
        }
        return true;
    }

    private static void fixVectorDrawableTinting(Drawable drawable2) {
        int[] originalState = drawable2.getState();
        if (originalState == null || originalState.length == 0) {
            drawable2.setState(CHECKED_STATE_SET);
        } else {
            drawable2.setState(EMPTY_STATE_SET);
        }
        drawable2.setState(originalState);
    }

    public static PorterDuff.Mode parseTintMode(int value, PorterDuff.Mode defaultMode) {
        switch (value) {
            case 3: {
                return PorterDuff.Mode.SRC_OVER;
            }
            case 5: {
                return PorterDuff.Mode.SRC_IN;
            }
            case 9: {
                return PorterDuff.Mode.SRC_ATOP;
            }
            case 14: {
                return PorterDuff.Mode.MULTIPLY;
            }
            case 15: {
                return PorterDuff.Mode.SCREEN;
            }
            case 16: {
                return PorterDuff.Mode.ADD;
            }
        }
        return defaultMode;
    }

    static {
        if (Build.VERSION.SDK_INT >= 18) {
            try {
                sInsetsClazz = Class.forName("android.graphics.Insets");
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
    }
}

