/*
 * Decompiled with CFR 0.152.
 */
package com.app.toast.snackbar;

import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.ColorFilter;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import androidx.annotation.ColorInt;
import androidx.annotation.DrawableRes;
import androidx.annotation.NonNull;
import androidx.appcompat.R;
import androidx.appcompat.content.res.AppCompatResources;
import androidx.appcompat.widget.TintInfo;
import androidx.core.graphics.ColorUtils;
import com.app.toast.snackbar.DrawableUtils;
import com.app.toast.snackbar.ResourceManagerInternal;
import com.app.toast.snackbar.ThemeUtils;
import com.app.toast.snackbar.VectorEnabledTintResources;

public final class AppCompatDrawableManager {
    private static final String TAG = "AppCompatDrawableManag";
    private static final boolean DEBUG = false;
    private static final PorterDuff.Mode DEFAULT_MODE = PorterDuff.Mode.SRC_IN;
    private static AppCompatDrawableManager INSTANCE;
    private ResourceManagerInternal mResourceManager;

    public static synchronized void preload() {
        if (INSTANCE == null) {
            INSTANCE = new AppCompatDrawableManager();
            AppCompatDrawableManager.INSTANCE.mResourceManager = ResourceManagerInternal.get();
            AppCompatDrawableManager.INSTANCE.mResourceManager.setHooks(new ResourceManagerInternal.ResourceManagerHooks(){
                private final int[] COLORFILTER_TINT_COLOR_CONTROL_NORMAL = new int[]{R.drawable.abc_textfield_search_default_mtrl_alpha, R.drawable.abc_textfield_default_mtrl_alpha, R.drawable.abc_ab_share_pack_mtrl_alpha};
                private final int[] TINT_COLOR_CONTROL_NORMAL = new int[]{R.drawable.abc_ic_commit_search_api_mtrl_alpha, R.drawable.abc_seekbar_tick_mark_material, R.drawable.abc_ic_menu_share_mtrl_alpha, R.drawable.abc_ic_menu_copy_mtrl_am_alpha, R.drawable.abc_ic_menu_cut_mtrl_alpha, R.drawable.abc_ic_menu_selectall_mtrl_alpha, R.drawable.abc_ic_menu_paste_mtrl_am_alpha};
                private final int[] COLORFILTER_COLOR_CONTROL_ACTIVATED = new int[]{R.drawable.abc_textfield_activated_mtrl_alpha, R.drawable.abc_textfield_search_activated_mtrl_alpha, R.drawable.abc_cab_background_top_mtrl_alpha, R.drawable.abc_text_cursor_material, R.drawable.abc_text_select_handle_left_mtrl_dark, R.drawable.abc_text_select_handle_middle_mtrl_dark, R.drawable.abc_text_select_handle_right_mtrl_dark, R.drawable.abc_text_select_handle_left_mtrl_light, R.drawable.abc_text_select_handle_middle_mtrl_light, R.drawable.abc_text_select_handle_right_mtrl_light};
                private final int[] COLORFILTER_COLOR_BACKGROUND_MULTIPLY = new int[]{R.drawable.abc_popup_background_mtrl_mult, R.drawable.abc_cab_background_internal_bg, R.drawable.abc_menu_hardkey_panel_mtrl_mult};
                private final int[] TINT_COLOR_CONTROL_STATE_LIST = new int[]{R.drawable.abc_tab_indicator_material, R.drawable.abc_textfield_search_material};
                private final int[] TINT_CHECKABLE_BUTTON_LIST = new int[]{R.drawable.abc_btn_check_material, R.drawable.abc_btn_radio_material, R.drawable.abc_btn_check_material_anim, R.drawable.abc_btn_radio_material_anim};

                private ColorStateList createDefaultButtonColorStateList(@NonNull Context context) {
                    return this.createButtonColorStateList(context, ThemeUtils.getThemeAttrColor(context, R.attr.colorButtonNormal));
                }

                private ColorStateList createBorderlessButtonColorStateList(@NonNull Context context) {
                    return this.createButtonColorStateList(context, 0);
                }

                private ColorStateList createColoredButtonColorStateList(@NonNull Context context) {
                    return this.createButtonColorStateList(context, ThemeUtils.getThemeAttrColor(context, R.attr.colorAccent));
                }

                private ColorStateList createButtonColorStateList(@NonNull Context context, @ColorInt int baseColor) {
                    int[][] states = new int[4][];
                    int[] colors = new int[4];
                    int i = 0;
                    int colorControlHighlight = ThemeUtils.getThemeAttrColor(context, R.attr.colorControlHighlight);
                    int disabledColor = ThemeUtils.getDisabledThemeAttrColor(context, R.attr.colorButtonNormal);
                    states[i] = ThemeUtils.DISABLED_STATE_SET;
                    colors[i] = disabledColor;
                    states[++i] = ThemeUtils.PRESSED_STATE_SET;
                    colors[i] = ColorUtils.compositeColors((int)colorControlHighlight, (int)baseColor);
                    states[++i] = ThemeUtils.FOCUSED_STATE_SET;
                    colors[i] = ColorUtils.compositeColors((int)colorControlHighlight, (int)baseColor);
                    states[++i] = ThemeUtils.EMPTY_STATE_SET;
                    colors[i] = baseColor;
                    ++i;
                    return new ColorStateList((int[][])states, colors);
                }

                private ColorStateList createSwitchThumbColorStateList(Context context) {
                    int[][] states = new int[3][];
                    int[] colors = new int[3];
                    int i = 0;
                    ColorStateList thumbColor = ThemeUtils.getThemeAttrColorStateList(context, R.attr.colorSwitchThumbNormal);
                    if (thumbColor != null && thumbColor.isStateful()) {
                        states[i] = ThemeUtils.DISABLED_STATE_SET;
                        colors[i] = thumbColor.getColorForState(states[i], 0);
                        states[++i] = ThemeUtils.CHECKED_STATE_SET;
                        colors[i] = ThemeUtils.getThemeAttrColor(context, R.attr.colorControlActivated);
                        states[++i] = ThemeUtils.EMPTY_STATE_SET;
                        colors[i] = thumbColor.getDefaultColor();
                        ++i;
                    } else {
                        states[i] = ThemeUtils.DISABLED_STATE_SET;
                        colors[i] = ThemeUtils.getDisabledThemeAttrColor(context, R.attr.colorSwitchThumbNormal);
                        states[++i] = ThemeUtils.CHECKED_STATE_SET;
                        colors[i] = ThemeUtils.getThemeAttrColor(context, R.attr.colorControlActivated);
                        states[++i] = ThemeUtils.EMPTY_STATE_SET;
                        colors[i] = ThemeUtils.getThemeAttrColor(context, R.attr.colorSwitchThumbNormal);
                        ++i;
                    }
                    return new ColorStateList((int[][])states, colors);
                }

                @Override
                public Drawable createDrawableFor(@NonNull ResourceManagerInternal resourceManager, @NonNull Context context, int resId) {
                    if (resId == R.drawable.abc_cab_background_top_material) {
                        return new LayerDrawable(new Drawable[]{resourceManager.getDrawable(context, R.drawable.abc_cab_background_internal_bg), resourceManager.getDrawable(context, R.drawable.abc_cab_background_top_mtrl_alpha)});
                    }
                    return null;
                }

                private void setPorterDuffColorFilter(Drawable d, int color2, PorterDuff.Mode mode) {
                    if (DrawableUtils.canSafelyMutateDrawable(d)) {
                        d = d.mutate();
                    }
                    d.setColorFilter((ColorFilter)AppCompatDrawableManager.getPorterDuffColorFilter(color2, mode == null ? DEFAULT_MODE : mode));
                }

                @Override
                public boolean tintDrawable(@NonNull Context context, int resId, @NonNull Drawable drawable2) {
                    if (resId == R.drawable.abc_seekbar_track_material) {
                        LayerDrawable ld = (LayerDrawable)drawable2;
                        this.setPorterDuffColorFilter(ld.findDrawableByLayerId(0x1020000), ThemeUtils.getThemeAttrColor(context, R.attr.colorControlNormal), DEFAULT_MODE);
                        this.setPorterDuffColorFilter(ld.findDrawableByLayerId(16908303), ThemeUtils.getThemeAttrColor(context, R.attr.colorControlNormal), DEFAULT_MODE);
                        this.setPorterDuffColorFilter(ld.findDrawableByLayerId(16908301), ThemeUtils.getThemeAttrColor(context, R.attr.colorControlActivated), DEFAULT_MODE);
                        return true;
                    }
                    if (resId == R.drawable.abc_ratingbar_material || resId == R.drawable.abc_ratingbar_indicator_material || resId == R.drawable.abc_ratingbar_small_material) {
                        LayerDrawable ld = (LayerDrawable)drawable2;
                        this.setPorterDuffColorFilter(ld.findDrawableByLayerId(0x1020000), ThemeUtils.getDisabledThemeAttrColor(context, R.attr.colorControlNormal), DEFAULT_MODE);
                        this.setPorterDuffColorFilter(ld.findDrawableByLayerId(16908303), ThemeUtils.getThemeAttrColor(context, R.attr.colorControlActivated), DEFAULT_MODE);
                        this.setPorterDuffColorFilter(ld.findDrawableByLayerId(16908301), ThemeUtils.getThemeAttrColor(context, R.attr.colorControlActivated), DEFAULT_MODE);
                        return true;
                    }
                    return false;
                }

                private boolean arrayContains(int[] array, int value) {
                    for (int id2 : array) {
                        if (id2 != value) continue;
                        return true;
                    }
                    return false;
                }

                @Override
                public ColorStateList getTintListForDrawableRes(@NonNull Context context, int resId) {
                    if (resId == R.drawable.abc_edit_text_material) {
                        return AppCompatResources.getColorStateList((Context)context, (int)R.color.abc_tint_edittext);
                    }
                    if (resId == R.drawable.abc_switch_track_mtrl_alpha) {
                        return AppCompatResources.getColorStateList((Context)context, (int)R.color.abc_tint_switch_track);
                    }
                    if (resId == R.drawable.abc_switch_thumb_material) {
                        return this.createSwitchThumbColorStateList(context);
                    }
                    if (resId == R.drawable.abc_btn_default_mtrl_shape) {
                        return this.createDefaultButtonColorStateList(context);
                    }
                    if (resId == R.drawable.abc_btn_borderless_material) {
                        return this.createBorderlessButtonColorStateList(context);
                    }
                    if (resId == R.drawable.abc_btn_colored_material) {
                        return this.createColoredButtonColorStateList(context);
                    }
                    if (resId == R.drawable.abc_spinner_mtrl_am_alpha || resId == R.drawable.abc_spinner_textfield_background_material) {
                        return AppCompatResources.getColorStateList((Context)context, (int)R.color.abc_tint_spinner);
                    }
                    if (this.arrayContains(this.TINT_COLOR_CONTROL_NORMAL, resId)) {
                        return ThemeUtils.getThemeAttrColorStateList(context, R.attr.colorControlNormal);
                    }
                    if (this.arrayContains(this.TINT_COLOR_CONTROL_STATE_LIST, resId)) {
                        return AppCompatResources.getColorStateList((Context)context, (int)R.color.abc_tint_default);
                    }
                    if (this.arrayContains(this.TINT_CHECKABLE_BUTTON_LIST, resId)) {
                        return AppCompatResources.getColorStateList((Context)context, (int)R.color.abc_tint_btn_checkable);
                    }
                    if (resId == R.drawable.abc_seekbar_thumb_material) {
                        return AppCompatResources.getColorStateList((Context)context, (int)R.color.abc_tint_seek_thumb);
                    }
                    return null;
                }

                @Override
                public boolean tintDrawableUsingColorFilter(@NonNull Context context, int resId, @NonNull Drawable drawable2) {
                    PorterDuff.Mode tintMode = DEFAULT_MODE;
                    boolean colorAttrSet = false;
                    int colorAttr = 0;
                    int alpha = -1;
                    if (this.arrayContains(this.COLORFILTER_TINT_COLOR_CONTROL_NORMAL, resId)) {
                        colorAttr = R.attr.colorControlNormal;
                        colorAttrSet = true;
                    } else if (this.arrayContains(this.COLORFILTER_COLOR_CONTROL_ACTIVATED, resId)) {
                        colorAttr = R.attr.colorControlActivated;
                        colorAttrSet = true;
                    } else if (this.arrayContains(this.COLORFILTER_COLOR_BACKGROUND_MULTIPLY, resId)) {
                        colorAttr = 0x1010031;
                        colorAttrSet = true;
                        tintMode = PorterDuff.Mode.MULTIPLY;
                    } else if (resId == R.drawable.abc_list_divider_mtrl_alpha) {
                        colorAttr = 0x1010030;
                        colorAttrSet = true;
                        alpha = Math.round(40.8f);
                    } else if (resId == R.drawable.abc_dialog_material_background) {
                        colorAttr = 0x1010031;
                        colorAttrSet = true;
                    }
                    if (colorAttrSet) {
                        if (DrawableUtils.canSafelyMutateDrawable(drawable2)) {
                            drawable2 = drawable2.mutate();
                        }
                        int color2 = ThemeUtils.getThemeAttrColor(context, colorAttr);
                        drawable2.setColorFilter((ColorFilter)AppCompatDrawableManager.getPorterDuffColorFilter(color2, tintMode));
                        if (alpha != -1) {
                            drawable2.setAlpha(alpha);
                        }
                        return true;
                    }
                    return false;
                }

                @Override
                public PorterDuff.Mode getTintModeForDrawableRes(int resId) {
                    PorterDuff.Mode mode = null;
                    if (resId == R.drawable.abc_switch_thumb_material) {
                        mode = PorterDuff.Mode.MULTIPLY;
                    }
                    return mode;
                }
            });
        }
    }

    public static synchronized AppCompatDrawableManager get() {
        if (INSTANCE == null) {
            AppCompatDrawableManager.preload();
        }
        return INSTANCE;
    }

    public synchronized Drawable getDrawable(@NonNull Context context, @DrawableRes int resId) {
        return this.mResourceManager.getDrawable(context, resId);
    }

    synchronized Drawable getDrawable(@NonNull Context context, @DrawableRes int resId, boolean failIfNotKnown) {
        return this.mResourceManager.getDrawable(context, resId, failIfNotKnown);
    }

    public synchronized void onConfigurationChanged(@NonNull Context context) {
        this.mResourceManager.onConfigurationChanged(context);
    }

    synchronized Drawable onDrawableLoadedFromResources(@NonNull Context context, @NonNull VectorEnabledTintResources resources, @DrawableRes int resId) {
        return this.mResourceManager.onDrawableLoadedFromResources(context, resources, resId);
    }

    boolean tintDrawableUsingColorFilter(@NonNull Context context, @DrawableRes int resId, @NonNull Drawable drawable2) {
        return this.mResourceManager.tintDrawableUsingColorFilter(context, resId, drawable2);
    }

    synchronized ColorStateList getTintList(@NonNull Context context, @DrawableRes int resId) {
        return this.mResourceManager.getTintList(context, resId);
    }

    static void tintDrawable(Drawable drawable2, TintInfo tint, int[] state) {
        ResourceManagerInternal.tintDrawable(drawable2, tint, state);
    }

    public static synchronized PorterDuffColorFilter getPorterDuffColorFilter(int color2, PorterDuff.Mode mode) {
        return ResourceManagerInternal.getPorterDuffColorFilter(color2, mode);
    }
}

