/*
 * Decompiled with CFR 0.152.
 */
package com.oogbox.support.orm.provider;

import android.net.Uri;
import android.text.TextUtils;
import com.oogbox.support.orm.DataResolver;
import com.oogbox.support.orm.provider.BaseResolverCursor;

public class QueryBuilder {
    private DataResolver resolver;
    private String selection;
    private String sortOrder;
    private String groupBy;
    private String having;
    private String[] args;
    private String[] projections;
    private Integer[] ids = new Integer[0];
    private int rowId = -1;
    private int limit = -1;

    public QueryBuilder(DataResolver resolver, String selection, String[] args) {
        this.resolver = resolver;
        this.selection = selection;
        this.args = args;
    }

    public QueryBuilder forId(int _id) {
        this.rowId = _id;
        return this;
    }

    public QueryBuilder forIds(Integer ... ids) {
        this.ids = ids;
        return this;
    }

    public QueryBuilder columns(String ... columns) {
        this.projections = columns;
        return this;
    }

    public QueryBuilder sortOrder(String sortOrder) {
        this.sortOrder = sortOrder;
        return this;
    }

    public QueryBuilder groupBy(String groupBy) {
        this.groupBy = groupBy;
        return this;
    }

    public QueryBuilder having(String having) {
        this.having = having;
        return this;
    }

    public QueryBuilder withLimit(int limit) {
        this.limit = limit;
        return this;
    }

    public BaseResolverCursor execute() {
        Uri.Builder builder = this.resolver.getUri().buildUpon();
        if (this.rowId > 0) {
            builder.appendPath(this.rowId + "");
        }
        if (this.groupBy != null) {
            builder.appendQueryParameter("groupBy", this.groupBy);
        }
        if (this.having != null) {
            builder.appendQueryParameter("having", this.having);
        }
        if (this.limit > 0) {
            builder.appendQueryParameter("dataLimit", this.limit + "");
        }
        if (this.ids.length > 0) {
            this.selection = "_id in (" + TextUtils.join((CharSequence)",", (Object[])this.ids) + ")";
        }
        return new BaseResolverCursor(this.resolver.getContext().getContentResolver().query(builder.build(), this.projections, this.selection, this.args, this.sortOrder), this.resolver.getModel());
    }
}

