/*
 * Decompiled with CFR 0.152.
 */
package com.oogbox.support.orm.core.helper;

import android.content.Context;
import com.oogbox.support.orm.BaseModel;
import com.oogbox.support.orm.core.annotation.DataModel;
import com.oogbox.support.orm.core.factory.BaseModelCursorFactory;
import com.oogbox.support.orm.models.ORecordSequence;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.LinkedHashMap;

public abstract class MobileORMConfig {
    private Context context;
    private LinkedHashMap<String, Class<? extends BaseModel>> modelClasses = new LinkedHashMap();

    public MobileORMConfig(Context context) {
        this.context = context;
        this.register(ORecordSequence.class);
    }

    public Context getContext() {
        return this.context;
    }

    public final HashMap<String, BaseModel> getModels() throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        HashMap<String, BaseModel> models = new HashMap<String, BaseModel>();
        for (String model : this.modelClasses.keySet()) {
            BaseModel modelObj = this.getModel(model);
            if (modelObj == null) continue;
            models.put(model, modelObj);
        }
        return models;
    }

    public final BaseModel getModel(String modelName) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        if (this.modelClasses.containsKey(modelName)) {
            Constructor<? extends BaseModel> constructor = this.modelClasses.get(modelName).getConstructor(Context.class);
            return constructor.newInstance(this.getContext());
        }
        return null;
    }

    @SafeVarargs
    protected final void register(Class<? extends BaseModel> ... models) {
        for (Class<? extends BaseModel> cls : models) {
            DataModel model = cls.getAnnotation(DataModel.class);
            if (model == null) continue;
            this.modelClasses.put(model.value(), cls);
        }
    }

    public String getDatabaseName() {
        return null;
    }

    public int getDatabaseVersion() {
        return -1;
    }

    public BaseModelCursorFactory getCursorFactory() {
        return new BaseModelCursorFactory();
    }

    public abstract String authority();
}

