/*
 * Decompiled with CFR 0.152.
 */
package com.oogbox.support.orm.provider;

import android.content.ContentProvider;
import android.content.ContentValues;
import android.content.Context;
import android.content.UriMatcher;
import android.database.Cursor;
import android.net.Uri;
import android.support.annotation.CallSuper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.oogbox.support.orm.BaseModel;
import com.oogbox.support.orm.core.factory.BaseModelCursor;
import com.oogbox.support.orm.core.helper.MobileORMConfig;
import com.oogbox.support.orm.core.helper.SQLiteHelper;
import com.oogbox.support.orm.utils.MetaReader;
import java.lang.reflect.Constructor;
import java.util.HashMap;

public abstract class ModelContentProvider
extends ContentProvider {
    public static final String KEY_GROUP_BY = "groupBy";
    public static final String KEY_HAVING = "having";
    public static final String KEY_LIMIT = "dataLimit";
    private static final UriMatcher uriMatcher = new UriMatcher(-1);
    private static final HashMap<String, String> modelRegistry = new HashMap();
    public static String DB_AUTHORITY = null;
    private final int MATCH_COLLECTION = 901;
    private final int MATCH_SINGLE_ROW = 902;

    protected void setMatcher(String path, int identifier) {
        if (DB_AUTHORITY == null) {
            DB_AUTHORITY = MetaReader.getDatabaseAuthority(this.getContext());
        }
        uriMatcher.addURI(DB_AUTHORITY, path, identifier);
    }

    protected int match(Uri uri) {
        return uriMatcher.match(uri);
    }

    @CallSuper
    public boolean onCreate() {
        this.bindModelMatcher();
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void bindModelMatcher() {
        MobileORMConfig config = SQLiteHelper.getConfig();
        if (config == null) {
            config = MetaReader.getConfig(this.getContext());
        }
        if (config != null) {
            try {
                HashMap<String, BaseModel> models = config.getModels();
                if (models == null) return;
                for (BaseModel model : models.values()) {
                    this.setMatcher(model.getModelName(), 901);
                    this.setMatcher(model.getModelName() + "/#", 902);
                    modelRegistry.put(model.getModelName(), ((Object)((Object)model)).getClass().getCanonicalName());
                }
                return;
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
        } else {
            Log.e((String)"ModelContentProvider", (String)"No KEY_DATABASE_CONFIG found in your Manifest");
        }
    }

    protected BaseModel createModel(Uri uri) {
        if (uri.getPathSegments().size() > 0) {
            try {
                String modelName = (String)uri.getPathSegments().get(0);
                if (modelRegistry.containsKey(modelName)) {
                    Constructor<?> constructor = Class.forName(modelRegistry.get(modelName)).getConstructor(Context.class);
                    return (BaseModel)((Object)constructor.newInstance(this.getContext()));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    @Nullable
    public Cursor query(@NonNull Uri uri, @Nullable String[] projection, @Nullable String selection, @Nullable String[] selectionArgs, @Nullable String sortOrder) {
        BaseModelCursor cr = null;
        BaseModel model = this.createModel(uri);
        if (model != null) {
            int match = this.match(uri);
            switch (match) {
                case 901: {
                    String groupBy = uri.getQueryParameter(KEY_GROUP_BY);
                    String having = uri.getQueryParameter(KEY_HAVING);
                    String limit = uri.getQueryParameter(KEY_LIMIT);
                    cr = model.select(projection, selection, selectionArgs, groupBy, having, sortOrder, limit);
                    break;
                }
                case 902: {
                    selection = "_id = ? ";
                    cr = model.select(projection, selection, new String[]{uri.getLastPathSegment()}, null, null, null, null);
                }
            }
        }
        if (cr != null && this.getContext() != null) {
            cr.setNotificationUri(this.getContext().getContentResolver(), uri);
        }
        return cr;
    }

    @Nullable
    public String getType(@NonNull Uri uri) {
        return null;
    }

    @Nullable
    public Uri insert(@NonNull Uri uri, @Nullable ContentValues values) {
        Uri resultUri = null;
        BaseModel model = this.createModel(uri);
        if (model != null) {
            int newId = model.create(model.createRecordValues(values));
            resultUri = uri.buildUpon().appendPath(newId + "").build();
            this.notifyDataChange(resultUri);
        }
        return resultUri;
    }

    public int delete(@NonNull Uri uri, @Nullable String selection, @Nullable String[] selectionArgs) {
        BaseModel model = this.createModel(uri);
        int count = 0;
        if (model != null) {
            int match = this.match(uri);
            switch (match) {
                case 902: {
                    selection = "_id = ?";
                    selectionArgs = new String[]{uri.getLastPathSegment()};
                    break;
                }
                case 901: {
                    break;
                }
                default: {
                    return count;
                }
            }
            count = model.delete(selection, selectionArgs);
            if (count > 0) {
                this.notifyDataChange(uri);
            }
        }
        return count;
    }

    public int update(@NonNull Uri uri, @Nullable ContentValues values, @Nullable String selection, @Nullable String[] selectionArgs) {
        int count = 0;
        BaseModel model = this.createModel(uri);
        if (model != null) {
            int match = this.match(uri);
            switch (match) {
                case 901: {
                    break;
                }
                case 902: {
                    selection = "_id = ?";
                    selectionArgs = new String[]{uri.getLastPathSegment()};
                    break;
                }
                default: {
                    return 0;
                }
            }
            count = model.update(model.createRecordValues(values), selection, selectionArgs);
            if (count > 0) {
                this.notifyDataChange(uri);
            }
        }
        return count;
    }

    protected void notifyDataChange(Uri uri) {
        Context ctx = this.getContext();
        assert (ctx != null);
        ctx.getContentResolver().notifyChange(uri, null);
    }
}

