/*
 * Decompiled with CFR 0.152.
 */
package com.oogbox.support.orm.core.data;

import android.database.Cursor;
import com.oogbox.support.orm.BaseModel;
import com.oogbox.support.orm.core.factory.BaseModelCursorUtilsImpl;
import com.oogbox.support.orm.core.helper.M2MTable;
import com.oogbox.support.orm.core.helper.RecordWrapper;
import com.oogbox.support.orm.core.types.OEnum;
import com.oogbox.support.orm.core.types.OManyToMany;
import com.oogbox.support.orm.core.types.OManyToOne;
import com.oogbox.support.orm.core.types.OOneToMany;
import com.oogbox.support.orm.core.types.helper.OFieldType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ORecord
extends RecordWrapper<ORecord> {
    private BaseModel model;

    public ORecord setModel(BaseModel model) {
        this.model = model;
        return this;
    }

    public String getEnumValue(String key) {
        OFieldType type;
        String value = this.getString(key);
        if (value != null && this.model != null && (type = this.model.getColumn(key)) != null) {
            OEnum oEnum = (OEnum)type;
            return oEnum.getEnumVal(value);
        }
        return value;
    }

    public ORecord readMany2One(String key) {
        OManyToOne m2o;
        BaseModel refModel;
        Integer recordId = this.getInt(key);
        if (recordId != null && this.model != null && (refModel = this.model.createModel((m2o = (OManyToOne)this.model.getColumn(key)).getRefModel())) != null) {
            return refModel.browse(recordId);
        }
        return null;
    }

    public List<ORecord> readOne2Many(String key) {
        if (this.model != null) {
            OOneToMany col = (OOneToMany)this.model.getColumn(key);
            Integer recordId = this.getInt("_id");
            if (recordId != null) {
                BaseModel refModel = this.model.createModel(col.getRefModel());
                return refModel.select(col.getRefColumn() + " = ? ", new String[]{recordId + ""});
            }
        }
        return Collections.emptyList();
    }

    public List<ORecord> readMany2Many(String key) {
        if (this.model != null) {
            OManyToMany col = (OManyToMany)this.model.getColumn(key);
            Integer recordId = this.getInt("_id");
            if (recordId != null) {
                M2MTable m2MTable = new M2MTable(this.model.getContext(), this.model, col);
                return m2MTable.readAll(recordId);
            }
        }
        return Collections.emptyList();
    }

    public static ORecord fromCursor(Cursor cr) {
        BaseModelCursorUtilsImpl modelCursor;
        ORecord record = new ORecord();
        ArrayList<String> relatedFields = new ArrayList<String>();
        ArrayList<String> computeFields = new ArrayList<String>();
        for (String column : cr.getColumnNames()) {
            if (cr instanceof BaseModelCursorUtilsImpl) {
                BaseModelCursorUtilsImpl modelCursor2 = (BaseModelCursorUtilsImpl)cr;
                int index = cr.getColumnIndex(column);
                if (modelCursor2.isComputeType(index)) {
                    computeFields.add(column);
                    continue;
                }
                if (modelCursor2.isRelatedType(index)) {
                    relatedFields.add(column);
                    continue;
                }
                record.put(column, ORecord.cursorValue(column, cr));
                continue;
            }
            record.put(column, ORecord.cursorValue(column, cr));
        }
        if (!relatedFields.isEmpty()) {
            modelCursor = (BaseModelCursorUtilsImpl)cr;
            for (String column : relatedFields) {
                record.put(column, modelCursor.getRelatedValue(cr.getColumnIndex(column)));
            }
        }
        if (!computeFields.isEmpty()) {
            modelCursor = (BaseModelCursorUtilsImpl)cr;
            for (String column : computeFields) {
                record.put(column, modelCursor.getComputeValue(record, cr.getColumnIndex(column)));
            }
        }
        return record;
    }

    public static Object cursorValue(String column, Cursor cr) {
        Object value = false;
        int index = cr.getColumnIndex(column);
        switch (cr.getType(index)) {
            case 0: {
                value = null;
                break;
            }
            case 3: {
                value = cr.getString(index);
                break;
            }
            case 1: {
                value = cr.getInt(index);
                break;
            }
            case 2: {
                value = Float.valueOf(cr.getFloat(index));
                break;
            }
            case 4: {
                value = cr.getBlob(index);
            }
        }
        return value;
    }
}

