package com.oogbox.support.orm.core.factory;

import android.database.Cursor;

import com.oogbox.support.orm.BaseModel;
import com.oogbox.support.orm.core.annotation.DataModel;
import com.oogbox.support.orm.core.data.ORecord;
import com.oogbox.support.orm.core.types.OCompute;
import com.oogbox.support.orm.core.types.OManyToOne;
import com.oogbox.support.orm.core.types.helper.OFieldType;

import java.lang.reflect.Method;
import java.util.HashMap;

public final class BaseModelCursorUtils {
    private BaseModel model;
    private Cursor cursor;
    private HashMap<String, OFieldType> fields = new HashMap<>();

    public BaseModelCursorUtils(BaseModel model, Cursor cursor) {
        this.model = model;
        this.cursor = cursor;
        for (OFieldType type : model.getColumns()) {
            fields.put(type.getFieldName(), type);
        }
    }

    public boolean isRelatedType(int columnIndex) {
        OFieldType type = fields.get(cursor.getColumnName(columnIndex));
        return type != null && type.getRelatedRef() != null;
    }

    public boolean isComputeType(int columnIndex) {
        return model.getComputeFields().containsKey(cursor.getColumnName(columnIndex));
    }

    public Object getComputeValue(ORecord fullRecord, int columnIndex) {
        OFieldType field = fields.get(cursor.getColumnName(columnIndex));
        if (field != null) {
            OCompute compute = (OCompute) field;
            try {
                Method method = model.getClass().getMethod(compute.getComputeMethod(), ORecord.class);
                DataModel.Depends depends = method.getAnnotation(DataModel.Depends.class);
                ORecord args = new ORecord();
                args.setModel(model);
                if (depends != null) {
                    for (String depend : depends.value()) {
                        Object value = fullRecord.containsKey(depend) ?
                                fullRecord.get(depend) : ORecord.cursorValue(depend, cursor);
                        args.put(depend, value);
                    }
                }
                return method.invoke(model, args);
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public Object getRelatedValue(int columnIndex) {
        OFieldType type = fields.get(cursor.getColumnName(columnIndex));
        if (type != null) {
            String fieldRef[] = type.getRelatedRef().split("\\.");
            OFieldType mainField = fields.get(fieldRef[0]);
            if (mainField instanceof OManyToOne) {
                ORecord mainRecord = new ORecord();
                mainRecord.setModel(model);
                mainRecord.put(mainField.getFieldName(), cursor.getInt(cursor.getColumnIndex(mainField.getFieldName())));
                mainRecord = mainRecord.readMany2One(mainField.getFieldName());
                if (mainRecord != null) {
                    return fieldRef.length == 2 ? mainRecord.get(fieldRef[1]) : mainRecord.getInt("_id");
                }
            }
        }
        return null;
    }
}
