package com.oogbox.support.orm.core.factory;

import android.database.sqlite.SQLiteCursor;
import android.database.sqlite.SQLiteCursorDriver;
import android.database.sqlite.SQLiteQuery;

import com.oogbox.support.orm.BaseModel;
import com.oogbox.support.orm.core.data.ORecord;

public class BaseModelCursor extends SQLiteCursor implements BaseModelCursorUtilsImpl {

    private BaseModelCursorUtils cursorUtils;

    public BaseModelCursor(BaseModel model, SQLiteCursorDriver driver, String editTable, SQLiteQuery query) {
        super(driver, editTable, query);
        cursorUtils = new BaseModelCursorUtils(model, this);
    }


    @Override
    public boolean isRelatedType(int columnIndex) {
        return cursorUtils.isRelatedType(columnIndex);
    }

    @Override
    public boolean isComputeType(int columnIndex) {
        return cursorUtils.isComputeType(columnIndex);
    }

    @Override
    public Object getComputeValue(ORecord record, int columnIndex) {
        return cursorUtils.getComputeValue(record, columnIndex);
    }

    @Override
    public Object getRelatedValue(int columnIndex) {
        return cursorUtils.getRelatedValue(columnIndex);
    }
}