/*
 * Decompiled with CFR 0.152.
 */
package com.oogbox.support.orm.core.data;

import android.content.ContentValues;
import com.oogbox.support.orm.core.data.RelationValue;
import com.oogbox.support.orm.core.helper.RecordWrapper;
import com.oogbox.support.orm.utils.ObjectByteUtils;
import java.io.IOException;
import java.util.HashMap;

public class ORecordValue
extends RecordWrapper<ORecordValue> {
    private HashMap<String, RelationValue> relationValueMap = new HashMap();
    private HashMap<String, ORecordValue> m2oRecords = new HashMap();

    public ORecordValue add(String key, Object value) {
        this.put(key, value);
        return this;
    }

    public ContentValues toResolverContentValues() {
        ContentValues values = new ContentValues();
        for (String key : this.keySet()) {
            if (this.get(key) instanceof RelationValue || this.get(key) instanceof ORecordValue) {
                try {
                    values.put(key, ObjectByteUtils.objectToByte(this.get(key)));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                continue;
            }
            Object value = this.get(key);
            if (value instanceof Integer) {
                values.put(key, this.getInt(key));
                continue;
            }
            if (value instanceof byte[]) {
                values.put(key, (byte[])this.get(key));
                continue;
            }
            if (value instanceof Float) {
                values.put(key, this.getFloat(key));
                continue;
            }
            if (value instanceof Boolean) {
                values.put(key, this.getBoolean(key));
                continue;
            }
            values.put(key, this.getString(key));
        }
        return values;
    }

    public ContentValues toContentValues() {
        ContentValues values = new ContentValues();
        for (String key : this.keySet()) {
            if (this.get(key) instanceof RelationValue) {
                this.relationValueMap.put(key, (RelationValue)this.get(key));
                continue;
            }
            if (this.get(key) instanceof ORecordValue) {
                this.m2oRecords.put(key, (ORecordValue)this.get(key));
                continue;
            }
            values.put(key, this.getString(key));
        }
        return values;
    }

    public HashMap<String, RelationValue> getRelationValues() {
        return this.relationValueMap;
    }

    public HashMap<String, ORecordValue> getM2ORelRecords() {
        return this.m2oRecords;
    }
}

