/*
 * Decompiled with CFR 0.152.
 */
package com.oogbox.support.orm.utils;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;
import com.oogbox.support.orm.core.helper.MobileORMConfig;
import com.oogbox.support.orm.core.helper.SQLiteHelper;
import java.lang.reflect.Constructor;

public class MetaReader {
    public static Bundle getManifestMeta(Context context) {
        try {
            ApplicationInfo info = context.getPackageManager().getApplicationInfo(context.getPackageName(), 128);
            return info.metaData;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static MobileORMConfig getConfig(Context context) {
        Bundle data = MetaReader.getManifestMeta(context);
        if (data != null && data.containsKey("DATABASE_CONFIG")) {
            try {
                Class<?> config = Class.forName(data.getString("DATABASE_CONFIG"));
                Constructor<?> constructor = config.getConstructor(Context.class);
                return (MobileORMConfig)constructor.newInstance(context);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static String getDatabaseAuthority(Context context) {
        MobileORMConfig config = SQLiteHelper.getConfig();
        if (config != null && config.authority() != null) {
            return config.authority();
        }
        Bundle data = MetaReader.getManifestMeta(context);
        String defaultPath = context.getPackageName() + ".provider";
        if (data != null) {
            return data.getString("DATABASE_AUTHORITY", defaultPath);
        }
        return defaultPath;
    }

    public static String getDatabaseName(Context context) {
        Bundle data = MetaReader.getManifestMeta(context);
        String defaultName = context.getPackageName().replaceAll("\\.", "_") + ".db";
        if (data != null && data.containsKey("DATABASE_NAME")) {
            return data.getString("DATABASE_NAME", defaultName);
        }
        MobileORMConfig config = SQLiteHelper.getConfig();
        if (config != null) {
            try {
                String dbName = config.getDatabaseName();
                if (dbName != null) {
                    return dbName;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return defaultName;
    }

    public static Integer getDatabaseVersion(Context context) {
        Bundle data = MetaReader.getManifestMeta(context);
        if (data != null) {
            return data.getInt("DATABASE_VERSION", 1);
        }
        return 1;
    }

    public static boolean isDatabaseDebug(Context context) {
        Bundle data = MetaReader.getManifestMeta(context);
        if (data != null) {
            return data.getBoolean("DATABASE_DEBUG", false);
        }
        return false;
    }
}

