/*
 * Decompiled with CFR 0.152.
 */
package com.onyx.android.sdk.data.utils;

import android.text.TextUtils;
import com.onyx.android.sdk.data.model.Book;
import com.onyx.android.sdk.data.model.OnyxStatisticsModel;
import com.onyx.android.sdk.data.model.OnyxStatisticsModel_Table;
import com.raizlabs.android.dbflow.config.FlowManager;
import com.raizlabs.android.dbflow.sql.language.OperatorGroup;
import com.raizlabs.android.dbflow.sql.language.SQLOperator;
import com.raizlabs.android.dbflow.sql.language.Select;
import com.raizlabs.android.dbflow.sql.language.Where;
import com.raizlabs.android.dbflow.sql.language.property.IProperty;
import com.raizlabs.android.dbflow.structure.database.DatabaseWrapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class StatisticsUtils {
    private static final int a = 24;
    private static final long b = 60000L;

    public static void saveStatisticsList(Collection<OnyxStatisticsModel> list) {
        DatabaseWrapper databaseWrapper = FlowManager.getDatabase((String)"OnyxStatisticsModel").getWritableDatabase();
        databaseWrapper.beginTransaction();
        Iterator<OnyxStatisticsModel> iterator = list.iterator();
        while (iterator.hasNext()) {
            iterator.next().save();
        }
        DatabaseWrapper databaseWrapper2 = databaseWrapper;
        databaseWrapper2.setTransactionSuccessful();
        databaseWrapper2.endTransaction();
    }

    /*
     * WARNING - void declaration
     */
    public static Collection<OnyxStatisticsModel> loadStatisticsListByStatus(String accountId, int maxPushCount, int status) {
        void var1_1;
        void var2_3;
        Where where = new Select(new IProperty[0]).from(OnyxStatisticsModel.class).where(new SQLOperator[]{OnyxStatisticsModel_Table.status.eq((Object)((int)var2_3))}).limit((int)var1_1);
        if (!TextUtils.isEmpty((CharSequence)accountId)) {
            String string2;
            where.and((SQLOperator)OnyxStatisticsModel_Table.accountId.eq((Object)string2));
        }
        return where.queryList();
    }

    /*
     * WARNING - void declaration
     */
    public static Collection<OnyxStatisticsModel> loadStatisticsList(String md5, int type, Date fromTime) {
        void var2_2;
        String string2;
        void var1_1;
        return new Select(new IProperty[0]).from(OnyxStatisticsModel.class).where(new SQLOperator[]{OnyxStatisticsModel_Table.type.eq((Object)((int)var1_1))}).and((SQLOperator)OnyxStatisticsModel_Table.md5.eq((Object)string2)).and((SQLOperator)OnyxStatisticsModel_Table.eventTime.greaterThan((Object)var2_2)).queryList();
    }

    /*
     * WARNING - void declaration
     */
    public static Collection<OnyxStatisticsModel> loadStatisticsList(int type, String accountID) {
        int n2;
        Where where = new Select(new IProperty[0]).from(OnyxStatisticsModel.class).where(new SQLOperator[]{OnyxStatisticsModel_Table.type.eq((Object)n2)});
        if (!TextUtils.isEmpty((CharSequence)accountID)) {
            void var1_2;
            where.and((SQLOperator)OnyxStatisticsModel_Table.accountId.eq((Object)var1_2));
        }
        return where.queryList();
    }

    public static Collection<OnyxStatisticsModel> loadStatisticsListByMd5(String md5) {
        String string2;
        return new Select(new IProperty[0]).from(OnyxStatisticsModel.class).where(new SQLOperator[]{OnyxStatisticsModel_Table.md5.eq((Object)string2)}).queryList();
    }

    /*
     * WARNING - void declaration
     */
    public static Collection<OnyxStatisticsModel> loadVisibleStatisticsListOrderByTime(int type, boolean ascending, String accountID) {
        void var1_2;
        int n2;
        Where where = new Select(new IProperty[0]).from(OnyxStatisticsModel.class).where(new SQLOperator[]{OnyxStatisticsModel_Table.type.eq((Object)n2)});
        OperatorGroup operatorGroup = OperatorGroup.clause();
        operatorGroup.and((SQLOperator)OnyxStatisticsModel_Table.hideRecord.eq((Object)false)).or((SQLOperator)OnyxStatisticsModel_Table.hideRecord.isNull());
        where.and((SQLOperator)operatorGroup);
        if (!TextUtils.isEmpty((CharSequence)accountID)) {
            void var2_3;
            where.and((SQLOperator)OnyxStatisticsModel_Table.accountId.eq((Object)var2_3));
        }
        Where where2 = where;
        where2.orderBy(OnyxStatisticsModel_Table.eventTime, (boolean)var1_2);
        return where2.queryList();
    }

    /*
     * WARNING - void declaration
     */
    public static Collection<OnyxStatisticsModel> loadStatisticsListOrderByTime(String md5, boolean ascending) {
        void var1_1;
        String string2;
        return new Select(new IProperty[0]).from(OnyxStatisticsModel.class).where(new SQLOperator[]{OnyxStatisticsModel_Table.md5.eq((Object)string2)}).orderBy(OnyxStatisticsModel_Table.eventTime, (boolean)var1_1).queryList();
    }

    /*
     * WARNING - void declaration
     */
    public static Collection<OnyxStatisticsModel> loadStatisticsListOrderByTime(String md5, int type, boolean ascending) {
        void var2_2;
        String string2;
        void var1_1;
        return new Select(new IProperty[0]).from(OnyxStatisticsModel.class).where(new SQLOperator[]{OnyxStatisticsModel_Table.type.eq((Object)((int)var1_1))}).and((SQLOperator)OnyxStatisticsModel_Table.md5.eq((Object)string2)).orderBy(OnyxStatisticsModel_Table.eventTime, (boolean)var2_2).queryList();
    }

    /*
     * WARNING - void declaration
     */
    public static List<Book> converToBooks(List<OnyxStatisticsModel> statisticsModels, int count) {
        ArrayList<String> arrayList;
        ArrayList<Book> arrayList2;
        ArrayList<Book> arrayList3 = arrayList2;
        arrayList2 = new ArrayList<Book>();
        ArrayList<String> arrayList4 = arrayList;
        arrayList = new ArrayList<String>();
        for (OnyxStatisticsModel onyxStatisticsModel : statisticsModels) {
            Book book;
            void var1_1;
            if (arrayList3.size() >= var1_1) break;
            String string2 = onyxStatisticsModel.getMd5();
            if (arrayList4.contains(string2)) continue;
            arrayList4.add(string2);
            Book book2 = book;
            book2();
            book2.setMd5(string2);
            book2.setId(onyxStatisticsModel.getId());
            book2.setHideRecord(onyxStatisticsModel.isHideRecord());
            book2.setName(onyxStatisticsModel.getName());
            book2.setEnd(onyxStatisticsModel.getEventTime());
            book.setPath(onyxStatisticsModel.getPath());
            arrayList3.add(book);
        }
        arrayList4.clear();
        return arrayList3;
    }

    public static long getAnnotationCount(String accountID) {
        String string2;
        return StatisticsUtils.filterAnnotation((List)StatisticsUtils.loadStatisticsList(2, string2));
    }

    public static long filterAnnotation(List<OnyxStatisticsModel> onyxStatisticsModels) {
        LinkedHashMap<String, Long> linkedHashMap;
        List<OnyxStatisticsModel> list;
        for (int i2 = 0; i2 < list.size(); ++i2) {
            if (!list.get(i2).getAction().equals("delete")) continue;
            list.remove(i2);
        }
        LinkedHashMap<String, Long> linkedHashMap2 = linkedHashMap;
        linkedHashMap = new LinkedHashMap<String, Long>();
        for (int i3 = 0; i3 < list.size(); ++i3) {
            String string2 = list.get(i3).getOrgText();
            long l2 = 1L;
            if (linkedHashMap2.containsKey(string2)) {
                l2 = (Long)linkedHashMap2.get(string2) + 1L;
            }
            linkedHashMap2.put(string2, l2);
        }
        return linkedHashMap2.size();
    }

    public static List<Integer> getReadDistribute(Collection<OnyxStatisticsModel> statisticsModels) {
        ArrayList<Integer> arrayList;
        Iterator<OnyxStatisticsModel> iterator;
        TreeMap<Integer, Long> treeMap;
        TreeMap<Integer, Integer> treeMap2;
        TreeMap<Integer, Integer> treeMap3 = treeMap2;
        treeMap2 = new TreeMap<Integer, Integer>();
        TreeMap<Integer, Long> treeMap4 = treeMap;
        treeMap = new TreeMap<Integer, Long>();
        for (int i2 = 0; i2 < 24; ++i2) {
            treeMap4.put(i2, 0L);
        }
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            OnyxStatisticsModel onyxStatisticsModel = (OnyxStatisticsModel)iterator.next();
            Date date = onyxStatisticsModel.getEventTime();
            StatisticsUtils.a(treeMap3, date);
            StatisticsUtils.a(treeMap4, date, onyxStatisticsModel.getDurationTime());
        }
        int n2 = treeMap3.size();
        ArrayList<Integer> arrayList2 = arrayList;
        arrayList = new ArrayList<Integer>();
        Iterator iterator2 = treeMap4.entrySet().iterator();
        while (iterator2.hasNext()) {
            arrayList2.add((int)((Long)iterator2.next().getValue() / (long)n2 / 60000L));
        }
        treeMap3.clear();
        treeMap4.clear();
        return arrayList2;
    }

    /*
     * WARNING - void declaration
     */
    private static void a(Map<Integer, Integer> totalDayMap, Date eventTime) {
        Map<Integer, Integer> map;
        void var1_1;
        int n2 = var1_1.getDay();
        Integer n3 = totalDayMap.get(n2);
        n3 = n3 == null ? Integer.valueOf(1) : Integer.valueOf(n3 + 1);
        map.put(n2, n3);
    }

    /*
     * WARNING - void declaration
     */
    private static void a(Map<Integer, Long> hoursDurationMap, Date eventTime, Long durationTime) {
        void var2_3;
        Long l2;
        int n2 = eventTime.getHours();
        if (n2 <= -1) {
            return;
        }
        Map<Integer, Long> map = l2;
        l2 = l2.get(n2);
        map.put(n2, l2 + var2_3.longValue());
    }
}

