/*
 * Decompiled with CFR 0.152.
 */
package com.onyx.android.sdk.data.utils;

import android.support.annotation.Nullable;
import com.onyx.android.sdk.data.common.ContentException;
import com.onyx.android.sdk.data.utils.ResultCode;
import com.onyx.android.sdk.utils.Debug;
import java.net.SocketTimeoutException;
import retrofit2.Call;
import retrofit2.Response;

public class RetrofitUtils {
    public static <T> Response<T> executeCall(Call<T> call) throws Exception {
        Response response;
        try {
            response = call.execute();
        }
        catch (Exception exception) {
            response = exception;
            if (exception instanceof SocketTimeoutException) {
                throw ContentException.timeoutException();
            }
            throw new ContentException.NetworkException((Exception)response);
        }
        if (response.isSuccessful()) {
            return response;
        }
        throw new ContentException.CloudException(ResultCode.parseResponse(response));
    }

    @Nullable
    public static <T> Response<T> executeCallWithoutException(Call<T> call) {
        Call<T> call2 = null;
        try {
            call2 = RetrofitUtils.executeCall(call);
        }
        catch (Exception exception) {
            Debug.w((Throwable)exception);
        }
        return call2;
    }

    public static boolean isSuccessful(Response response) {
        Response response2;
        return response != null && response2.isSuccessful();
    }
}

