/*
 * Decompiled with CFR 0.152.
 */
package com.onyx.android.sdk.data.model;

import android.content.Context;
import android.content.SharedPreferences;
import android.util.Base64;
import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class SecurePreferences {
    private static final String TRANSFORMATION = "AES/CBC/PKCS5Padding";
    private static final String KEY_TRANSFORMATION = "AES/ECB/PKCS5Padding";
    private static final String SECRET_KEY_HASH_TRANSFORMATION = "SHA-256";
    private static final String CHARSET = "UTF-8";
    private final boolean encryptKeys;
    private final Cipher writer;
    private final Cipher reader;
    private final Cipher keyWriter;
    private final SharedPreferences preferences;

    /*
     * WARNING - void declaration
     */
    public SecurePreferences(Context context, String preferenceName, String secureKey, boolean encryptKeys) throws SecurePreferencesException {
        try {
            void var4_6;
            void var2_4;
            void var1_3;
            void var3_5;
            this.writer = Cipher.getInstance(TRANSFORMATION);
            this.reader = Cipher.getInstance(TRANSFORMATION);
            this.keyWriter = Cipher.getInstance(KEY_TRANSFORMATION);
            this.initCiphers((String)var3_5);
            this.preferences = var1_3.getSharedPreferences((String)var2_4, 0);
            this.encryptKeys = var4_6;
            return;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new SecurePreferencesException(unsupportedEncodingException);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new SecurePreferencesException(generalSecurityException);
        }
    }

    /*
     * WARNING - void declaration
     */
    private String toKey(String key) {
        void var1_1;
        if (this.encryptKeys) {
            return this.encrypt((String)var1_1, this.keyWriter);
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private void putValue(String key, String value) throws SecurePreferencesException {
        void var1_1;
        void var2_2;
        SecurePreferences securePreferences = this_;
        String this_ = securePreferences.encrypt((String)var2_2, ((SecurePreferences)((Object)this_)).writer);
        securePreferences.preferences.edit().putString((String)var1_1, this_).commit();
    }

    /*
     * WARNING - void declaration
     */
    private static byte[] convert(Cipher cipher, byte[] bs) throws SecurePreferencesException {
        try {
            void var1_2;
            return cipher.doFinal((byte[])var1_2);
        }
        catch (Exception exception) {
            throw new SecurePreferencesException(exception);
        }
    }

    protected void initCiphers(String secureKey) throws UnsupportedEncodingException, NoSuchAlgorithmException, InvalidKeyException, InvalidAlgorithmParameterException {
        SecretKeySpec secretKeySpec;
        SecurePreferences securePreferences = this_;
        IvParameterSpec this_ = ((SecurePreferences)((Object)this_)).getIv();
        secretKeySpec = securePreferences.getSecretKey((String)((Object)secretKeySpec));
        securePreferences.writer.init(1, (Key)secretKeySpec, this_);
        securePreferences.reader.init(2, (Key)secretKeySpec, this_);
        securePreferences.keyWriter.init(1, secretKeySpec);
    }

    protected IvParameterSpec getIv() {
        byte[] byArray = new byte[this.writer.getBlockSize()];
        int n2 = this.writer.getBlockSize();
        System.arraycopy("fldsjfodasjifudslfjdsaofshaufihadsf".getBytes(), 0, byArray, 0, n2);
        return new IvParameterSpec(byArray);
    }

    /*
     * WARNING - void declaration
     */
    protected SecretKeySpec getSecretKey(String key) throws UnsupportedEncodingException, NoSuchAlgorithmException {
        void var1_1;
        Object this_ = ((SecurePreferences)this_).createKeyBytes((String)var1_1);
        return new SecretKeySpec((byte[])this_, TRANSFORMATION);
    }

    /*
     * WARNING - void declaration
     */
    protected byte[] createKeyBytes(String key) throws UnsupportedEncodingException, NoSuchAlgorithmException {
        void var1_1;
        MessageDigest messageDigest = MessageDigest.getInstance(SECRET_KEY_HASH_TRANSFORMATION);
        messageDigest.reset();
        return messageDigest.digest(var1_1.getBytes(CHARSET));
    }

    /*
     * WARNING - void declaration
     */
    public void put(String key, String value) {
        void var1_1;
        if (value == null) {
            this.preferences.edit().remove(this.toKey((String)var1_1)).commit();
        } else {
            void var2_2;
            SecurePreferences securePreferences = this;
            securePreferences.putValue(securePreferences.toKey((String)var1_1), (String)var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public boolean containsKey(String key) {
        void var1_1;
        return this.preferences.contains(this.toKey((String)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public void removeValue(String key) {
        void var1_1;
        this.preferences.edit().remove(this.toKey((String)var1_1)).commit();
    }

    /*
     * WARNING - void declaration
     */
    public String getString(String key) throws SecurePreferencesException {
        void var1_1;
        if (this.preferences.contains(this.toKey((String)var1_1))) {
            SecurePreferences securePreferences = this;
            return securePreferences.decrypt(securePreferences.preferences.getString(this.toKey((String)var1_1), ""));
        }
        return null;
    }

    public void clear() {
        this.preferences.edit().clear().commit();
    }

    /*
     * WARNING - void declaration
     */
    protected String encrypt(String value, Cipher writer) throws SecurePreferencesException {
        try {
            void var1_2;
            return Base64.encodeToString((byte[])SecurePreferences.convert(writer, var1_2.getBytes(CHARSET)), (int)2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new SecurePreferencesException(unsupportedEncodingException);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected String decrypt(String securedEncodedValue) {
        void var1_2;
        SecurePreferences securePreferences = this_;
        Object this_ = Base64.decode((String)var1_2, (int)2);
        this_ = SecurePreferences.convert(securePreferences.reader, (byte[])this_);
        try {
            return new String((byte[])this_, CHARSET);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new SecurePreferencesException(unsupportedEncodingException);
        }
    }

    public static class SecurePreferencesException
    extends RuntimeException {
        /*
         * WARNING - void declaration
         */
        public SecurePreferencesException(Throwable e2) {
            super((Throwable)var1_1);
            void var1_1;
        }
    }
}

