/*
 * Decompiled with CFR 0.152.
 */
package com.onyx.android.sdk.data.model;

import com.onyx.android.sdk.data.model.HomeworkSubmitAnswer;
import com.onyx.android.sdk.data.model.QuestionOption;
import com.onyx.android.sdk.data.model.QuestionType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class Question
implements Serializable {
    public String _id;
    public String content;
    public String answers;
    public int QuesType;
    public int difficulty;
    public List<QuestionOption> options;
    public boolean doneAnswer;

    public QuestionType getType() {
        int n2 = this.QuesType - 1;
        if (n2 >= QuestionType.values().length) {
            return QuestionType.SINGLE;
        }
        return QuestionType.values()[n2];
    }

    public boolean isChoiceQuestion() {
        return this.getType() == QuestionType.SINGLE || this.getType() == QuestionType.MULTIPLE || this.getType() == QuestionType.JUDGMENT;
    }

    public boolean isSingleChoiceQuestion() {
        return this.getType() == QuestionType.SINGLE || this.getType() == QuestionType.JUDGMENT;
    }

    public boolean isMultipleChoiceQuestion() {
        return this.getType() == QuestionType.MULTIPLE;
    }

    /*
     * WARNING - void declaration
     */
    public void setDoneAnswer(boolean doneAnswer) {
        void var1_1;
        this.doneAnswer = var1_1;
    }

    public List<HomeworkSubmitAnswer> createAnswer() {
        if (this.isSingleChoiceQuestion()) {
            return this.createSingleAnswer();
        }
        if (this.isMultipleChoiceQuestion()) {
            return this.createMultipleAnswers();
        }
        return this.createFillAnswer();
    }

    public List<HomeworkSubmitAnswer> createSingleAnswer() {
        ArrayList<HomeworkSubmitAnswer> arrayList;
        ArrayList<HomeworkSubmitAnswer> arrayList2 = arrayList;
        arrayList = new ArrayList<HomeworkSubmitAnswer>();
        for (QuestionOption questionOption : this.options) {
            HomeworkSubmitAnswer homeworkSubmitAnswer;
            if (!questionOption.checked) continue;
            HomeworkSubmitAnswer homeworkSubmitAnswer2 = homeworkSubmitAnswer;
            homeworkSubmitAnswer2();
            homeworkSubmitAnswer2.setQuestion(this._id);
            homeworkSubmitAnswer.setValue(questionOption._id);
            arrayList2.add(homeworkSubmitAnswer);
        }
        return arrayList2;
    }

    public List<HomeworkSubmitAnswer> createMultipleAnswers() {
        ArrayList<HomeworkSubmitAnswer> arrayList;
        ArrayList<HomeworkSubmitAnswer> arrayList2 = arrayList;
        arrayList = new ArrayList<HomeworkSubmitAnswer>();
        int n2 = 0;
        for (QuestionOption questionOption : this.options) {
            HomeworkSubmitAnswer homeworkSubmitAnswer;
            if (!questionOption.checked) continue;
            HomeworkSubmitAnswer homeworkSubmitAnswer2 = homeworkSubmitAnswer;
            homeworkSubmitAnswer2();
            homeworkSubmitAnswer2.setQuestion(this._id);
            homeworkSubmitAnswer.setValue(questionOption._id);
            arrayList2.add(n2, homeworkSubmitAnswer2);
            ++n2;
        }
        return arrayList2;
    }

    public List<HomeworkSubmitAnswer> createFillAnswer() {
        ArrayList<HomeworkSubmitAnswer> arrayList = new ArrayList<HomeworkSubmitAnswer>();
        HomeworkSubmitAnswer homeworkSubmitAnswer = new HomeworkSubmitAnswer();
        homeworkSubmitAnswer.setQuestion(this._id);
        arrayList.add(homeworkSubmitAnswer);
        return arrayList;
    }
}

