/*
 * Decompiled with CFR 0.152.
 */
package com.onyx.android.sdk.data.utils;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.support.annotation.Nullable;
import android.util.Log;
import com.facebook.common.memory.PooledByteBuffer;
import com.facebook.common.references.CloseableReference;
import com.facebook.drawee.backends.pipeline.Fresco;
import com.facebook.imagepipeline.image.EncodedImage;
import com.facebook.imagepipeline.memory.PoolConfig;
import com.facebook.imagepipeline.memory.PoolFactory;
import com.onyx.android.sdk.data.compatability.OnyxThumbnail;
import com.onyx.android.sdk.data.model.BaseData;
import com.onyx.android.sdk.data.model.Thumbnail;
import com.onyx.android.sdk.data.provider.DataProviderBase;
import com.onyx.android.sdk.device.EnvironmentUtil;
import com.onyx.android.sdk.utils.BitmapUtils;
import com.onyx.android.sdk.utils.FileUtils;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;

public class ThumbnailUtils {
    public static final String thumbnail_folder = ".thumbnails";
    public static final String preferred_extension = "png";
    public static OnyxThumbnail.ThumbnailKind DEFAULT_THUMBNAIL_KIND;
    public static final float radio = 0.71f;
    private static Map<String, Integer> a;
    static final /* synthetic */ boolean b;

    public static Map<String, Integer> defaultThumbnailMapping() {
        return a;
    }

    public static Map<String, Integer> initDefaultThumbnailMap(Map<String, Integer> resMap) {
        Map<String, Integer> map;
        a.putAll(map);
        return a;
    }

    /*
     * WARNING - void declaration
     */
    public static Bitmap loadThumbnail(Context context, int resId) {
        void var1_1;
        Context context2 = (BitmapDrawable)context.getResources().getDrawable((int)var1_1);
        return context2 == null ? null : context2.getBitmap();
    }

    /*
     * WARNING - void declaration
     */
    public static String getThumbnailFile(Context context, String sourceMD5, String thumbnailKind) {
        void var2_2;
        void var1_1;
        return ThumbnailUtils.getThumbnailFile(context, (String)var1_1, (String)var2_2, preferred_extension);
    }

    /*
     * WARNING - void declaration
     */
    public static String getThumbnailFile(Context context, String sourceMD5, String thumbnailKind, String extension) {
        void var3_3;
        void var2_2;
        void var1_1;
        Context context2;
        return ThumbnailUtils.getThumbnailFolder(context2) + File.separator + (String)var1_1 + "." + (String)var2_2 + "." + (String)var3_3;
    }

    public static String getThumbnailFolder(Context context) {
        Context context2;
        return EnvironmentUtil.getExternalStorageAppCacheDirectory((String)context2.getPackageName()) + File.separator + thumbnail_folder;
    }

    /*
     * WARNING - void declaration
     */
    private static Bitmap a(Bitmap bitmap, OnyxThumbnail.ThumbnailKind kind) {
        block7: {
            Bitmap bitmap2;
            void var1_1;
            switch (com.onyx.android.sdk.data.utils.ThumbnailUtils$a.a[var1_1.ordinal()]) {
                default: {
                    if (b) {
                        break;
                    }
                    break block7;
                }
                case 4: {
                    bitmap2 = OnyxThumbnail.createSmallThumbnail(bitmap2);
                    break;
                }
                case 3: {
                    bitmap2 = OnyxThumbnail.createMiddleThumbnail(bitmap2);
                    break;
                }
                case 2: {
                    bitmap2 = OnyxThumbnail.createLargeThumbnail(bitmap2);
                    break;
                }
                case 1: {
                    bitmap2 = OnyxThumbnail.createLargeThumbnail(bitmap2);
                }
            }
            return bitmap2;
        }
        throw new AssertionError();
    }

    /*
     * WARNING - void declaration
     */
    public static boolean insertDefaultKindThumbnail(Context context, DataProviderBase provider, String filePath, String associationId, Bitmap bitmap) {
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        Object object = DEFAULT_THUMBNAIL_KIND;
        return ThumbnailUtils.insertThumbnail(context, (DataProviderBase)var1_1, (String)var2_2, (String)var3_3, (OnyxThumbnail.ThumbnailKind)((Object)object), (Bitmap)var4_4);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean insertThumbnail(Context context, DataProviderBase dataProvider, String filePath, String associationId, OnyxThumbnail.ThumbnailKind kind, Bitmap bitmap) {
        void var5_5;
        void var4_4;
        void var3_3;
        Context context2;
        void var2_2;
        void var1_1;
        return ThumbnailUtils.insertThumbnail(context, (DataProviderBase)var1_1, (String)var2_2, ThumbnailUtils.getThumbnailFile(context2, (String)var3_3, var4_4.toString()), (String)var3_3, (OnyxThumbnail.ThumbnailKind)var4_4, (Bitmap)var5_5);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean insertThumbnail(Context context, DataProviderBase dataProvider, String bookFilePath, String thumbnailFilePath, String associationId, OnyxThumbnail.ThumbnailKind kind, Bitmap bitmap) {
        void var6_6;
        void var5_5;
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        Object object = ThumbnailUtils.insertThumbnail(context, (DataProviderBase)var1_1, (String)var2_2, (String)var3_3, (String)var4_4, (OnyxThumbnail.ThumbnailKind)var5_5);
        return object != null && ThumbnailUtils.generateThumbnailBitmap((Thumbnail)((Object)object), (Bitmap)var6_6);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static Thumbnail insertThumbnail(Context context, DataProviderBase dataProvider, String bookFilePath, String thumbnailFilePath, String associationId, OnyxThumbnail.ThumbnailKind kind) {
        void var3_3;
        void var4_4;
        void var2_2;
        void var5_5;
        Thumbnail thumbnail;
        Object object;
        Context context2 = object;
        object = thumbnail;
        ((Thumbnail)((Object)object))();
        ((Thumbnail)((Object)object)).setThumbnailKind((OnyxThumbnail.ThumbnailKind)var5_5);
        ((Thumbnail)((Object)object)).setOriginContentPath((String)var2_2);
        ((BaseData)((Object)object)).setIdString((String)var4_4);
        thumbnail.setImageDataPath((String)var3_3);
        if (!dataProvider.saveThumbnailEntry(context2, (Thumbnail)((Object)object))) {
            object = null;
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean insertThumbnail(Context context, DataProviderBase dataProvider, String filePath, String associationId, Bitmap bitmap) {
        for (OnyxThumbnail.ThumbnailKind thumbnailKind : OnyxThumbnail.ThumbnailKind.values()) {
            void var4_4;
            void var3_3;
            void var2_2;
            void var1_1;
            Context context2;
            boolean bl = ThumbnailUtils.insertThumbnail(context2, (DataProviderBase)var1_1, (String)var2_2, (String)var3_3, thumbnailKind, (Bitmap)var4_4);
            if (!thumbnailKind.equals((Object)DEFAULT_THUMBNAIL_KIND) || bl) continue;
            return false;
        }
        return true;
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean writeBitmapToThumbnailFile(File file, Bitmap transBitmap) {
        Throwable throwable2;
        FileOutputStream fileOutputStream;
        block12: {
            FileOutputStream fileOutputStream2;
            block11: {
                Bitmap.CompressFormat compressFormat;
                block10: {
                    boolean bl;
                    File file2;
                    FileOutputStream fileOutputStream3;
                    compressFormat = null;
                    fileOutputStream = fileOutputStream3;
                    fileOutputStream3 = new FileOutputStream(file2);
                    if (transBitmap == null) break block10;
                    try {
                        void var1_4;
                        block15: {
                            Bitmap.CompressFormat compressFormat2;
                            block14: {
                                block13: {
                                    if (var1_4.isRecycled()) break block10;
                                    compressFormat = Bitmap.CompressFormat.PNG;
                                    if (!FileUtils.isPngExtension((File)file2)) break block13;
                                    compressFormat2 = Bitmap.CompressFormat.PNG;
                                    break block14;
                                }
                                if (!FileUtils.isJpgExtension((File)file2)) break block15;
                                compressFormat2 = Bitmap.CompressFormat.JPEG;
                            }
                            compressFormat = compressFormat2;
                        }
                        bl = var1_4.compress(compressFormat, 100, (OutputStream)fileOutputStream);
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        break block11;
                    }
                    FileUtils.closeQuietly((Closeable)fileOutputStream);
                    return bl;
                }
                FileUtils.closeQuietly((Closeable)fileOutputStream);
                return false;
                catch (Throwable throwable2) {
                    fileOutputStream = compressFormat;
                    break block12;
                }
                catch (FileNotFoundException fileNotFoundException) {
                    fileOutputStream = compressFormat;
                }
            }
            try {
                void var0_3;
                fileOutputStream2 = fileOutputStream;
                Log.w((String)"writeBitmapToThumbnail", (Throwable)var0_3);
            }
            catch (Throwable throwable2) {
                // empty catch block
            }
            FileUtils.closeQuietly((Closeable)fileOutputStream2);
            return false;
        }
        FileUtils.closeQuietly((Closeable)fileOutputStream);
        throw throwable2;
    }

    public static boolean generateThumbnailBitmap(Thumbnail thumbnail, Bitmap bmp) {
        Thumbnail thumbnail2;
        Bitmap bitmap;
        bitmap = ThumbnailUtils.a(bitmap, thumbnail2.getThumbnailKind());
        FileUtils.ensureFileExists((String)thumbnail.getImageDataPath());
        return ThumbnailUtils.writeBitmapToThumbnailFile(new File(thumbnail2.getImageDataPath()), bitmap);
    }

    public static Bitmap createLargeThumbnail(Bitmap bmp) {
        return ThumbnailUtils.a(bmp, 512);
    }

    public static Bitmap createMiddleThumbnail(Bitmap bmp) {
        return ThumbnailUtils.a(bmp, 256);
    }

    public static Bitmap createSmallThumbnail(Bitmap bmp) {
        return ThumbnailUtils.a(bmp, 128);
    }

    private static Bitmap a(Bitmap bmp, int limit) {
        int n2;
        Bitmap bitmap;
        int n3;
        if (bmp.getWidth() <= n3 && bitmap.getHeight() <= n3) {
            return bitmap;
        }
        if (bitmap.getWidth() >= bitmap.getHeight()) {
            n2 = (int)((double)n3 / (double)bitmap.getWidth() * (double)bitmap.getHeight());
            void v0 = n3;
            n3 = n2;
            n2 = v0;
        } else {
            n2 = (int)((double)n3 / (double)bitmap.getHeight() * (double)bitmap.getWidth());
        }
        return Bitmap.createScaledBitmap((Bitmap)bitmap, (int)n2, (int)n3, (boolean)true);
    }

    public static CloseableReference<Bitmap> decodeFile(File file) throws IOException {
        File file2;
        return ThumbnailUtils.decodeStream(new FileInputStream(file2), Bitmap.Config.ARGB_8888);
    }

    /*
     * WARNING - void declaration
     */
    public static CloseableReference<Bitmap> decodeFile(File file, Bitmap.Config config) throws IOException {
        void var1_1;
        File file2;
        return ThumbnailUtils.decodeStream(new FileInputStream(file2), (Bitmap.Config)var1_1);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static CloseableReference<Bitmap> decodeStream(InputStream inputStream, Bitmap.Config config) throws IOException {
        EncodedImage encodedImage;
        Throwable throwable2;
        InputStream inputStream2;
        PooledByteBuffer pooledByteBuffer;
        block5: {
            CloseableReference closeableReference;
            EncodedImage encodedImage2;
            pooledByteBuffer = null;
            EncodedImage encodedImage3 = null;
            try {
                pooledByteBuffer = new PoolFactory(PoolConfig.newBuilder().build()).getPooledByteBufferFactory().newByteBuffer(inputStream2);
            }
            catch (Throwable throwable2) {
                encodedImage = encodedImage3;
                break block5;
            }
            encodedImage = encodedImage2;
            {
                encodedImage2 = new EncodedImage(CloseableReference.of((Closeable)pooledByteBuffer));
            }
            try {
                void var1_1;
                closeableReference = Fresco.getImagePipelineFactory().getPlatformDecoder().decodeFromEncodedImage(encodedImage, (Bitmap.Config)var1_1, null);
            }
            catch (Throwable throwable2) {
                break block5;
            }
            FileUtils.closeQuietly((Closeable)inputStream2);
            FileUtils.closeQuietly((Closeable)encodedImage);
            FileUtils.closeQuietly((Closeable)pooledByteBuffer);
            return closeableReference;
        }
        FileUtils.closeQuietly((Closeable)inputStream2);
        FileUtils.closeQuietly((Closeable)encodedImage);
        FileUtils.closeQuietly((Closeable)pooledByteBuffer);
        throw throwable2;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean hasThumbnail(Context context, DataProviderBase dataProvider, String associationId) {
        void var2_2;
        void var1_1;
        Object object = DEFAULT_THUMBNAIL_KIND;
        return (object = ThumbnailUtils.getThumbnailEntry(context, (DataProviderBase)var1_1, (String)var2_2, (OnyxThumbnail.ThumbnailKind)((Object)object))) != null && ((BaseData)((Object)object)).hasValidId();
    }

    /*
     * WARNING - void declaration
     */
    public static boolean hasThumbnailFile(Context context, DataProviderBase dataProvider, String associationId) {
        void var2_2;
        void var1_1;
        Object object = ThumbnailUtils.getDefaultKindThumbnailEntry(context, (DataProviderBase)var1_1, (String)var2_2);
        return object != null && object.hasValidId() && FileUtils.fileExist((String)object.getImageDataPath());
    }

    /*
     * WARNING - void declaration
     */
    public static Thumbnail getThumbnailEntry(Context context, DataProviderBase dataProvider, String associationId, OnyxThumbnail.ThumbnailKind kind) {
        void var3_3;
        void var2_2;
        Context context2;
        return dataProvider.getThumbnailEntry(context2, (String)var2_2, (OnyxThumbnail.ThumbnailKind)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public static Thumbnail getDefaultKindThumbnailEntry(Context context, DataProviderBase dataProvider, String associationId) {
        void var2_2;
        void var1_1;
        return ThumbnailUtils.getThumbnailEntry(context, (DataProviderBase)var1_1, (String)var2_2, DEFAULT_THUMBNAIL_KIND);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean updateThumbnailEntrySet(Context context, DataProviderBase dataProvider, String associationId, Bitmap originBitmap) {
        boolean bl = true;
        OnyxThumbnail.ThumbnailKind[] thumbnailKindArray = OnyxThumbnail.ThumbnailKind.values();
        int n2 = thumbnailKindArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            void var3_3;
            void var2_2;
            void var1_1;
            Context context2;
            bl &= ThumbnailUtils.updateThumbnailEntry(context2, (DataProviderBase)var1_1, (String)var2_2, thumbnailKindArray[i2], (Bitmap)var3_3);
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean updateThumbnailEntry(Context context, DataProviderBase dataProvider, String associationId, OnyxThumbnail.ThumbnailKind kind, Bitmap originBitmap) {
        void var4_4;
        Context context2;
        void var3_3;
        void var1_1;
        Thumbnail thumbnail;
        if ((thumbnail = ThumbnailUtils.getThumbnailEntry(context, (DataProviderBase)var1_1, (String)((Object)thumbnail), (OnyxThumbnail.ThumbnailKind)var3_3)) == null) {
            Log.w((String)"update thumbnail", (String)"detect null");
            return false;
        }
        Thumbnail thumbnail2 = thumbnail;
        thumbnail2.setImageDataPath(ThumbnailUtils.getThumbnailFile(context2, thumbnail.getIdString(), thumbnail.getThumbnailKind().toString()));
        return var1_1.saveThumbnailEntry(context2, thumbnail2) && ThumbnailUtils.generateThumbnailBitmap(thumbnail, (Bitmap)var4_4);
    }

    /*
     * WARNING - void declaration
     */
    public static void updateThumbnail(Context context, DataProviderBase dataProvider, Thumbnail thumbnail) {
        void var2_2;
        Context context2;
        dataProvider.updateThumbnailEntry(context2, (Thumbnail)var2_2);
    }

    public static boolean isBitmapValid(CloseableReference<Bitmap> refBitmap) {
        CloseableReference<Bitmap> closeableReference;
        return refBitmap != null && closeableReference.isValid() && BitmapUtils.isValid((Bitmap)((Bitmap)closeableReference.get()));
    }

    static {
        b = ThumbnailUtils.class.desiredAssertionStatus() ^ true;
        DEFAULT_THUMBNAIL_KIND = OnyxThumbnail.ThumbnailKind.Middle;
        a = new HashMap<String, Integer>();
    }
}

