/*
 * Decompiled with CFR 0.152.
 */
package com.onyx.android.sdk.data.model.v2;

import com.alibaba.fastjson.annotation.JSONField;
import com.alibaba.fastjson.parser.Feature;
import com.onyx.android.sdk.data.model.BaseData;
import com.onyx.android.sdk.data.model.Device;
import com.onyx.android.sdk.data.model.v2.AccountCommon;
import com.onyx.android.sdk.data.utils.JSONObjectParseUtils;
import com.onyx.android.sdk.utils.CollectionUtils;
import com.onyx.android.sdk.utils.StringUtils;
import com.raizlabs.android.dbflow.annotation.ColumnIgnore;
import java.util.Date;
import java.util.List;

public class NeoAccountBase
extends BaseData {
    public static final String DELIMITER = ",";
    public String _id;
    public String name;
    public String orgName;
    public List<String> groups;
    public String token;
    public long tokenExpiresIn;
    public String phone;
    public String info;
    public String library;
    @ColumnIgnore
    public List<Device> devices;

    @JSONField(serialize=false, deserialize=false)
    public static boolean isValid(NeoAccountBase account) {
        NeoAccountBase neoAccountBase;
        return account != null && StringUtils.isNotBlank((String)neoAccountBase.token);
    }

    public static void parseName(NeoAccountBase account) {
        NeoAccountBase neoAccountBase;
        AccountCommon accountCommon;
        if (account != null && (accountCommon = JSONObjectParseUtils.parseObject(neoAccountBase.info, AccountCommon.class, new Feature[0])) != null) {
            neoAccountBase.name = accountCommon.name;
        }
    }

    public static void parseInfo(NeoAccountBase account) {
        NeoAccountBase neoAccountBase;
        AccountCommon accountCommon;
        if (account != null && (accountCommon = JSONObjectParseUtils.parseObject(neoAccountBase.info, AccountCommon.class, new Feature[0])) != null) {
            neoAccountBase.name = accountCommon.name;
            neoAccountBase.orgName = accountCommon.organization;
            if (StringUtils.isNotBlank((String)accountCommon.phone)) {
                neoAccountBase.phone = accountCommon.phone;
            }
        }
    }

    @JSONField(serialize=false, deserialize=false)
    public String getFirstGroup() {
        if (CollectionUtils.isNullOrEmpty(this.groups)) {
            return "";
        }
        return this.groups.get(0).replaceAll(DELIMITER, "");
    }

    @JSONField(serialize=false, deserialize=false)
    public Device getFirstDevice() {
        if (CollectionUtils.isNullOrEmpty(this.devices)) {
            return null;
        }
        return this.devices.get(0);
    }

    public String getPhone() {
        return StringUtils.safelyGetStr((String)this.phone);
    }

    public String getName() {
        return StringUtils.safelyGetStr((String)this.name);
    }

    @JSONField(serialize=false, deserialize=false)
    public boolean isTokenTimeExpired() {
        if (this.getCreatedAt() == null) {
            return true;
        }
        return this.getCreatedAt().getTime() + this.getTokenExpiresIn() < new Date().getTime();
    }

    @JSONField(serialize=false, deserialize=false)
    public long getTokenExpiresIn() {
        return this.tokenExpiresIn * 1000L;
    }

    /*
     * WARNING - void declaration
     */
    public void setAuthToken(String token, long tokenExpiresIn) {
        void var2_2;
        void var1_1;
        NeoAccountBase neoAccountBase = this;
        neoAccountBase.token = var1_1;
        neoAccountBase.tokenExpiresIn = var2_2;
    }
}

