/*
 * Decompiled with CFR 0.152.
 */
package com.onyx.android.sdk.data.common;

import com.onyx.android.sdk.data.utils.ResultCode;
import java.io.File;

public class ContentException
extends Exception {
    public static final int URL_INVALID_EXCEPTION = 1;
    public static final int FILE_PATH_EXCEPTION = 2;
    public static final int NETWORK_EXCEPTION = 3;
    public static final int TOKEN_EXCEPTION = 4;
    public static final int IO_EXCEPTION = 5;
    public static final int NETWORK_SOCKET_TIMEOUT = 6;
    public static final int UNKNOWN_EXCEPTION = 65535;
    public static final int CLOUD_TOKEN_EXCEPTION = 401;
    public static final int CLOUD_NO_FOUND = 404;
    public static final int CLOUD_INTERNAL_SERVER_ERROR = 500;
    public static final int CLOUD_SPACE_NOT_ENOUGH = 456;
    public static final String URL_INVALID_EXCEPTION_MESSAGE = "Url is invalid.";
    public static final String FILE_PATH_EXCEPTION_MESSAGE = "File path is invalid.";
    public static final String FILE_NOT_EXIST_MESSAGE = "File is not exist.";
    public static final String NETWORK_EXCEPTION_MESSAGE = "Network is exception.";
    public static final String UNKNOWN_EXCEPTION_MESSAGE = "Unknown exception.";
    public static final String TOKEN_EXCEPTION_MESSAGE = "Token exception.";
    public static final String SOCKET_TIMEOUT_EXCEPTION_MESSAGE = "socket time out exception";
    private int a;

    /*
     * WARNING - void declaration
     */
    public ContentException(int theCode, String theMessage) {
        super((String)var2_2);
        void var1_1;
        void var2_2;
        this.a = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public ContentException(String message, Throwable cause) {
        super((String)var1_1, (Throwable)var2_2);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public ContentException(Throwable cause) {
        super((Throwable)var1_1);
        void var1_1;
    }

    public static ContentException createException(Exception e2) {
        return ContentException.exceptionFromCode(65535, e2.toString());
    }

    /*
     * WARNING - void declaration
     */
    public static ContentException exceptionFromCode(int code, String errorMessage) {
        void var1_1;
        int n2;
        return new ContentException(n2, (String)var1_1);
    }

    public static ContentException exceptionFromResultCode(ResultCode resultCode) {
        ResultCode resultCode2;
        if (resultCode == null) {
            return ContentException.UnKnowException();
        }
        String string2 = resultCode2.message;
        int n2 = resultCode2.code;
        if (string2 == null) {
            string2 = n2 + "," + NETWORK_EXCEPTION_MESSAGE;
        }
        return ContentException.exceptionFromCode(n2, string2);
    }

    public static ContentException UrlInvalidException() {
        return ContentException.exceptionFromCode(1, URL_INVALID_EXCEPTION_MESSAGE);
    }

    public static ContentException FilePathInvalidException() {
        return ContentException.exceptionFromCode(2, FILE_PATH_EXCEPTION_MESSAGE);
    }

    public static ContentException timeoutException() {
        return ContentException.exceptionFromCode(6, SOCKET_TIMEOUT_EXCEPTION_MESSAGE);
    }

    public static ContentException UnKnowException() {
        return ContentException.exceptionFromCode(65535, UNKNOWN_EXCEPTION_MESSAGE);
    }

    public static ContentException TokenException() {
        return ContentException.exceptionFromCode(4, TOKEN_EXCEPTION_MESSAGE);
    }

    public static boolean isNetworkException(Throwable throwable) {
        return throwable instanceof NetworkException;
    }

    public static boolean isCloudException(Throwable throwable) {
        return throwable instanceof CloudException;
    }

    public static boolean isCloudSpaceNotEnough(Throwable throwable) {
        Throwable throwable2;
        return ContentException.isCloudException(throwable) && ((ContentException)throwable2).isCloudSpaceNotEnough();
    }

    public static boolean isCloudTokenException(Throwable throwable) {
        Throwable throwable2;
        if (!ContentException.isCloudException(throwable)) {
            return false;
        }
        return ((ContentException)(throwable2 = (ContentException)throwable2)).isCloudTokenException() || ResultCode.isTokenInvalid(((ContentException)throwable2).getCode());
    }

    public int getCode() {
        return this.a;
    }

    /*
     * WARNING - void declaration
     */
    public void setCode(int code) {
        void var1_1;
        this.a = var1_1;
    }

    public boolean isCloudNotFound() {
        return this.getCode() == 404;
    }

    public boolean isCloudServerError() {
        return this.getCode() == 500;
    }

    public boolean isCloudTokenException() {
        return this.getCode() == 401;
    }

    public boolean isTimeoutException() {
        return this.getCode() == 6;
    }

    public boolean isCloudSpaceNotEnough() {
        return this.getCode() == 42010456;
    }

    public boolean isEmailAddressError() {
        return this.getCode() == 42010089;
    }

    public static class FileNotExistException
    extends FileException {
        /*
         * WARNING - void declaration
         */
        public FileNotExistException(String path) {
            super(5, ContentException.FILE_NOT_EXIST_MESSAGE + (String)var1_1);
            void var1_1;
        }
    }

    public static class FileCreateException
    extends FileException {
        public File file;

        /*
         * WARNING - void declaration
         */
        public FileCreateException(File file) {
            super(5, "FileCreateException");
            void var1_1;
            this.file = var1_1;
        }
    }

    public static class FileDeleteException
    extends FileException {
        public File file;

        /*
         * WARNING - void declaration
         */
        public FileDeleteException(File file) {
            super(5, "FileDeleteException");
            void var1_1;
            this.file = var1_1;
        }
    }

    public static class FileCopySpaceNotEnoughException
    extends FileException {
        public File source;
        public File targetDir;

        /*
         * WARNING - void declaration
         */
        public FileCopySpaceNotEnoughException(File source, File targetDir) {
            super(5, "FileCopySpaceNotEnoughException");
            void var2_2;
            void var1_1;
            this.source = var1_1;
            this.targetDir = var2_2;
        }
    }

    public static class FileCopyException
    extends FileException {
        public File from;
        public File to;

        /*
         * WARNING - void declaration
         */
        public FileCopyException(File from, File to) {
            super(5, "FileCopyException");
            void var2_2;
            void var1_1;
            this.from = var1_1;
            this.to = var2_2;
        }
    }

    public static class FileAskForReplaceException
    extends FileException {
        public File from;
        public File to;

        /*
         * WARNING - void declaration
         */
        public FileAskForReplaceException(File from, File to) {
            super(5, "FileAskForReplaceException");
            void var2_2;
            void var1_1;
            this.from = var1_1;
            this.to = var2_2;
        }

        public boolean isSameOriginTarget() {
            return this.from.getAbsolutePath().equals(this.to.getAbsolutePath());
        }
    }

    public static class FileException
    extends ContentException {
        /*
         * WARNING - void declaration
         */
        public FileException(int code, String msg) {
            super((int)var1_1, (String)var2_2);
            void var2_2;
            void var1_1;
        }
    }

    public static class CloudException
    extends ContentException {
        /*
         * WARNING - void declaration
         */
        public CloudException(ResultCode resultCode) {
            super(ContentException.exceptionFromResultCode((ResultCode)var1_1));
            void var1_1;
            int n2 = resultCode == null ? 65535 : var1_1.code;
            this.setCode(n2);
        }
    }

    public static class NetworkException
    extends ContentException {
        /*
         * WARNING - void declaration
         */
        public NetworkException(Exception e2) {
            super((Throwable)var1_1);
            void var1_1;
        }
    }
}

