/*
 * Decompiled with CFR 0.152.
 */
package com.onyx.android.sdk.data.utils;

import android.text.TextUtils;
import com.onyx.android.sdk.data.model.BaseStatisticsModel;
import com.onyx.android.sdk.data.model.Book;
import com.onyx.android.sdk.data.model.OnyxStatisticsModel;
import com.onyx.android.sdk.data.model.OnyxStatisticsModel_Table;
import com.onyx.android.sdk.data.model.account.OnyxAccountModel;
import com.onyx.android.sdk.utils.MapUtils;
import com.onyx.android.sdk.utils.StringUtils;
import com.raizlabs.android.dbflow.config.FlowManager;
import com.raizlabs.android.dbflow.sql.language.OperatorGroup;
import com.raizlabs.android.dbflow.sql.language.SQLOperator;
import com.raizlabs.android.dbflow.sql.language.SQLite;
import com.raizlabs.android.dbflow.sql.language.Select;
import com.raizlabs.android.dbflow.sql.language.Where;
import com.raizlabs.android.dbflow.sql.language.property.IProperty;
import com.raizlabs.android.dbflow.structure.database.DatabaseWrapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class StatisticsUtils {
    private static final int a = 24;
    private static final long b = 60000L;

    public static void saveStatistics(OnyxStatisticsModel statisticsData) {
        OnyxStatisticsModel onyxStatisticsModel;
        if (statisticsData == null) {
            return;
        }
        onyxStatisticsModel.save();
    }

    public static void saveStatisticsList(Collection<OnyxStatisticsModel> list) {
        DatabaseWrapper databaseWrapper = FlowManager.getDatabase((String)"OnyxStatisticsModel").getWritableDatabase();
        databaseWrapper.beginTransaction();
        Iterator<OnyxStatisticsModel> iterator = list.iterator();
        while (iterator.hasNext()) {
            iterator.next().save();
        }
        DatabaseWrapper databaseWrapper2 = databaseWrapper;
        databaseWrapper2.setTransactionSuccessful();
        databaseWrapper2.endTransaction();
    }

    public static void deleteStatisticsList(Collection<OnyxStatisticsModel> list) {
        DatabaseWrapper databaseWrapper = FlowManager.getDatabase((String)"OnyxStatisticsModel").getWritableDatabase();
        databaseWrapper.beginTransaction();
        Iterator<OnyxStatisticsModel> iterator = list.iterator();
        while (iterator.hasNext()) {
            iterator.next().delete();
        }
        DatabaseWrapper databaseWrapper2 = databaseWrapper;
        databaseWrapper2.setTransactionSuccessful();
        databaseWrapper2.endTransaction();
    }

    /*
     * WARNING - void declaration
     */
    public static void deleteStatisticsListByStatus(int count, int status) {
        void var1_2;
        List list = (List)StatisticsUtils.loadStatisticsListByStatus(count, (int)var1_2);
        DatabaseWrapper databaseWrapper = FlowManager.getDatabase((String)"OnyxStatisticsModel").getWritableDatabase();
        databaseWrapper.beginTransaction();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ((OnyxStatisticsModel)iterator.next()).delete();
        }
        DatabaseWrapper databaseWrapper2 = databaseWrapper;
        databaseWrapper2.setTransactionSuccessful();
        databaseWrapper2.endTransaction();
    }

    public static void deleteStatisticsListByNote(String note) {
        List list = (List)StatisticsUtils.loadStatisticsListByNote(note);
        String string2 = FlowManager.getDatabase((String)"OnyxStatisticsModel").getWritableDatabase();
        string2.beginTransaction();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ((OnyxStatisticsModel)iterator.next()).delete();
        }
        String string3 = string2;
        string3.setTransactionSuccessful();
        string3.endTransaction();
    }

    private static String a(OnyxAccountModel onyxAccountModel) {
        String string2 = "";
        if (onyxAccountModel != null) {
            OnyxAccountModel onyxAccountModel2;
            string2 = String.valueOf(onyxAccountModel2.getAccountId());
        }
        return string2;
    }

    public static void deleteStatisticsListByMd5AndOrgText(int type, OnyxStatisticsModel statisticsModel, OnyxAccountModel onyxAccountModel) {
        String string2;
        String string3;
        void v0 = string3;
        String string4 = v0.getMd5();
        string3 = v0.getOrgText();
        string2 = StatisticsUtils.a((OnyxAccountModel)((Object)string2));
        StatisticsUtils.deleteStatisticsListByMd5AndOrgText(type, string4, string3, string2);
    }

    public static void deleteStatisticsListByMd5AndOrgText(int type, List<OnyxStatisticsModel> statisticsModels, OnyxAccountModel onyxAccountModel) {
        Iterator<OnyxStatisticsModel> iterator;
        String string2 = StatisticsUtils.a((OnyxAccountModel)((Object)iterator));
        for (OnyxStatisticsModel onyxStatisticsModel : statisticsModels) {
            int n2;
            String string3 = onyxStatisticsModel.getMd5();
            StatisticsUtils.deleteStatisticsListByMd5AndOrgText(n2, string3, onyxStatisticsModel.getOrgText(), string2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void deleteStatisticsListByMd5AndOrgText(int type, String md5, String orgText, String accountID) {
        void var3_4;
        void var2_3;
        Iterator iterator;
        List list = (List)StatisticsUtils.loadStatisticsListByMd5AndOrgText(type, (String)((Object)iterator), (String)var2_3, (String)var3_4);
        DatabaseWrapper databaseWrapper = FlowManager.getDatabase((String)"OnyxStatisticsModel").getWritableDatabase();
        databaseWrapper.beginTransaction();
        iterator = list.iterator();
        while (iterator.hasNext()) {
            ((OnyxStatisticsModel)iterator.next()).delete();
        }
        DatabaseWrapper databaseWrapper2 = databaseWrapper;
        databaseWrapper2.setTransactionSuccessful();
        databaseWrapper2.endTransaction();
    }

    public static void deleteStatisticsList() {
        List list = new Select(new IProperty[0]).from(OnyxStatisticsModel.class).queryList();
        DatabaseWrapper databaseWrapper = FlowManager.getDatabase((String)"OnyxStatisticsModel").getWritableDatabase();
        databaseWrapper.beginTransaction();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ((OnyxStatisticsModel)iterator.next()).delete();
        }
        DatabaseWrapper databaseWrapper2 = databaseWrapper;
        databaseWrapper2.setTransactionSuccessful();
        databaseWrapper2.endTransaction();
    }

    /*
     * WARNING - void declaration
     */
    public static Collection<OnyxStatisticsModel> loadStatisticsListByStatus(int count, int status) {
        int n2;
        void var1_1;
        return new Select(new IProperty[0]).from(OnyxStatisticsModel.class).where(new SQLOperator[]{OnyxStatisticsModel_Table.status.eq((Object)((int)var1_1))}).limit(n2).queryList();
    }

    /*
     * WARNING - void declaration
     */
    public static Collection<OnyxStatisticsModel> loadStatisticsListByStatus(String accountId, int maxPushCount, int status) {
        void var1_1;
        void var2_3;
        Where where = new Select(new IProperty[0]).from(OnyxStatisticsModel.class).where(new SQLOperator[]{OnyxStatisticsModel_Table.status.eq((Object)((int)var2_3))}).limit((int)var1_1);
        if (!TextUtils.isEmpty((CharSequence)accountId)) {
            String string2;
            where.and((SQLOperator)OnyxStatisticsModel_Table.accountId.eq((Object)string2));
        }
        return where.queryList();
    }

    public static Collection<OnyxStatisticsModel> loadStatisticsListByNote(String note) {
        String string2;
        return new Select(new IProperty[0]).from(OnyxStatisticsModel.class).where(new SQLOperator[]{OnyxStatisticsModel_Table.note.eq((Object)string2)}).queryList();
    }

    /*
     * WARNING - void declaration
     */
    public static Collection<OnyxStatisticsModel> loadStatisticsList(String md5, int type) {
        String string2;
        void var1_1;
        return new Select(new IProperty[0]).from(OnyxStatisticsModel.class).where(new SQLOperator[]{OnyxStatisticsModel_Table.type.eq((Object)((int)var1_1))}).and((SQLOperator)OnyxStatisticsModel_Table.md5.eq((Object)string2)).queryList();
    }

    /*
     * WARNING - void declaration
     */
    public static Collection<OnyxStatisticsModel> loadStatisticsList(String md5, int type, Date fromTime) {
        void var2_2;
        String string2;
        void var1_1;
        return new Select(new IProperty[0]).from(OnyxStatisticsModel.class).where(new SQLOperator[]{OnyxStatisticsModel_Table.type.eq((Object)((int)var1_1))}).and((SQLOperator)OnyxStatisticsModel_Table.md5.eq((Object)string2)).and((SQLOperator)OnyxStatisticsModel_Table.eventTime.greaterThan((Object)var2_2)).queryList();
    }

    public static Collection<OnyxStatisticsModel> loadStatisticsList(int type) {
        int n2;
        return new Select(new IProperty[0]).from(OnyxStatisticsModel.class).where(new SQLOperator[]{OnyxStatisticsModel_Table.type.eq((Object)n2)}).queryList();
    }

    /*
     * WARNING - void declaration
     */
    public static long loadStatisticsCount(int type, String accountID) {
        int n2;
        Where where = SQLite.select((IProperty[])new IProperty[]{OnyxStatisticsModel_Table.id}).from(OnyxStatisticsModel.class).where(new SQLOperator[]{OnyxStatisticsModel_Table.type.eq((Object)n2)});
        if (!TextUtils.isEmpty((CharSequence)accountID)) {
            void var1_2;
            where.and((SQLOperator)OnyxStatisticsModel_Table.accountId.eq((Object)var1_2));
        }
        return where.queryList().size();
    }

    /*
     * WARNING - void declaration
     */
    public static Collection<OnyxStatisticsModel> loadStatisticsList(int type, String accountID) {
        int n2;
        Where where = new Select(new IProperty[0]).from(OnyxStatisticsModel.class).where(new SQLOperator[]{OnyxStatisticsModel_Table.type.eq((Object)n2)});
        if (!TextUtils.isEmpty((CharSequence)accountID)) {
            void var1_2;
            where.and((SQLOperator)OnyxStatisticsModel_Table.accountId.eq((Object)var1_2));
        }
        return where.queryList();
    }

    /*
     * WARNING - void declaration
     */
    public static Collection<OnyxStatisticsModel> loadStatisticsList(int type, int status) {
        void var1_1;
        int n2;
        return new Select(new IProperty[0]).from(OnyxStatisticsModel.class).where(new SQLOperator[]{OnyxStatisticsModel_Table.type.eq((Object)n2)}).and((SQLOperator)OnyxStatisticsModel_Table.status.eq((Object)((int)var1_1))).queryList();
    }

    public static Collection<OnyxStatisticsModel> loadStatisticsList(Date fromTime) {
        Date date;
        return new Select(new IProperty[0]).from(OnyxStatisticsModel.class).where(new SQLOperator[]{OnyxStatisticsModel_Table.eventTime.greaterThan((Object)date)}).queryList();
    }

    /*
     * WARNING - void declaration
     */
    public static Collection<OnyxStatisticsModel> loadStatisticsList(Date fromTime, int type) {
        void var1_1;
        Date date;
        return new Select(new IProperty[0]).from(OnyxStatisticsModel.class).where(new SQLOperator[]{OnyxStatisticsModel_Table.eventTime.greaterThan((Object)date)}).and((SQLOperator)OnyxStatisticsModel_Table.type.eq((Object)((int)var1_1))).queryList();
    }

    /*
     * WARNING - void declaration
     */
    public static Collection<OnyxStatisticsModel> loadStatisticsList(Date beginTime, Date endTime, int type, String accountID) {
        void var2_2;
        void var1_1;
        Date date;
        date = new Select(new IProperty[0]).from(OnyxStatisticsModel.class).where(new SQLOperator[]{OnyxStatisticsModel_Table.eventTime.greaterThan((Object)date)}).and((SQLOperator)OnyxStatisticsModel_Table.eventTime.lessThan((Object)var1_1)).and((SQLOperator)OnyxStatisticsModel_Table.type.eq((Object)((int)var2_2)));
        if (!TextUtils.isEmpty((CharSequence)accountID)) {
            void var3_3;
            date.and((SQLOperator)OnyxStatisticsModel_Table.accountId.eq((Object)var3_3));
        }
        return date.queryList();
    }

    public static Collection<OnyxStatisticsModel> loadStatisticsListByMd5(String md5) {
        String string2;
        return new Select(new IProperty[0]).from(OnyxStatisticsModel.class).where(new SQLOperator[]{OnyxStatisticsModel_Table.md5.eq((Object)string2)}).queryList();
    }

    /*
     * WARNING - void declaration
     */
    public static Collection<OnyxStatisticsModel> loadStatisticsListByMd5AndOrgText(int type, String md5, String orgText, String accountID) {
        void var2_3;
        void var1_2;
        int n2;
        Where where = new Select(new IProperty[0]).from(OnyxStatisticsModel.class).where(new SQLOperator[]{OnyxStatisticsModel_Table.type.eq((Object)n2)}).and((SQLOperator)OnyxStatisticsModel_Table.md5.eq((Object)var1_2)).and((SQLOperator)OnyxStatisticsModel_Table.orgText.eq((Object)StringUtils.trim((String)var2_3)));
        if (!TextUtils.isEmpty((CharSequence)accountID)) {
            void var3_4;
            where.and((SQLOperator)OnyxStatisticsModel_Table.accountId.eq((Object)var3_4));
        }
        return where.queryList();
    }

    /*
     * WARNING - void declaration
     */
    public static Collection<OnyxStatisticsModel> loadStatisticsListOrderByTime(int type, boolean ascending, String accountID) {
        void var1_2;
        int n2;
        Where where = new Select(new IProperty[0]).from(OnyxStatisticsModel.class).where(new SQLOperator[]{OnyxStatisticsModel_Table.type.eq((Object)n2)});
        if (!TextUtils.isEmpty((CharSequence)accountID)) {
            void var2_3;
            where.and((SQLOperator)OnyxStatisticsModel_Table.accountId.eq((Object)var2_3));
        }
        Where where2 = where;
        where2.orderBy(OnyxStatisticsModel_Table.eventTime, (boolean)var1_2);
        return where2.queryList();
    }

    /*
     * WARNING - void declaration
     */
    public static Collection<OnyxStatisticsModel> loadVisibleStatisticsListOrderByTime(int type, boolean ascending, String accountID) {
        void var1_2;
        int n2;
        Where where = new Select(new IProperty[0]).from(OnyxStatisticsModel.class).where(new SQLOperator[]{OnyxStatisticsModel_Table.type.eq((Object)n2)});
        OperatorGroup operatorGroup = OperatorGroup.clause();
        operatorGroup.and((SQLOperator)OnyxStatisticsModel_Table.hideRecord.eq((Object)false)).or((SQLOperator)OnyxStatisticsModel_Table.hideRecord.isNull());
        where.and((SQLOperator)operatorGroup);
        if (!TextUtils.isEmpty((CharSequence)accountID)) {
            void var2_3;
            where.and((SQLOperator)OnyxStatisticsModel_Table.accountId.eq((Object)var2_3));
        }
        Where where2 = where;
        where2.orderBy(OnyxStatisticsModel_Table.eventTime, (boolean)var1_2);
        return where2.queryList();
    }

    /*
     * WARNING - void declaration
     */
    public static Collection<OnyxStatisticsModel> loadStatisticsListOrderByTime(int type, int status, boolean ascending) {
        void var2_2;
        void var1_1;
        int n2;
        return new Select(new IProperty[0]).from(OnyxStatisticsModel.class).where(new SQLOperator[]{OnyxStatisticsModel_Table.type.eq((Object)n2)}).and((SQLOperator)OnyxStatisticsModel_Table.status.eq((Object)((int)var1_1))).orderBy(OnyxStatisticsModel_Table.eventTime, (boolean)var2_2).queryList();
    }

    /*
     * WARNING - void declaration
     */
    public static Collection<OnyxStatisticsModel> loadStatisticsListOrderByTime(String md5, boolean ascending) {
        void var1_1;
        String string2;
        return new Select(new IProperty[0]).from(OnyxStatisticsModel.class).where(new SQLOperator[]{OnyxStatisticsModel_Table.md5.eq((Object)string2)}).orderBy(OnyxStatisticsModel_Table.eventTime, (boolean)var1_1).queryList();
    }

    /*
     * WARNING - void declaration
     */
    public static Collection<OnyxStatisticsModel> loadStatisticsListOrderByTime(String md5, int type, boolean ascending) {
        void var2_2;
        String string2;
        void var1_1;
        return new Select(new IProperty[0]).from(OnyxStatisticsModel.class).where(new SQLOperator[]{OnyxStatisticsModel_Table.type.eq((Object)((int)var1_1))}).and((SQLOperator)OnyxStatisticsModel_Table.md5.eq((Object)string2)).orderBy(OnyxStatisticsModel_Table.eventTime, (boolean)var2_2).queryList();
    }

    public static List<Integer> getEventHourlyAgg(List<OnyxStatisticsModel> statisticsList, int count) {
        Iterator<OnyxStatisticsModel> iterator;
        int n2;
        ArrayList<Integer> arrayList;
        ArrayList<Integer> arrayList2 = arrayList;
        arrayList = new ArrayList<Integer>(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            arrayList2.add(0);
        }
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            n2 = ((OnyxStatisticsModel)iterator.next()).getEventTime().getHours();
            if (n2 >= arrayList2.size()) continue;
            arrayList2.set(n2, (Integer)arrayList2.get(n2) + 1);
        }
        return arrayList2;
    }

    public static Book getLongestBook(List<OnyxStatisticsModel> statisticsModels) {
        HashMap hashMap;
        Object object = hashMap;
        hashMap = new HashMap();
        for (OnyxStatisticsModel onyxStatisticsModel : statisticsModels) {
            String string2 = onyxStatisticsModel.getMd5();
            long l2 = onyxStatisticsModel.getDurationTime();
            if (object.containsKey(string2)) {
                l2 = (Long)object.get(string2) + onyxStatisticsModel.getDurationTime();
            }
            object.put(string2, l2);
        }
        if (object.size() == 0) {
            return null;
        }
        object = (LinkedHashMap)MapUtils.sortByValue((Map)object);
        Book book = new Book();
        object = MapUtils.getLast((Map)object);
        book.setMd5((String)object.getKey());
        book.setReadingTime((Long)object.getValue());
        return book;
    }

    public static Book getMostCarefullyBook(List<OnyxStatisticsModel> statisticsModels) {
        HashMap hashMap;
        Object object = hashMap;
        hashMap = new HashMap();
        Iterator<OnyxStatisticsModel> iterator = statisticsModels.iterator();
        while (iterator.hasNext()) {
            String string2 = iterator.next().getMd5();
            long l2 = 1L;
            if (object.containsKey(string2)) {
                l2 = (Long)object.get(string2) + 1L;
            }
            object.put(string2, l2);
        }
        if (object.size() == 0) {
            return null;
        }
        object = (LinkedHashMap)MapUtils.sortByValue((Map)object);
        Book book = new Book();
        book.setMd5((String)MapUtils.getLast((Map)object).getKey());
        return book;
    }

    /*
     * WARNING - void declaration
     */
    public static List<Book> converToBooks(List<OnyxStatisticsModel> statisticsModels, int count) {
        ArrayList<String> arrayList;
        ArrayList<Book> arrayList2;
        ArrayList<Book> arrayList3 = arrayList2;
        arrayList2 = new ArrayList<Book>();
        ArrayList<String> arrayList4 = arrayList;
        arrayList = new ArrayList<String>();
        for (OnyxStatisticsModel onyxStatisticsModel : statisticsModels) {
            Book book;
            void var1_1;
            if (arrayList3.size() >= var1_1) break;
            String string2 = onyxStatisticsModel.getMd5();
            if (arrayList4.contains(string2)) continue;
            arrayList4.add(string2);
            Book book2 = book;
            book2();
            book2.setMd5(string2);
            book2.setId(onyxStatisticsModel.getId());
            book2.setHideRecord(onyxStatisticsModel.isHideRecord());
            book2.setName(onyxStatisticsModel.getName());
            book2.setEnd(onyxStatisticsModel.getEventTime());
            book.setPath(onyxStatisticsModel.getPath());
            arrayList3.add(book);
        }
        arrayList4.clear();
        return arrayList3;
    }

    public static long getAnnotationCount(String accountID) {
        String string2;
        return StatisticsUtils.filterAnnotation((List)StatisticsUtils.loadStatisticsList(2, string2));
    }

    public static long filterAnnotation(List<OnyxStatisticsModel> onyxStatisticsModels) {
        LinkedHashMap<String, Long> linkedHashMap;
        List<OnyxStatisticsModel> list;
        for (int i2 = 0; i2 < list.size(); ++i2) {
            if (!list.get(i2).getAction().equals("delete")) continue;
            list.remove(i2);
        }
        LinkedHashMap<String, Long> linkedHashMap2 = linkedHashMap;
        linkedHashMap = new LinkedHashMap<String, Long>();
        for (int i3 = 0; i3 < list.size(); ++i3) {
            String string2 = list.get(i3).getOrgText();
            long l2 = 1L;
            if (linkedHashMap2.containsKey(string2)) {
                l2 = (Long)linkedHashMap2.get(string2) + 1L;
            }
            linkedHashMap2.put(string2, l2);
        }
        return linkedHashMap2.size();
    }

    public static List<Integer> getReadDistribute(Collection<OnyxStatisticsModel> statisticsModels) {
        ArrayList<Integer> arrayList;
        int n2;
        Iterator<OnyxStatisticsModel> iterator;
        TreeMap<Integer, Integer> treeMap;
        TreeMap<Integer, Long> treeMap2;
        TreeMap<Integer, Long> treeMap3 = treeMap2;
        treeMap2 = new TreeMap<Integer, Long>();
        TreeMap<Integer, Integer> treeMap4 = treeMap;
        treeMap = new TreeMap<Integer, Integer>();
        for (int i2 = 0; i2 < 24; ++i2) {
            treeMap3.put(i2, 0L);
        }
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            Object object = (OnyxStatisticsModel)iterator.next();
            Date date = ((BaseStatisticsModel)object).getEventTime();
            n2 = date.getYear() + date.getMonth() + date.getDay();
            Integer n3 = (Integer)treeMap4.get(n2);
            if (n3 == null) {
                n3 = 0;
            }
            treeMap4.put(n2, n3 + 1);
            int n4 = date.getHours();
            if (n4 <= -1) continue;
            object = ((OnyxStatisticsModel)object).getDurationTime();
            Long l2 = (Long)treeMap3.get(n4);
            treeMap3.put(n4, l2 + (Long)object);
        }
        int n5 = treeMap4.size();
        ArrayList<Integer> arrayList2 = arrayList;
        arrayList = new ArrayList<Integer>();
        Iterator iterator2 = treeMap3.entrySet().iterator();
        while (iterator2.hasNext()) {
            n2 = 0;
            long l3 = (Long)iterator2.next().getValue();
            if (n5 > 0) {
                n2 = (int)(l3 / (long)n5 / 60000L);
            }
            arrayList2.add(n2);
        }
        treeMap4.clear();
        treeMap3.clear();
        return arrayList2;
    }
}

