/*
 * Decompiled with CFR 0.152.
 */
package com.onyx.android.sdk.data.utils;

import android.content.Context;
import android.graphics.Bitmap;
import com.onyx.android.sdk.data.Constant;
import com.onyx.android.sdk.data.GAdapter;
import com.onyx.android.sdk.data.GAdapterUtil;
import com.onyx.android.sdk.data.GObject;
import com.onyx.android.sdk.data.model.BaseData;
import com.onyx.android.sdk.data.model.Category;
import com.onyx.android.sdk.data.model.Dictionary;
import com.onyx.android.sdk.data.model.Link;
import com.onyx.android.sdk.data.model.Product;
import com.onyx.android.sdk.data.model.ProductResult;
import com.onyx.android.sdk.data.utils.CloudConf;
import com.onyx.android.sdk.device.EnvironmentUtil;
import com.onyx.android.sdk.utils.CollectionUtils;
import com.onyx.android.sdk.utils.FileUtils;
import com.onyx.android.sdk.utils.StringUtils;
import java.io.File;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import retrofit2.Response;

public class CloudUtils {
    private static String a;
    private static final String b = "Bearer ";

    public static final String cloudBaseDir() {
        Object object = a;
        if (object != null) {
            return object;
        }
        object = EnvironmentUtil.getExternalStorageDirectory();
        if (object == null) {
            a = "/mnt/sdcard/cloud";
        } else {
            if (!((File)object).exists()) {
                ((File)object).mkdirs();
            }
            a = new File((File)object, "cloud").getAbsolutePath();
        }
        return a;
    }

    /*
     * WARNING - void declaration
     */
    public static File baseDataDir(Context context, String id) {
        void var1_1;
        File file;
        File file2 = file;
        if (!new File(CloudUtils.cloudBaseDir(), (String)var1_1).exists()) {
            file2.mkdirs();
        }
        return file2;
    }

    /*
     * WARNING - void declaration
     */
    public static File imageCacheDirectory(Context context, String id) {
        void var1_1;
        return CloudUtils.baseDataDir(context, (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static File dataCacheDirectory(Context context, String id) {
        void var1_1;
        return CloudUtils.baseDataDir(context, (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static File imageCachePath(Context context, String idString) {
        void var1_1;
        Context context2;
        if (StringUtils.isNullOrEmpty((String)idString)) {
            return null;
        }
        return new File(CloudUtils.imageCacheDirectory(context2, (String)var1_1), "cover.png");
    }

    /*
     * WARNING - void declaration
     */
    public static File imageCachePath(Context context, String idString, String name) {
        void var2_2;
        if (!StringUtils.isNullOrEmpty((String)idString) && !StringUtils.isNullOrEmpty((String)var2_2)) {
            void var1_1;
            Context context2;
            return new File(CloudUtils.imageCacheDirectory(context2, (String)var1_1), (String)var2_2 + ".png");
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static File dataCachePath(Context context, String idString, String title, String ext) {
        void var1_1;
        Context context2;
        String string2;
        void var3_3;
        if (StringUtils.isNullOrEmpty((String)idString)) {
            return null;
        }
        string2 = !var3_3.startsWith(".") ? string2 + "." + (String)var3_3 : string2 + (String)var3_3;
        return new File(CloudUtils.dataCacheDirectory(context2, (String)var1_1), string2);
    }

    /*
     * WARNING - void declaration
     */
    public static Bitmap localCoverCache(Context context, String idString) {
        void var1_1;
        CloudUtils.imageCachePath(context, (String)var1_1).exists();
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static Bitmap localCoverBitmap(Context context, String idString) {
        void var1_1;
        CloudUtils.imageCachePath(context, (String)var1_1).exists();
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean updateFilePath(Context context, Product product, GObject object) {
        Map<String, Map<String, Link>> map = product.storage;
        if (CollectionUtils.isNullOrEmpty(map)) {
            return false;
        }
        map = map.entrySet().iterator();
        while (map.hasNext()) {
            void var2_2;
            String string2;
            Context context2;
            void var1_1;
            void v0 = var1_1;
            Object object2 = (Map.Entry)map.next();
            String string3 = v0.getIdString();
            object2 = CloudUtils.dataCachePath(context2, string3, string2 = v0.title, (String)object2.getKey());
            if (object2 == null || !((File)object2).exists()) continue;
            var2_2.putString("path", ((File)object2).getAbsolutePath());
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean updateThumbnail(Context context, Product product, GObject object) {
        void var1_1;
        File file = CloudUtils.imageCachePath(context, var1_1.getIdString());
        return file != null && file.exists();
    }

    /*
     * WARNING - void declaration
     */
    public static final String getCoverUrl(Product product, CloudConf cloudConf) {
        void var1_1;
        Object object;
        Object object2 = product.covers.get("gray");
        if (CollectionUtils.isNullOrEmpty(object2)) {
            object = ((Product)((Object)object)).coverUrl;
            if (object != null) {
                if (!((String)object).startsWith(var1_1.getHostBase())) {
                    object = var1_1.getHostBase() + (String)object;
                }
                return object;
            }
            return "";
        }
        if ((object2 = object2.get(var1_1.getCloudStorage())) == null) {
            object = ((Product)((Object)object)).coverUrl;
            if (object != null) {
                if (!((String)object).startsWith(var1_1.getHostBase())) {
                    object = var1_1.getHostBase() + (String)object;
                }
                return object;
            }
            return "";
        }
        return ((Link)((Object)object2)).url;
    }

    /*
     * WARNING - void declaration
     */
    public static GObject objectFromProduct(Context context, Product product, boolean loadThumbnail, CloudConf cloudConf) {
        Context context2;
        void var2_2;
        void var3_4;
        void var1_1;
        GObject gObject;
        if (product == null) {
            return null;
        }
        GObject gObject2 = gObject;
        gObject2();
        gObject2.putString("id", var1_1.getIdString());
        gObject2.putString("title_string", var1_1.title);
        gObject.putString("cover_url", CloudUtils.getCoverUrl((Product)var1_1, (CloudConf)var3_4));
        gObject.putObject("origin_obj", (Object)var1_1);
        if (var2_2 != false) {
            CloudUtils.updateThumbnail(context2, (Product)var1_1, gObject2);
        }
        CloudUtils.updateFilePath(context2, (Product)var1_1, gObject2);
        return gObject2;
    }

    /*
     * WARNING - void declaration
     */
    public static GObject objectFromDictionary(Context context, Dictionary dictionary, boolean loadThumbnail, CloudConf cloudConf) {
        Context context2;
        void var2_2;
        void var3_4;
        void var1_1;
        GObject gObject;
        if (dictionary == null) {
            return null;
        }
        GObject gObject2 = gObject;
        gObject2();
        gObject2.putString("id", var1_1.getIdString());
        gObject2.putString("title_string", var1_1.title);
        gObject.putString("cover_url", CloudUtils.getCoverUrl((Product)var1_1, (CloudConf)var3_4));
        gObject.putObject("origin_obj", (Object)var1_1);
        if (var2_2 != false) {
            CloudUtils.updateThumbnail(context2, (Product)var1_1, gObject2);
        }
        CloudUtils.updateFilePath(context2, (Product)var1_1, gObject2);
        return gObject2;
    }

    public static GObject objectFromContainer(Category container) {
        Category category;
        GObject gObject;
        if (container == null) {
            return null;
        }
        GObject gObject2 = gObject;
        gObject2();
        gObject2.putString("id", category.getIdString());
        gObject.putString("title_string", category.name);
        gObject.putObject("origin_obj", (Object)category);
        return gObject;
    }

    public static GAdapter adapterFromContainerResult(ProductResult<Category> result) {
        Iterator iterator;
        GAdapter gAdapter;
        GAdapter gAdapter2 = gAdapter;
        gAdapter = new GAdapter();
        if (result != null && (iterator = ((ProductResult)((Object)iterator)).list) != null) {
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                gAdapter2.addObject(CloudUtils.objectFromContainer((Category)((Object)iterator.next())));
            }
            return gAdapter2;
        }
        return gAdapter2;
    }

    /*
     * WARNING - void declaration
     */
    public static GAdapter adapterFromProductResult(Context context, ProductResult<Product> result, int limit, CloudConf cloudConf) {
        List list;
        GAdapter gAdapter;
        GAdapter gAdapter2 = gAdapter;
        gAdapter = new GAdapter();
        if (result != null && (list = ((ProductResult)((Object)list)).list) != null) {
            int n2 = 0;
            for (Product product : list) {
                void var3_4;
                Context context2;
                void var2_3;
                boolean bl = n2++ < var2_3;
                gAdapter2.addObject(CloudUtils.objectFromProduct(context2, product, bl, (CloudConf)var3_4));
            }
            return gAdapter2;
        }
        return gAdapter2;
    }

    /*
     * WARNING - void declaration
     */
    public static GAdapter adapterFromDictionaryResult(Context context, ProductResult<Dictionary> result, int limit, CloudConf cloudConf) {
        List list;
        GAdapter gAdapter;
        GAdapter gAdapter2 = gAdapter;
        gAdapter = new GAdapter();
        if (result != null && (list = ((ProductResult)((Object)list)).list) != null) {
            int n2 = 0;
            for (Dictionary dictionary : list) {
                void var3_4;
                Context context2;
                void var2_3;
                boolean bl = n2++ < var2_3;
                gAdapter2.addObject(CloudUtils.objectFromDictionary(context2, dictionary, bl, (CloudConf)var3_4));
            }
            return gAdapter2;
        }
        return gAdapter2;
    }

    public static Product originProduct(GObject object) {
        Object object2 = GAdapterUtil.getOriginObject((GObject)object);
        Product product = null;
        if (object2 instanceof Product) {
            product = (Product)((Object)object2);
        }
        return product;
    }

    public static <T extends BaseData> boolean isEmpty(ProductResult<T> productResult) {
        Object object;
        return productResult == null || (object = ((ProductResult)object).list) == null || object.size() <= 0;
        {
        }
    }

    public static void dumpResponseMessage(String tag, Response<ProductResult<Product>> response, boolean debug) {
    }

    public static String getBearerToken(String token) {
        String string2;
        return b + string2;
    }

    /*
     * WARNING - void declaration
     */
    public static void updateDevHost(int cloudType, CloudConf cloudConf) {
        block2: {
            void var1_1;
            block0: {
                block1: {
                    int n2;
                    if (cloudType == 2) break block0;
                    if (n2 == 5) break block1;
                    if (n2 == 6) break block0;
                    break block2;
                }
                CloudUtils.b((CloudConf)var1_1);
                break block2;
            }
            CloudUtils.a((CloudConf)var1_1);
        }
    }

    private static void a(CloudConf cloudConf) {
        CloudConf cloudConf2;
        if (Constant.USE_DEV_HOST) {
            cloudConf2.setHostBase("http://dev.send2boox.com").setApiBase("http://dev.send2boox.com/api/1/");
            return;
        }
        if (!FileUtils.fileExist((String)Constant.ACCOUNT_DEV_HOST_FILE_PATH)) {
            return;
        }
        String string2 = FileUtils.readContentOfFile((String)Constant.ACCOUNT_DEV_HOST_FILE_PATH);
        if (StringUtils.isNullOrEmpty((String)string2)) {
            return;
        }
        cloudConf2.setHostBase(string2).setApiBase(string2 + Constant.API_1);
    }

    private static void b(CloudConf cloudConf) {
        CloudConf cloudConf2;
        if (!Constant.USE_DEV_HOST) {
            return;
        }
        cloudConf2.setHostBase("http://dev.send2boox.com").setApiBase("http://dev.send2boox.com/api/1/");
    }
}

