/*
 * Decompiled with CFR 0.152.
 */
package com.onyx.android.sdk.data.request.cloud;

import android.content.Context;
import com.onyx.android.sdk.data.CloudManager;
import com.onyx.android.sdk.data.model.Book;
import com.onyx.android.sdk.data.model.EventTypeAggBean;
import com.onyx.android.sdk.data.model.StatisticsResult;
import com.onyx.android.sdk.data.model.account.OnyxAccountModel;
import com.onyx.android.sdk.data.provider.DataProviderManager;
import com.onyx.android.sdk.data.request.cloud.BaseCloudRequest;
import com.onyx.android.sdk.data.utils.ReaderStatistiscUtils;
import com.onyx.android.sdk.data.v1.ServiceFactory;
import com.onyx.android.sdk.utils.NetworkUtil;
import com.onyx.android.sdk.utils.StringUtils;
import java.util.List;
import retrofit2.Response;

public class GetStatisticsRequest
extends BaseCloudRequest {
    private static final String j = "GetStatisticsRequest";
    public static final int RECENT_BOOK_MAX_COUNT = 5;
    private Context g;
    private StatisticsResult h;
    private String i;

    /*
     * WARNING - void declaration
     */
    public GetStatisticsRequest(CloudManager cloudManager, Context context, String url) {
        super((CloudManager)var1_1);
        void var3_3;
        void var2_2;
        void var1_1;
        this.g = var2_2;
        this.i = var3_3;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void a(CloudManager parent) throws Exception {
        if (StringUtils.isNullOrEmpty((String)this.i)) {
            return;
        }
        String string2 = NetworkUtil.getMacAddress((Context)this.g);
        if (StringUtils.isNullOrEmpty((String)string2)) {
            return;
        }
        try {
            GetStatisticsRequest getStatisticsRequest = this;
            Response<StatisticsResult> response = getStatisticsRequest.executeCall(ServiceFactory.getStatisticsService(getStatisticsRequest.i).getStatistics(string2));
            if (response != null && response.isSuccessful()) {
                StatisticsResult statisticsResult = (StatisticsResult)response.body();
                this.h = statisticsResult;
                statisticsResult.setMyEventHourlyAgg(this.f());
                if (!this.h.isEmpty()) return;
                this.g();
                return;
            }
            this.g();
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.g();
        }
    }

    private void g() {
        Object object = DataProviderManager.getLocalAccountProvider().getLoggedInAccount();
        String string2 = "";
        if (object != null && ((OnyxAccountModel)((Object)object)).isLoggedIn()) {
            string2 = String.valueOf(((OnyxAccountModel)((Object)object)).getAccountId());
        }
        GetStatisticsRequest getStatisticsRequest = this;
        object = getStatisticsRequest.h.getEventTypeAgg();
        this.h.setTotalReadTime(this.d(string2));
        ((EventTypeAggBean)object).setRead(this.c(string2));
        ((EventTypeAggBean)object).setFinish(this.b(string2));
        ((EventTypeAggBean)object).setAnnotation((int)this.a(string2));
        ((EventTypeAggBean)object).setTextSelect(this.e());
        getStatisticsRequest.h.setMyEventHourlyAgg(this.f());
        getStatisticsRequest.h.setDailyAvgReadTime(this.d());
        getStatisticsRequest.h.setLongestReadTimeBook(this.a());
        getStatisticsRequest.h.setMostCarefulBook(this.c());
        getStatisticsRequest.h.setRecentReadingBooks(this.getRecentBooks(string2, 5));
    }

    private long d(String accountID) {
        return ReaderStatistiscUtils.getLocalTotalReadSeconds(accountID);
    }

    private int c(String accountID) {
        return ReaderStatistiscUtils.getLocalReadCount(accountID);
    }

    private int b(String accountID) {
        return ReaderStatistiscUtils.getLocalFinishCount(accountID);
    }

    private int b() {
        return ReaderStatistiscUtils.getLocalLookupDicCount();
    }

    private long a(String accountID) {
        return ReaderStatistiscUtils.getLocalAnnotationCount(accountID);
    }

    private int e() {
        return ReaderStatistiscUtils.getLocalSelectTextCount();
    }

    private List<Integer> f() {
        return ReaderStatistiscUtils.getLocalSelfReadTimeDis();
    }

    private long d() {
        return ReaderStatistiscUtils.getLocalReadTimeEveryDay();
    }

    private Book a() {
        return ReaderStatistiscUtils.getLocalLongestBook();
    }

    private Book c() {
        return ReaderStatistiscUtils.getLocalMostCarefullyBook();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void execute(CloudManager parent) throws Exception {
        this.h = new StatisticsResult();
        if (NetworkUtil.isWiFiConnected((Context)this.g)) {
            void var1_1;
            this.a((CloudManager)var1_1);
        } else {
            this.g();
        }
    }

    /*
     * WARNING - void declaration
     */
    public List<Book> getRecentBooks(String accountID, int recentFinishCount) {
        void var2_2;
        return ReaderStatistiscUtils.getLocalRecentFinshBooks(accountID, (int)var2_2);
    }

    public StatisticsResult getStatisticsResult() {
        return this.h;
    }
}

