/*
 * Decompiled with CFR 0.152.
 */
package com.onyx.android.sdk.data.model;

import com.onyx.android.sdk.dataprovider.R;
import com.onyx.android.sdk.device.EnvironmentUtil;
import com.onyx.android.sdk.utils.ExportUtils;
import com.onyx.android.sdk.utils.ResManager;
import com.onyx.android.sdk.utils.StringUtils;
import java.io.File;
import java.util.HashMap;
import java.util.Map;

public class ExtensionMap {
    private static Map<String, String> bookExtensionMap;
    private static Map<String, String> defaultDirectoryNameMap;
    private static Map<String, String> rootDirectoryNameMap;
    private static Map<String, String> directoryTranslatedNameMap;

    public static String getExtension(String key) {
        String string2;
        if (bookExtensionMap == null) {
            bookExtensionMap = new HashMap<String, String>(4);
            bookExtensionMap.put(ResManager.getString((int)R.string.jd_book_novel), ResManager.getString((int)R.string.jd_book_show_extension));
            bookExtensionMap.put(ResManager.getString((int)R.string.jd_book_comic), ResManager.getString((int)R.string.jd_book_show_extension));
            bookExtensionMap.put(ResManager.getString((int)R.string.jd_book_jeb), ResManager.getString((int)R.string.jd_book_show_extension));
            bookExtensionMap.put(null, ResManager.getString((int)R.string.unknown_file_type));
            bookExtensionMap.put("", ResManager.getString((int)R.string.unknown_file_type));
        }
        if (bookExtensionMap.containsKey(string2)) {
            string2 = bookExtensionMap.get(string2);
        }
        return string2;
    }

    public static void updateDirectoryNameMap() {
        if (defaultDirectoryNameMap == null) {
            defaultDirectoryNameMap = new HashMap<String, String>();
        }
        if (rootDirectoryNameMap == null) {
            rootDirectoryNameMap = new HashMap<String, String>();
        }
        if (directoryTranslatedNameMap == null) {
            directoryTranslatedNameMap = new HashMap<String, String>();
        }
        ExtensionMap.updateDefaultDirectoryNameMap();
        ExtensionMap.updateRootDirectoryNameMap();
        ExtensionMap.updateDirectoryTranslatedMap();
    }

    private static Map<String, String> getDefaultDirectoryNameMap() {
        if (defaultDirectoryNameMap == null) {
            defaultDirectoryNameMap = new HashMap<String, String>();
            ExtensionMap.updateDefaultDirectoryNameMap();
        }
        return defaultDirectoryNameMap;
    }

    private static Map<String, String> getRootDirectoryNameMap() {
        if (rootDirectoryNameMap == null) {
            rootDirectoryNameMap = new HashMap<String, String>();
            ExtensionMap.updateRootDirectoryNameMap();
        }
        return rootDirectoryNameMap;
    }

    private static Map<String, String> getDirectoryTranslatedNameMap() {
        if (directoryTranslatedNameMap == null) {
            directoryTranslatedNameMap = new HashMap<String, String>();
            ExtensionMap.updateDirectoryTranslatedMap();
        }
        return directoryTranslatedNameMap;
    }

    public static String getDefaultDirectoryAliasName(File file) {
        return ExtensionMap.getDefaultDirectoryAliasName(file.getAbsolutePath());
    }

    public static String getDefaultDirectoryAliasName(String path) {
        String string2;
        if (ExtensionMap.getDefaultDirectoryNameMap().containsKey(string2)) {
            return ExtensionMap.getDefaultDirectoryNameMap().get(string2);
        }
        return "";
    }

    public static String getRootDirectoryAliasName(File file) {
        return ExtensionMap.getRootDirectoryAliasName(file.getAbsolutePath());
    }

    public static String getRootDirectoryAliasName(String path) {
        String string2;
        if (ExtensionMap.getRootDirectoryNameMap().containsKey(string2)) {
            return ExtensionMap.getRootDirectoryNameMap().get(string2);
        }
        return "";
    }

    public static String getDirectoryTranslatedName(String dirName) {
        String string2;
        if (ExtensionMap.getDirectoryTranslatedNameMap().containsKey(string2)) {
            return ExtensionMap.getDirectoryTranslatedNameMap().get(string2);
        }
        return string2;
    }

    public static String getShowName(File file) {
        String string2 = file.getAbsolutePath();
        String string3 = ExtensionMap.getDefaultDirectoryAliasName(string2);
        if (StringUtils.isNullOrEmpty((String)string3)) {
            string3 = ExtensionMap.getRootDirectoryAliasName(string2);
        }
        if (StringUtils.isNullOrEmpty((String)string3)) {
            string3 = ExtensionMap.getDirectoryTranslatedName(string2);
        }
        if (StringUtils.isNullOrEmpty((String)string3)) {
            File file2;
            string3 = file2.getName();
        }
        return string3;
    }

    private static void updateDefaultDirectoryNameMap() {
        defaultDirectoryNameMap.put(ExportUtils.getNoteDir(), ResManager.getString((int)R.string.note_show_name));
        defaultDirectoryNameMap.put(ExtensionMap.getExternalStorageDirectory() + ResManager.getString((int)R.string.books_file_name), ResManager.getString((int)R.string.books_show_name));
        defaultDirectoryNameMap.put(ExtensionMap.getExternalStorageDirectory() + ResManager.getString((int)R.string.shop_file_name), ResManager.getString((int)R.string.shop_show_name));
        defaultDirectoryNameMap.put(ExtensionMap.getExternalStorageDirectory() + ResManager.getString((int)R.string.push_file_name), ResManager.getString((int)R.string.push_show_name));
        defaultDirectoryNameMap.put(ExtensionMap.getExternalStorageDirectory() + ResManager.getString((int)R.string.download_file_name), ResManager.getString((int)R.string.download_show_name));
        defaultDirectoryNameMap.put(ExtensionMap.getExternalStorageDirectory() + ResManager.getString((int)R.string.wifitransfer_file_name), ResManager.getString((int)R.string.wifitransfer_show_name));
    }

    private static void updateRootDirectoryNameMap() {
        rootDirectoryNameMap.put(EnvironmentUtil.getExternalStorageDirectory().getAbsolutePath(), ResManager.getString((int)R.string.external_storage));
        rootDirectoryNameMap.put("/mnt", ResManager.getString((int)R.string.external_storage));
        File file = EnvironmentUtil.getRemovableSDCardDirectory();
        if (file != null && file.canRead() && file.isDirectory()) {
            rootDirectoryNameMap.put(file.getAbsolutePath(), ResManager.getString((int)R.string.usb_storage));
        }
    }

    private static void updateDirectoryTranslatedMap() {
        directoryTranslatedNameMap.put(ResManager.getString((int)R.string.books_file_name), ResManager.getString((int)R.string.books_show_name));
        directoryTranslatedNameMap.put(ResManager.getString((int)R.string.note_file_name), ResManager.getString((int)R.string.note_show_name));
        directoryTranslatedNameMap.put(ResManager.getString((int)R.string.shop_file_name), ResManager.getString((int)R.string.shop_show_name));
        directoryTranslatedNameMap.put(ResManager.getString((int)R.string.push_file_name), ResManager.getString((int)R.string.push_show_name));
        directoryTranslatedNameMap.put(ResManager.getString((int)R.string.download_file_name), ResManager.getString((int)R.string.download_show_name));
        directoryTranslatedNameMap.put(ResManager.getString((int)R.string.wifitransfer_file_name), ResManager.getString((int)R.string.wifitransfer_show_name));
    }

    private static String getExternalStorageDirectory() {
        return EnvironmentUtil.getExternalStorageDirectory().getPath() + File.separator;
    }
}

