/*
 * Decompiled with CFR 0.152.
 */
package com.onyx.android.sdk.data.compatability;

import android.graphics.Rect;
import android.text.TextUtils;
import android.util.Log;
import com.onyx.android.sdk.utils.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public abstract class SerializationUtil {
    private static final String a = "SerializationUtil";
    public static final String SEPERATOR = ", ";

    public static String dateToString(Date d2) {
        Date date;
        if (d2 == null) {
            return "";
        }
        return date.getTime() + "";
    }

    public static Date dateFromString(String str) {
        String string2;
        if (!StringUtils.isNullOrEmpty((String)str) && !"null".equals(string2)) {
            try {
                return new Date(Long.parseLong(string2));
            }
            catch (NumberFormatException numberFormatException) {
                Log.w((String)a, (Throwable)numberFormatException);
                return null;
            }
        }
        return null;
    }

    public static String authorsToString(ArrayList<String> authors) {
        StringBuilder stringBuilder;
        ArrayList<String> arrayList;
        if (authors == null) {
            return null;
        }
        if (arrayList.size() <= 0) {
            return "";
        }
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder2();
        stringBuilder.append(arrayList.get(0));
        for (int i2 = 1; i2 < arrayList.size(); ++i2) {
            stringBuilder2.append(SEPERATOR).append(arrayList.get(i2));
        }
        return stringBuilder2.toString();
    }

    public static ArrayList<String> authorsFromString(String authorsString) {
        String[] stringArray;
        if (authorsString == null) {
            return null;
        }
        if ((stringArray = stringArray.split(SEPERATOR)) != null && stringArray.length > 0) {
            ArrayList<String> arrayList;
            ArrayList<String> arrayList2 = arrayList;
            arrayList = new ArrayList<String>();
            int n2 = stringArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                arrayList2.add(stringArray[i2]);
            }
            return arrayList2;
        }
        return null;
    }

    public static String tagsToString(ArrayList<String> tags) {
        ArrayList<String> arrayList;
        if (tags == null) {
            return null;
        }
        if (arrayList.size() <= 0) {
            return "";
        }
        return TextUtils.join((CharSequence)SEPERATOR, arrayList);
    }

    public static ArrayList<String> tagsFromString(String tagsString) {
        String[] stringArray;
        if (tagsString == null) {
            return null;
        }
        if ((stringArray = stringArray.split(SEPERATOR)) != null && stringArray.length > 0) {
            ArrayList<String> arrayList;
            ArrayList<String> arrayList2 = arrayList;
            arrayList = new ArrayList<String>();
            int n2 = stringArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                arrayList2.add(stringArray[i2]);
            }
            return arrayList2;
        }
        return null;
    }

    public static String setToString(Collection<String> set) {
        Collection<String> collection;
        if (set == null) {
            return null;
        }
        if (collection.size() <= 0) {
            return "";
        }
        return TextUtils.join((CharSequence)SEPERATOR, collection);
    }

    public static Set<String> setFromString(String string2) {
        String[] stringArray;
        if (string2 == null) {
            return null;
        }
        if ((stringArray = stringArray.split(SEPERATOR)) != null && stringArray.length > 0) {
            return new HashSet<String>(Arrays.asList(stringArray));
        }
        return null;
    }

    public static String pointsToString(ArrayList<Float> points) {
        StringBuilder stringBuilder;
        Serializable serializable = stringBuilder;
        stringBuilder = new StringBuilder();
        boolean bl = true;
        for (Float f2 : points) {
            if (bl) {
                bl = false;
            } else {
                ((StringBuilder)serializable).append(" ");
            }
            ((StringBuilder)serializable).append(f2.toString());
        }
        return ((StringBuilder)serializable).toString();
    }

    public static ArrayList<Float> pointsFromString(String str) {
        String[] stringArray;
        ArrayList<Float> arrayList;
        ArrayList<Float> arrayList2 = arrayList;
        arrayList = new ArrayList<Float>();
        if (StringUtils.isNullOrEmpty((String)str)) {
            return arrayList2;
        }
        stringArray = stringArray.trim().split(" ");
        int n2 = stringArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            arrayList2.add(Float.valueOf(Float.parseFloat(stringArray[i2])));
        }
        return arrayList2;
    }

    /*
     * Loose catch block
     */
    public static byte[] rectsToByteArray(Collection<Rect> rects) {
        DataOutputStream dataOutputStream;
        ByteArrayOutputStream byteArrayOutputStream;
        ByteArrayOutputStream byteArrayOutputStream2;
        if (rects == null) {
            return new byte[0];
        }
        Collection<Rect> collection = byteArrayOutputStream2;
        byteArrayOutputStream2 = byteArrayOutputStream;
        byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream22 = dataOutputStream;
        dataOutputStream = new DataOutputStream(byteArrayOutputStream2);
        Iterator<Rect> iterator = collection.iterator();
        while (true) {
            if (!iterator.hasNext()) break;
            DataOutputStream dataOutputStream3 = dataOutputStream22;
            DataOutputStream dataOutputStream4 = dataOutputStream3;
            DataOutputStream dataOutputStream5 = dataOutputStream3;
            DataOutputStream dataOutputStream6 = dataOutputStream3;
            DataOutputStream dataOutputStream7 = dataOutputStream3;
            Rect rect = iterator.next();
            dataOutputStream4.writeInt(rect.left);
            dataOutputStream5.writeInt(rect.top);
            dataOutputStream6.writeInt(rect.right);
            dataOutputStream7.writeInt(rect.bottom);
            continue;
            break;
        }
        dataOutputStream22.close();
        return byteArrayOutputStream2.toByteArray();
        {
            catch (Throwable throwable) {
                Log.e((String)a, (String)"", (Throwable)throwable);
                return new byte[0];
            }
        }
        catch (Throwable throwable) {
            dataOutputStream22.close();
            throw throwable;
        }
    }

    /*
     * Loose catch block
     */
    public static ArrayList<Rect> rectsFromByteArray(byte[] blob) {
        DataInputStream dataInputStream;
        byte[] byArray;
        ByteArrayInputStream byteArrayInputStream;
        ArrayList<Rect> arrayList;
        ArrayList<Rect> arrayList2 = arrayList;
        arrayList = new ArrayList<Rect>();
        if (blob == null) {
            return arrayList2;
        }
        ByteArrayInputStream byteArrayInputStream2 = byteArrayInputStream;
        byteArrayInputStream = new ByteArrayInputStream(byArray);
        DataInputStream dataInputStream2 = dataInputStream;
        dataInputStream = new DataInputStream(byteArrayInputStream2);
        int n2 = 0;
        while (true) {
            if (n2 >= byArray.length / 16) break;
            ArrayList<Rect> arrayList3 = arrayList2;
            DataInputStream dataInputStream3 = dataInputStream2;
            DataInputStream dataInputStream4 = dataInputStream3;
            DataInputStream dataInputStream5 = dataInputStream3;
            DataInputStream dataInputStream6 = dataInputStream3;
            int n3 = dataInputStream3.readInt();
            int n4 = dataInputStream4.readInt();
            int n5 = dataInputStream5.readInt();
            int n6 = dataInputStream6.readInt();
            arrayList3.add(new Rect(n3, n4, n5, n6));
            ++n2;
        }
        dataInputStream2.close();
        return arrayList2;
        {
            catch (Throwable throwable) {
                Log.e((String)a, (String)"", (Throwable)throwable);
                return arrayList2;
            }
        }
        catch (Throwable throwable) {
            dataInputStream2.close();
            throw throwable;
        }
    }
}

