/*
 * Decompiled with CFR 0.152.
 */
package com.onyx.android.sdk.data.compatability;

import android.content.ContentValues;
import android.database.Cursor;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import android.provider.BaseColumns;
import android.util.Log;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.onyx.android.sdk.data.compatability.CursorUtil;
import com.onyx.android.sdk.data.compatability.OnyxBookProgress;
import com.onyx.android.sdk.data.compatability.SerializationUtil;
import com.onyx.android.sdk.utils.FileUtils;
import com.onyx.android.sdk.utils.StringUtils;
import java.io.File;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class OnyxMetadata
implements Parcelable {
    private static final String TAG = "OnyxMetadata";
    public static final String DB_TABLE_NAME = "library_metadata";
    public static final Uri CONTENT_URI = Uri.parse((String)"content://com.onyx.android.sdk.OnyxCmsProvider/library_metadata");
    private static final int INVALID_ID = -1;
    public static final Parcelable.Creator<OnyxMetadata> CREATOR = new Parcelable.Creator<OnyxMetadata>(){

        /*
         * WARNING - void declaration
         */
        public OnyxMetadata createFromParcel(Parcel source) {
            void var1_1;
            Log.i((String)OnyxMetadata.TAG, (String)"Create metadata from parcel!");
            return new OnyxMetadata((Parcel)var1_1);
        }

        public OnyxMetadata[] newArray(int size) {
            return new OnyxMetadata[size];
        }
    };
    private long mId;
    private String mMD5;
    private String mName;
    private String mTitle;
    private ArrayList<String> mAuthors;
    private String mPublisher;
    private String mLanguage;
    private String mISBN;
    private String mDescription;
    private String mLocation;
    private String mNativeAbsolutePath;
    private long mSize;
    private String mEncoding;
    private Date mLastAccess;
    private Date mLastModified;
    private OnyxBookProgress mProgress;
    private int mFavorite;
    private int mRating;
    private ArrayList<String> mTags;
    private Set<String> series;
    private int libRefCount;
    private JSONObject mExtraAttributes;
    private String mType;
    private String cloudReference;

    public OnyxMetadata() {
        JSONObject jSONObject;
        this_.mId = -1L;
        this_.mMD5 = null;
        this_.mName = null;
        this_.mTitle = null;
        this_.mAuthors = null;
        this_.mPublisher = null;
        this_.mLanguage = null;
        this_.mISBN = null;
        this_.mDescription = null;
        this_.mLocation = null;
        this_.mNativeAbsolutePath = null;
        this_.mSize = 0L;
        this_.mEncoding = null;
        this_.mLastAccess = null;
        this_.mLastModified = null;
        this_.mProgress = null;
        this_.mFavorite = 0;
        this_.mRating = 0;
        this_.mTags = null;
        this_.series = null;
        this_.libRefCount = 0;
        OnyxMetadata this_ = jSONObject;
        jSONObject = new JSONObject();
        v1.mExtraAttributes = this_;
        v1.mType = null;
    }

    /*
     * WARNING - void declaration
     */
    public OnyxMetadata(Parcel source) {
        void var1_1;
        JSONObject jSONObject;
        OnyxMetadata onyxMetadata = this_;
        onyxMetadata.mId = -1L;
        onyxMetadata.mMD5 = null;
        onyxMetadata.mName = null;
        onyxMetadata.mTitle = null;
        onyxMetadata.mAuthors = null;
        onyxMetadata.mPublisher = null;
        onyxMetadata.mLanguage = null;
        onyxMetadata.mISBN = null;
        onyxMetadata.mDescription = null;
        onyxMetadata.mLocation = null;
        onyxMetadata.mNativeAbsolutePath = null;
        onyxMetadata.mSize = 0L;
        onyxMetadata.mEncoding = null;
        onyxMetadata.mLastAccess = null;
        onyxMetadata.mLastModified = null;
        onyxMetadata.mProgress = null;
        onyxMetadata.mFavorite = 0;
        onyxMetadata.mRating = 0;
        onyxMetadata.mTags = null;
        onyxMetadata.series = null;
        onyxMetadata.libRefCount = 0;
        OnyxMetadata this_ = jSONObject;
        jSONObject = new JSONObject();
        onyxMetadata.mExtraAttributes = this_;
        onyxMetadata.mType = null;
        onyxMetadata.readFromParcel((Parcel)var1_1);
    }

    public static OnyxMetadata createFromFile(File file) {
        return OnyxMetadata.createFromFile(file, true);
    }

    public static OnyxMetadata createFromFile(String path) {
        String string2;
        return OnyxMetadata.createFromFile(new File(string2));
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static OnyxMetadata createFromFile(File file, boolean computeMd5) {
        OnyxMetadata onyxMetadata;
        boolean bl;
        try {
            bl = computeMd5;
        }
        catch (IOException iOException) {
            Log.w((String)TAG, (Throwable)iOException);
            return null;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            Log.w((String)TAG, (Throwable)noSuchAlgorithmException);
            return null;
        }
        OnyxMetadata onyxMetadata2 = onyxMetadata;
        {
            File file2;
            onyxMetadata = new OnyxMetadata();
            if (bl) {
                onyxMetadata2.setMD5(FileUtils.computeMD5((File)file2));
            }
            OnyxMetadata onyxMetadata3 = onyxMetadata2;
            OnyxMetadata.getBasicMetadataFromFile(onyxMetadata3, file2);
            return onyxMetadata3;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void getBasicMetadataFromFile(OnyxMetadata data2, File file) {
        void var1_1;
        OnyxMetadata onyxMetadata;
        OnyxMetadata onyxMetadata2 = onyxMetadata;
        onyxMetadata.setName(var1_1.getName());
        onyxMetadata.setLocation(var1_1.getAbsolutePath());
        onyxMetadata.setNativeAbsolutePath(var1_1.getAbsolutePath());
        onyxMetadata2.setSize(var1_1.length());
        onyxMetadata2.setlastModified(new Date(FileUtils.getLastChangeTime((File)var1_1)));
        data2.setType(FileUtils.getFileExtension((String)var1_1.getName()));
    }

    public Object clone() {
        OnyxMetadata onyxMetadata;
        OnyxMetadata onyxMetadata2 = onyxMetadata;
        onyxMetadata2();
        onyxMetadata2.setId(this.mId);
        onyxMetadata2.setMD5(this.mMD5);
        onyxMetadata2.setName(this.mName);
        onyxMetadata2.setTitle(this.mTitle);
        onyxMetadata2.setAuthors(this.mAuthors);
        onyxMetadata2.setPublisher(this.mPublisher);
        onyxMetadata2.setLanguage(this.mLanguage);
        onyxMetadata2.setISBN(this.mISBN);
        onyxMetadata2.setDescription(this.mDescription);
        onyxMetadata2.setLocation(this.mLocation);
        onyxMetadata2.setNativeAbsolutePath(this.mNativeAbsolutePath);
        onyxMetadata2.setSize(this.mSize);
        onyxMetadata2.setEncoding(this.mEncoding);
        onyxMetadata2.setLastAccess(this.mLastAccess);
        onyxMetadata2.setlastModified(this.mLastModified);
        onyxMetadata2.setProgress(this.mProgress);
        onyxMetadata2.setFavorite(this.mFavorite);
        onyxMetadata2.setRating(this.mRating);
        onyxMetadata2.setTags(this.mTags);
        onyxMetadata2.putExtraAttributes((Map<String, Object>)this.mExtraAttributes);
        onyxMetadata2.setType(this.mType);
        onyxMetadata2.setCloudReference(this.cloudReference);
        onyxMetadata2.setSeries(this.series);
        onyxMetadata.setLibRefCount(this.libRefCount);
        return onyxMetadata;
    }

    public boolean isDataFromDB() {
        return this.mId != -1L;
    }

    public long getId() {
        return this.mId;
    }

    /*
     * WARNING - void declaration
     */
    public void setId(long id) {
        void var1_1;
        this.mId = var1_1;
    }

    public String getMD5() {
        return this.mMD5;
    }

    /*
     * WARNING - void declaration
     */
    public void setMD5(String md5) {
        void var1_1;
        this.mMD5 = var1_1;
    }

    public String getName() {
        return this.mName;
    }

    /*
     * WARNING - void declaration
     */
    public void setName(String name) {
        void var1_1;
        this.mName = var1_1;
    }

    public String getTitle() {
        return this.mTitle;
    }

    /*
     * WARNING - void declaration
     */
    public void setTitle(String title) {
        void var1_1;
        this.mTitle = var1_1;
    }

    public ArrayList<String> getAuthors() {
        return this.mAuthors;
    }

    public String getAuthorsString() {
        ArrayList<String> this_ = ((OnyxMetadata)((Object)this_)).mAuthors;
        if (this_ != null) {
            return StringUtils.join((Iterable)this_, (String)",");
        }
        return "";
    }

    /*
     * WARNING - void declaration
     */
    public String getAuthorsStringWithCustomSeparator(String separator) {
        ArrayList<String> this_ = ((OnyxMetadata)((Object)this_)).mAuthors;
        if (this_ != null) {
            void var1_1;
            return StringUtils.join((Iterable)this_, (String)var1_1);
        }
        return "";
    }

    /*
     * WARNING - void declaration
     */
    public void setAuthors(ArrayList<String> authors) {
        void var1_1;
        this.mAuthors = var1_1;
    }

    public String getPublisher() {
        return this.mPublisher;
    }

    /*
     * WARNING - void declaration
     */
    public void setPublisher(String publisher) {
        void var1_1;
        this.mPublisher = var1_1;
    }

    public String getLanguage() {
        return this.mLanguage;
    }

    /*
     * WARNING - void declaration
     */
    public void setLanguage(String language) {
        void var1_1;
        this.mLanguage = var1_1;
    }

    public String getISBN() {
        return this.mISBN;
    }

    /*
     * WARNING - void declaration
     */
    public void setISBN(String isbn) {
        void var1_1;
        this.mISBN = var1_1;
    }

    public String getDescription() {
        return this.mDescription;
    }

    /*
     * WARNING - void declaration
     */
    public void setDescription(String description) {
        void var1_1;
        this.mDescription = var1_1;
    }

    public String getLocation() {
        return this.mLocation;
    }

    /*
     * WARNING - void declaration
     */
    public void setLocation(String location) {
        void var1_1;
        this.mLocation = var1_1;
    }

    public String getNativeAbsolutePath() {
        return this.mNativeAbsolutePath;
    }

    /*
     * WARNING - void declaration
     */
    public void setNativeAbsolutePath(String nativeAbsolutePath) {
        void var1_1;
        this.mNativeAbsolutePath = var1_1;
    }

    public long getSize() {
        return this.mSize;
    }

    /*
     * WARNING - void declaration
     */
    public void setSize(long size) {
        void var1_1;
        this.mSize = var1_1;
    }

    public String getEncoding() {
        return this.mEncoding;
    }

    /*
     * WARNING - void declaration
     */
    public void setEncoding(String encoding) {
        void var1_1;
        this.mEncoding = var1_1;
    }

    public Date getLastAccess() {
        return this.mLastAccess;
    }

    /*
     * WARNING - void declaration
     */
    public void setLastAccess(Date lastAccess) {
        void var1_1;
        this.mLastAccess = var1_1;
    }

    public void updateLastAccess() {
        Date date;
        OnyxMetadata onyxMetadata = this_;
        Date this_ = date;
        date = new Date();
        onyxMetadata.mLastAccess = this_;
    }

    public Date getLastModified() {
        return this.mLastModified;
    }

    /*
     * WARNING - void declaration
     */
    public void setlastModified(Date lastModified) {
        void var1_1;
        this.mLastModified = var1_1;
    }

    public OnyxBookProgress getProgress() {
        return this.mProgress;
    }

    /*
     * WARNING - void declaration
     */
    public void setProgress(OnyxBookProgress progress) {
        void var1_1;
        this.mProgress = var1_1;
    }

    public boolean isReaded() {
        OnyxBookProgress this_ = ((OnyxMetadata)((Object)this_)).mProgress;
        return this_ != null && this_.isFinished();
    }

    public boolean isReading() {
        return this.mProgress != null;
    }

    public boolean isNew() {
        return this.mProgress == null;
    }

    public int getFavorite() {
        return this.mFavorite;
    }

    /*
     * WARNING - void declaration
     */
    public void setFavorite(int favorite) {
        void var1_1;
        this.mFavorite = var1_1;
    }

    public int getRating() {
        return this.mRating;
    }

    /*
     * WARNING - void declaration
     */
    public void setRating(int rating) {
        void var1_1;
        this.mRating = var1_1;
    }

    public ArrayList<String> getTags() {
        return this.mTags;
    }

    /*
     * WARNING - void declaration
     */
    public void setTags(ArrayList<String> tags) {
        void var1_1;
        this.mTags = var1_1;
    }

    public String getTagsString() {
        ArrayList<String> this_ = ((OnyxMetadata)((Object)this_)).mTags;
        if (this_ != null) {
            return StringUtils.join((Iterable)this_, (String)", ");
        }
        return "";
    }

    public JSONObject getExtraAttributes() {
        return this.mExtraAttributes;
    }

    /*
     * WARNING - void declaration
     */
    public void putExtraAttribute(String key, Object value) {
        void var2_2;
        void var1_1;
        this.mExtraAttributes.put((String)var1_1, (Object)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void putExtraAttributes(Map<String, Object> value) {
        if (value != null) {
            void var1_1;
            this.mExtraAttributes.putAll((Map)var1_1);
        }
    }

    public String getType() {
        return this.mType;
    }

    /*
     * WARNING - void declaration
     */
    public void setType(String type) {
        void var1_1;
        this.mType = var1_1;
    }

    public String getCloudReference() {
        return this.cloudReference;
    }

    /*
     * WARNING - void declaration
     */
    public void setCloudReference(String ref) {
        void var1_1;
        this.cloudReference = var1_1;
    }

    public final Set<String> getSeries() {
        return this.series;
    }

    public final String getSeriesString() {
        return SerializationUtil.setToString(this.series);
    }

    /*
     * WARNING - void declaration
     */
    public void setSeries(Set<String> s2) {
        void var1_1;
        this.series = var1_1;
    }

    public int getLibRefCount() {
        return this.libRefCount;
    }

    /*
     * WARNING - void declaration
     */
    public void setLibRefCount(int refCount) {
        void var1_1;
        this.libRefCount = var1_1;
    }

    public int describeContents() {
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    public void writeToParcel(Parcel dest, int flags) {
        void var1_1;
        var1_1.writeLong(this.mId);
        var1_1.writeString(this.mMD5);
        var1_1.writeString(this.mName);
        var1_1.writeString(this.mTitle);
        var1_1.writeStringList(this.mAuthors);
        var1_1.writeString(this.mPublisher);
        var1_1.writeString(this.mLanguage);
        var1_1.writeString(this.mISBN);
        var1_1.writeString(this.mDescription);
        var1_1.writeString(this.mLocation);
        var1_1.writeString(this.mNativeAbsolutePath);
        var1_1.writeLong(this.mSize);
        var1_1.writeString(this.mEncoding);
        var1_1.writeString(SerializationUtil.dateToString(this.mLastAccess));
        var1_1.writeString(SerializationUtil.dateToString(this.mLastModified));
        var1_1.writeInt(this.mFavorite);
        var1_1.writeInt(this.mRating);
        var1_1.writeStringList(this.mTags);
        var1_1.writeString(JSON.toJSONString((Object)this.mExtraAttributes));
        var1_1.writeString(this.mType);
        var1_1.writeString(this.cloudReference);
        Set<String> set = this.series;
        if (set != null && set.size() > 0) {
            var1_1.writeStringList(new ArrayList<String>(this.series));
        }
        var1_1.writeInt(this.libRefCount);
    }

    /*
     * WARNING - void declaration
     */
    public void readFromParcel(Parcel source) {
        ArrayList arrayList;
        ArrayList arrayList2;
        ArrayList arrayList3;
        void var1_1;
        void v0 = var1_1;
        OnyxMetadata onyxMetadata = this;
        void v2 = var1_1;
        OnyxMetadata onyxMetadata2 = this;
        this.mId = var1_1.readLong();
        this.mMD5 = var1_1.readString();
        this.mName = var1_1.readString();
        onyxMetadata2.mTitle = var1_1.readString();
        ArrayList arrayList4 = arrayList3;
        onyxMetadata2.mAuthors = new ArrayList();
        v2.readStringList(arrayList4);
        this.mPublisher = v2.readString();
        this.mLanguage = var1_1.readString();
        this.mISBN = var1_1.readString();
        this.mDescription = var1_1.readString();
        this.mLocation = var1_1.readString();
        this.mNativeAbsolutePath = var1_1.readString();
        this.mSize = var1_1.readLong();
        this.mEncoding = var1_1.readString();
        this.mLastAccess = SerializationUtil.dateFromString(var1_1.readString());
        this.mLastModified = SerializationUtil.dateFromString(var1_1.readString());
        this.mFavorite = var1_1.readInt();
        onyxMetadata.mRating = var1_1.readInt();
        arrayList4 = arrayList2;
        onyxMetadata.mTags = new ArrayList();
        v0.readStringList(arrayList4);
        this.mExtraAttributes = JSON.parseObject((String)v0.readString());
        this.mType = var1_1.readString();
        this.cloudReference = var1_1.readString();
        arrayList4 = arrayList;
        source.readStringList(new ArrayList());
        if (arrayList4.size() > 0) {
            HashSet<String> hashSet;
            HashSet<String> hashSet2 = hashSet;
            hashSet = new HashSet<String>(arrayList4);
            this.series = hashSet2;
        }
        this.libRefCount = var1_1.readInt();
    }

    public static class Columns
    implements BaseColumns {
        public static String MD5 = "MD5";
        public static String NAME = "Name";
        public static String TITLE = "Title";
        public static String AUTHORS = "Authors";
        public static String PUBLISHER = "Publisher";
        public static String LANGUAGE = "Language";
        public static String ISBN = "ISBN";
        public static String DESCRIPTION = "Description";
        public static String LOCATION = "Location";
        public static String NATIVE_ABSOLUTE_PATH = "NativeAbsolutePath";
        public static String SIZE = "Size";
        public static String ENCODING = "Encoding";
        public static String LAST_ACCESS = "LastAccess";
        public static String LAST_MODIFIED = "LastModified";
        public static String PROGRESS = "Progress";
        public static String FAVORITE = "Favorite";
        public static String RATING = "Rating";
        public static String TAGS = "Tags";
        public static String EXTRA_ATTRIBUTES = "ExtraAttributes";
        public static String TYPE = "Type";
        public static String CLOUD_REFERENCE = "CloudReference";
        public static String SERIES = "Series";
        public static String LIB_REF_COUNT = "LibRefCount";
        private static boolean a = false;
        private static int b = -1;
        private static int c = -1;
        private static int d = -1;
        private static int e = -1;
        private static int f = -1;
        private static int g = -1;
        private static int h = -1;
        private static int i = -1;
        private static int j = -1;
        private static int k = -1;
        private static int l = -1;
        private static int m = -1;
        private static int n = -1;
        private static int o = -1;
        private static int p = -1;
        private static int q = -1;
        private static int r = -1;
        private static int s = -1;
        private static int t = -1;
        private static int u = -1;
        private static int v = -1;
        private static int w = -1;
        private static int x = -1;
        private static int y = -1;

        public static ContentValues createColumnData(OnyxMetadata data2) {
            OnyxMetadata onyxMetadata;
            ContentValues contentValues;
            Object object;
            ContentValues contentValues2 = object = contentValues;
            ContentValues contentValues3 = object;
            object();
            String string2 = MD5;
            object.put(string2, onyxMetadata.getMD5());
            string2 = NAME;
            object.put(string2, onyxMetadata.getName());
            string2 = TITLE;
            contentValues3.put(string2, onyxMetadata.getTitle());
            contentValues3.put(AUTHORS, SerializationUtil.authorsToString(onyxMetadata.getAuthors()));
            string2 = PUBLISHER;
            object.put(string2, onyxMetadata.getPublisher());
            string2 = LANGUAGE;
            object.put(string2, onyxMetadata.getLanguage());
            string2 = ISBN;
            object.put(string2, onyxMetadata.getISBN());
            string2 = DESCRIPTION;
            object.put(string2, onyxMetadata.getDescription());
            string2 = LOCATION;
            object.put(string2, onyxMetadata.getLocation());
            string2 = NATIVE_ABSOLUTE_PATH;
            contentValues2.put(string2, onyxMetadata.getNativeAbsolutePath());
            contentValues2.put(SIZE, Long.valueOf(onyxMetadata.getSize()));
            string2 = ENCODING;
            contentValues.put(string2, onyxMetadata.getEncoding());
            string2 = LAST_ACCESS;
            Object object2 = data2.getLastAccess() == null ? null : Long.valueOf(onyxMetadata.getLastAccess().getTime());
            object.put(string2, (Long)object2);
            string2 = LAST_MODIFIED;
            object2 = onyxMetadata.getLastModified() == null ? null : Long.valueOf(onyxMetadata.getLastModified().getTime());
            object.put(string2, (Long)object2);
            string2 = PROGRESS;
            object2 = onyxMetadata.getProgress() == null ? null : onyxMetadata.getProgress().toString();
            ContentValues contentValues4 = object;
            ContentValues contentValues5 = object;
            ContentValues contentValues6 = object;
            contentValues6.put(string2, (String)object2);
            contentValues6.put(FAVORITE, Integer.valueOf(onyxMetadata.getFavorite()));
            contentValues6.put(RATING, Integer.valueOf(onyxMetadata.getRating()));
            contentValues6.put(TAGS, SerializationUtil.tagsToString(onyxMetadata.getTags()));
            contentValues6.put(EXTRA_ATTRIBUTES, JSON.toJSONString((Object)onyxMetadata.getExtraAttributes()));
            object = TYPE;
            contentValues5.put((String)object, onyxMetadata.getType());
            object = CLOUD_REFERENCE;
            contentValues4.put((String)object, onyxMetadata.getCloudReference());
            contentValues4.put(SERIES, SerializationUtil.setToString(onyxMetadata.getSeries()));
            contentValues4.put(LIB_REF_COUNT, Integer.valueOf(onyxMetadata.getLibRefCount()));
            return contentValues4;
        }

        /*
         * WARNING - void declaration
         */
        public static void readColumnData(Cursor c2, OnyxMetadata data2) {
            void var1_1;
            JSONObject jSONObject;
            Object object;
            if (!a) {
                Cursor cursor = object;
                b = cursor.getColumnIndex("_id");
                c = cursor.getColumnIndex(MD5);
                d = cursor.getColumnIndex(NAME);
                e = cursor.getColumnIndex(TITLE);
                f = cursor.getColumnIndex(AUTHORS);
                g = cursor.getColumnIndex(PUBLISHER);
                h = cursor.getColumnIndex(LANGUAGE);
                i = cursor.getColumnIndex(ISBN);
                j = cursor.getColumnIndex(DESCRIPTION);
                k = cursor.getColumnIndex(LOCATION);
                l = cursor.getColumnIndex(NATIVE_ABSOLUTE_PATH);
                m = cursor.getColumnIndex(SIZE);
                n = cursor.getColumnIndex(ENCODING);
                o = cursor.getColumnIndex(LAST_ACCESS);
                p = cursor.getColumnIndex(LAST_MODIFIED);
                q = cursor.getColumnIndex(PROGRESS);
                r = cursor.getColumnIndex(FAVORITE);
                s = cursor.getColumnIndex(RATING);
                t = cursor.getColumnIndex(TAGS);
                u = cursor.getColumnIndex(EXTRA_ATTRIBUTES);
                v = cursor.getColumnIndex(TYPE);
                w = cursor.getColumnIndex(CLOUD_REFERENCE);
                x = cursor.getColumnIndex(SERIES);
                y = cursor.getColumnIndex(LIB_REF_COUNT);
                a = true;
            }
            Cursor cursor = object;
            long l2 = CursorUtil.getLong(cursor, b);
            String string2 = CursorUtil.getString(cursor, c);
            String string3 = CursorUtil.getString(cursor, d);
            String string4 = CursorUtil.getString(cursor, e);
            String string5 = CursorUtil.getString(cursor, f);
            String string6 = CursorUtil.getString(cursor, g);
            String string7 = CursorUtil.getString(cursor, h);
            String string8 = CursorUtil.getString(cursor, i);
            String string9 = CursorUtil.getString(cursor, j);
            String string10 = CursorUtil.getString(cursor, k);
            String string11 = CursorUtil.getString(cursor, l);
            Long l3 = CursorUtil.getLong(cursor, m);
            String string12 = CursorUtil.getString(cursor, n);
            Long l4 = CursorUtil.getLong(cursor, o);
            Long l5 = CursorUtil.getLong(cursor, p);
            OnyxBookProgress onyxBookProgress = OnyxBookProgress.fromString(CursorUtil.getString(cursor, q));
            int n2 = cursor.getInt(r);
            int n3 = cursor.getInt(s);
            String string13 = CursorUtil.getString(cursor, t);
            String string14 = CursorUtil.getString(cursor, w);
            String string15 = CursorUtil.getString(cursor, x);
            int n4 = cursor.getInt(y);
            try {
                jSONObject = (JSONObject)JSON.parseObject((String)CursorUtil.getString(cursor, u), JSONObject.class);
            }
            catch (Throwable throwable) {
                JSONObject jSONObject2;
                jSONObject = jSONObject2;
                jSONObject2 = new JSONObject();
            }
            object = CursorUtil.getString(object, v);
            var1_1.setId(l2);
            var1_1.setMD5(string2);
            var1_1.setName(string3);
            var1_1.setTitle(string4);
            var1_1.setAuthors(SerializationUtil.authorsFromString(string5));
            var1_1.setPublisher(string6);
            var1_1.setLanguage(string7);
            var1_1.setISBN(string8);
            var1_1.setDescription(string9);
            var1_1.setLocation(string10);
            var1_1.setNativeAbsolutePath(string11);
            if (l4 != null && l4 > 0L) {
                var1_1.setLastAccess(new Date(l4));
            }
            long l6 = l5 == null ? 0L : l5;
            Date date = new Date(l6);
            var1_1.setlastModified(date);
            long l7 = l3 == null ? 0L : l3;
            var1_1.setSize(l7);
            var1_1.setEncoding(string12);
            var1_1.setProgress(onyxBookProgress);
            var1_1.setFavorite(n2);
            var1_1.setRating(n3);
            var1_1.setTags(SerializationUtil.tagsFromString(string13));
            var1_1.putExtraAttributes((Map<String, Object>)jSONObject);
            var1_1.setType((String)object);
            var1_1.setCloudReference(string14);
            var1_1.setSeries(SerializationUtil.setFromString(string15));
            var1_1.setLibRefCount(n4);
        }

        public static OnyxMetadata readColumnData(Cursor c2) {
            Cursor cursor;
            OnyxMetadata onyxMetadata;
            OnyxMetadata onyxMetadata2 = onyxMetadata;
            onyxMetadata2();
            Columns.readColumnData(cursor, onyxMetadata2);
            return onyxMetadata;
        }
    }
}

