/*
 * Decompiled with CFR 0.152.
 */
package com.onyx.android.sdk.data;

import android.support.annotation.NonNull;
import android.util.Log;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.annotation.JSONField;
import com.onyx.android.sdk.data.BookFilter;
import com.onyx.android.sdk.data.SortBy;
import com.onyx.android.sdk.data.SortOrder;
import com.onyx.android.sdk.utils.CollectionUtils;
import com.onyx.android.sdk.utils.StringUtils;
import com.raizlabs.android.dbflow.annotation.Collate;
import com.raizlabs.android.dbflow.sql.language.BaseOperator;
import com.raizlabs.android.dbflow.sql.language.OperatorGroup;
import com.raizlabs.android.dbflow.sql.language.OrderBy;
import com.raizlabs.android.dbflow.sql.language.SQLOperator;
import com.raizlabs.android.dbflow.sql.language.property.IProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class QueryArgs
implements Serializable {
    private static final String a = QueryArgs.class.getSimpleName();
    public static int CLOUD_FETCH_LIMIT = 50;
    public static final String DEVICE_LIBRARY = "deviceLibrary";
    public static final String RECENT_READ = "recentRead";
    public static final String RECENT_ADDED = "recentAdded";
    public int offset = 0;
    public int limit = Integer.MAX_VALUE;
    @JSONField(serialize=false, deserialize=false)
    public OperatorGroup conditionGroup = OperatorGroup.clause();
    @JSONField(serialize=false, deserialize=false)
    public List<IProperty> propertyList = new ArrayList<IProperty>();
    @JSONField(serialize=false, deserialize=false)
    public List<OrderBy> orderByList = new ArrayList<OrderBy>();
    public String libraryUniqueId = null;
    public BookFilter filter = BookFilter.ALL;
    public SortBy sortBy = SortBy.Name;
    public SortOrder order = SortOrder.Desc;
    public Set<String> fileType = new HashSet<String>();
    public Set<String> author = new HashSet<String>();
    public Set<String> title = new HashSet<String>();
    public Set<String> tags = new HashSet<String>();
    public Set<String> series = new HashSet<String>();
    public Set<String> category = new HashSet<String>();
    public String query;
    public int fetchPolicy = 4;
    public String cloudToken;
    public boolean useTitle;

    public QueryArgs() {
    }

    /*
     * WARNING - void declaration
     */
    public QueryArgs(SortBy sortBy, SortOrder order) {
        void var2_2;
        if (sortBy != null) {
            void var1_1;
            this.sortBy = var1_1;
        }
        if (var2_2 != null) {
            this.order = var2_2;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static QueryArgs queryBy(OperatorGroup conditionGroup, OrderBy orderBy) {
        void var1_1;
        OperatorGroup operatorGroup;
        QueryArgs queryArgs = new QueryArgs();
        queryArgs.conditionGroup = operatorGroup;
        queryArgs.orderByList.add(var1_1.collate(Collate.LOCALIZED));
        return queryArgs;
    }

    /*
     * WARNING - void declaration
     */
    public static QueryArgs queryBy(OperatorGroup conditionGroup, List<OrderBy> orderByList) {
        void var1_1;
        OperatorGroup operatorGroup;
        QueryArgs queryArgs = new QueryArgs();
        queryArgs.conditionGroup = operatorGroup;
        queryArgs.orderByList.addAll((Collection<OrderBy>)var1_1);
        return queryArgs;
    }

    /*
     * WARNING - void declaration
     */
    public static QueryArgs queryBy(OperatorGroup conditionGroup, OrderBy orderBy, int offset, int limit) {
        void var1_1;
        void var3_3;
        void var2_2;
        QueryArgs.queryBy(conditionGroup, (OrderBy)var1_1).offset = var2_2;
        QueryArgs.queryBy(conditionGroup, (OrderBy)var1_1).limit = var3_3;
        return QueryArgs.queryBy(conditionGroup, (OrderBy)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static QueryArgs queryBy(OperatorGroup conditionGroup, List<OrderBy> orderByList, int offset, int limit) {
        void var1_1;
        void var3_3;
        void var2_2;
        QueryArgs.queryBy(conditionGroup, (List<OrderBy>)var1_1).offset = var2_2;
        QueryArgs.queryBy(conditionGroup, (List<OrderBy>)var1_1).limit = var3_3;
        return QueryArgs.queryBy(conditionGroup, (List<OrderBy>)var1_1);
    }

    public static QueryArgs queryBy(OperatorGroup conditionGroup) {
        OperatorGroup operatorGroup;
        new QueryArgs().conditionGroup = operatorGroup;
        return new QueryArgs();
    }

    public static final QueryArgs fromQueryString(String string2) {
        try {
            return (QueryArgs)JSON.parseObject((String)string2, QueryArgs.class);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static final String toQueryString(QueryArgs args) {
        return JSON.toJSONString((Object)args);
    }

    /*
     * WARNING - void declaration
     */
    public QueryArgs appendOrderBy(OrderBy orderBy) {
        void var1_1;
        QueryArgs queryArgs = this;
        queryArgs.orderByList.add(var1_1.collate(Collate.LOCALIZED));
        return queryArgs;
    }

    /*
     * WARNING - void declaration
     */
    public QueryArgs appendProperty(IProperty property) {
        void var1_1;
        QueryArgs queryArgs = this;
        queryArgs.propertyList.add((IProperty)var1_1);
        return queryArgs;
    }

    /*
     * WARNING - void declaration
     */
    public QueryArgs andWith(OperatorGroup otherGroup) {
        void var1_1;
        QueryArgs queryArgs = this;
        queryArgs.conditionGroup.and((SQLOperator)var1_1);
        return queryArgs;
    }

    /*
     * WARNING - void declaration
     */
    public QueryArgs andWith(BaseOperator operator) {
        void var1_1;
        QueryArgs queryArgs = this;
        queryArgs.conditionGroup.and((SQLOperator)var1_1);
        return queryArgs;
    }

    /*
     * WARNING - void declaration
     */
    public QueryArgs orWith(OperatorGroup otherGroup) {
        void var1_1;
        QueryArgs queryArgs = this;
        queryArgs.conditionGroup.or((SQLOperator)var1_1);
        return queryArgs;
    }

    /*
     * WARNING - void declaration
     */
    public QueryArgs orWith(BaseOperator operator) {
        void var1_1;
        QueryArgs queryArgs = this;
        queryArgs.conditionGroup.or((SQLOperator)var1_1);
        return queryArgs;
    }

    /*
     * WARNING - void declaration
     */
    public QueryArgs appendFilter(BookFilter filter) {
        void var1_1;
        this.filter = var1_1;
        return this;
    }

    public boolean equals(Object object) {
        QueryArgs queryArgs;
        if (object == null) {
            return false;
        }
        if (!(queryArgs instanceof QueryArgs)) {
            return false;
        }
        queryArgs = queryArgs;
        if (!CollectionUtils.equals(queryArgs.fileType, this.fileType)) {
            return false;
        }
        if (!CollectionUtils.equals(queryArgs.title, this.title)) {
            return false;
        }
        if (!CollectionUtils.equals(queryArgs.author, this.author)) {
            return false;
        }
        if (!CollectionUtils.equals(queryArgs.tags, this.tags)) {
            return false;
        }
        return CollectionUtils.equals(queryArgs.series, this.series);
    }

    @JSONField(serialize=false, deserialize=false)
    public boolean isAllSetContentEmpty() {
        if (!CollectionUtils.isNullOrEmpty(this.fileType)) {
            return false;
        }
        if (!CollectionUtils.isNullOrEmpty(this.title)) {
            return false;
        }
        if (!CollectionUtils.isNullOrEmpty(this.author)) {
            return false;
        }
        if (!CollectionUtils.isNullOrEmpty(this.tags)) {
            return false;
        }
        return CollectionUtils.isNullOrEmpty(this.series);
    }

    @JSONField(serialize=false, deserialize=false)
    public String getOrderByQuery() {
        if (CollectionUtils.isNullOrEmpty(((QueryArgs)this_).orderByList)) {
            return null;
        }
        QueryArgs queryArgs = this_;
        Object this_ = "";
        for (OrderBy orderBy : queryArgs.orderByList) {
            if (StringUtils.isNotBlank((String)this_)) {
                this_ = (String)this_ + ",";
            }
            this_ = (String)this_ + orderBy.collate(Collate.LOCALIZED).getQuery();
        }
        return this_;
    }

    @JSONField(serialize=false, deserialize=false)
    public String getLimitOffsetQuery() {
        return " LIMIT " + this.limit + " OFFSET " + this.offset + " ";
    }

    @JSONField(serialize=false, deserialize=false)
    public String getOrderByQueryWithLimitOffset() {
        QueryArgs queryArgs = this_;
        String this_ = queryArgs.getOrderByQuery();
        String string2 = queryArgs.getLimitOffsetQuery();
        if (StringUtils.isNullOrEmpty((String)this_)) {
            Log.w((String)a, (String)"NULL orderBy detected, offset and limit does not work.");
            return null;
        }
        return (String)this_ + string2;
    }

    @JSONField(serialize=false, deserialize=false)
    public String[] getProjectionSet() {
        if (CollectionUtils.isNullOrEmpty(this.propertyList)) {
            return null;
        }
        String[] stringArray = new String[this.propertyList.size()];
        for (int i2 = 0; i2 < this.propertyList.size(); ++i2) {
            stringArray[i2] = this.propertyList.get(i2).getQuery();
        }
        return stringArray;
    }

    @JSONField(serialize=false, deserialize=false)
    public int getCloudFetchLimit() {
        int n2 = this.limit;
        int n3 = CLOUD_FETCH_LIMIT;
        if (n2 > n3) {
            n3 = n2;
        }
        return n3;
    }

    public QueryArgs resetOffset() {
        return this.setOffset(0);
    }

    /*
     * WARNING - void declaration
     */
    public QueryArgs setOffset(int offset) {
        void var1_1;
        this.offset = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public QueryArgs setLimit(int limit) {
        void var1_1;
        this.limit = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public QueryArgs setLibraryUniqueId(String libraryId) {
        void var1_1;
        this.libraryUniqueId = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public QueryArgs setSortByOrder(SortBy sortBy, SortOrder sortOrder) {
        void var2_2;
        void var1_1;
        this.sortBy = var1_1;
        this.order = var2_2;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public QueryArgs setQuery(String query) {
        void var1_1;
        this.query = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public QueryArgs setConditionGroup(OperatorGroup group) {
        void var1_1;
        this.conditionGroup = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public QueryArgs addOrderByList(@NonNull List<OrderBy> list) {
        void var1_1;
        QueryArgs queryArgs = this;
        queryArgs.orderByList.addAll((Collection<OrderBy>)var1_1);
        return queryArgs;
    }

    /*
     * WARNING - void declaration
     */
    public QueryArgs addPropertyList(@NonNull List<IProperty> list) {
        void var1_1;
        QueryArgs queryArgs = this;
        queryArgs.propertyList.addAll((Collection<IProperty>)var1_1);
        return queryArgs;
    }

    /*
     * WARNING - void declaration
     */
    public QueryArgs addFileTypeList(@NonNull Collection<String> list) {
        void var1_1;
        QueryArgs queryArgs = this;
        queryArgs.fileType.addAll((Collection<String>)var1_1);
        return queryArgs;
    }

    /*
     * WARNING - void declaration
     */
    public QueryArgs addAuthorList(@NonNull Collection<String> list) {
        void var1_1;
        QueryArgs queryArgs = this;
        queryArgs.author.addAll((Collection<String>)var1_1);
        return queryArgs;
    }

    /*
     * WARNING - void declaration
     */
    public QueryArgs addTitleList(@NonNull Collection<String> list) {
        void var1_1;
        QueryArgs queryArgs = this;
        queryArgs.title.addAll((Collection<String>)var1_1);
        return queryArgs;
    }

    /*
     * WARNING - void declaration
     */
    public QueryArgs addTagsList(@NonNull Collection<String> list) {
        void var1_1;
        QueryArgs queryArgs = this;
        queryArgs.tags.addAll((Collection<String>)var1_1);
        return queryArgs;
    }

    /*
     * WARNING - void declaration
     */
    public QueryArgs addSeriesList(@NonNull Collection<String> list) {
        void var1_1;
        QueryArgs queryArgs = this;
        queryArgs.series.addAll((Collection<String>)var1_1);
        return queryArgs;
    }

    /*
     * WARNING - void declaration
     */
    public QueryArgs addCategoryList(@NonNull Collection<String> list) {
        void var1_1;
        QueryArgs queryArgs = this;
        queryArgs.category.addAll((Collection<String>)var1_1);
        return queryArgs;
    }

    public QueryArgs useMemCloudDbPolicy() {
        this.fetchPolicy = 4;
        return this;
    }

    public QueryArgs useCloudMemDbPolicy() {
        this.fetchPolicy = 2;
        return this;
    }

    public QueryArgs useCloudOnlyPolicy() {
        this.fetchPolicy = 0;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public QueryArgs setFetchPolicy(int fetchPolicy) {
        void var1_1;
        this.fetchPolicy = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public QueryArgs setUseTitle(boolean useTitle) {
        void var1_1;
        this.useTitle = var1_1;
        return this;
    }

    public QueryArgs copyPart() {
        QueryArgs queryArgs = this;
        SortBy sortBy = queryArgs.sortBy;
        return new QueryArgs(sortBy, queryArgs.order).setLimit(this.limit).setOffset(this.offset).setQuery(this.query).setLibraryUniqueId(this.libraryUniqueId).setConditionGroup(OperatorGroup.nonGroupingClause().and((SQLOperator)this.conditionGroup)).setFetchPolicy(this.fetchPolicy).addOrderByList(this.orderByList).addPropertyList(this.propertyList).addTitleList(this.title).addAuthorList(this.author).addFileTypeList(this.fileType).addTagsList(this.tags).addSeriesList(this.series).addCategoryList(this.category).appendFilter(this.filter).setUseTitle(this.useTitle);
    }
}

